/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.AdditionalDownloadableLibraryProvider;
import com.intellij.webcore.libraries.ui.download.DefaultDownloadableWebLibrariesSource;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadWebLibraryDialog
extends DialogWrapper {
    private JPanel contentPane;
    private JBTable myLibraryTable;
    private JLabel myLibrariesTitle;
    private DownloadableFileSetDescriptionWithUrl myLastSelectedElement;

    public DownloadWebLibraryDialog(@NotNull Project project, LangScriptingContextProvider provider) {
        if (project == null) {
            DownloadWebLibraryDialog.u(0);
        }
        super(project);
        Object[] objectArray = new Object[]{};
        this.u();
        this.setTitle(WebCoreBundle.message((String)"library.download.dialog.title", (Object[])objectArray));
        this.setOKButtonText(WebCoreBundle.message((String)"library.download.dialog.ok.text", (Object[])new Object[0]));
        this.setCancelButtonText(WebCoreBundle.message((String)"library.download.dialog.cancel.text", (Object[])new Object[0]));
        this.setOKActionEnabled(false);
        this.myLibraryTable.setSelectionMode(0);
        DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource> defaultComboBoxModel = new DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource>();
        defaultComboBoxModel.addElement(new DefaultDownloadableWebLibrariesSource(project, provider));
        DownloadableWebLibrariesSource downloadableWebLibrariesSource = AdditionalDownloadableLibraryProvider.getLibrary(project);
        if (downloadableWebLibrariesSource != null) {
            this.myLibrariesTitle.setText(downloadableWebLibrariesSource.getName());
            this.u(project, downloadableWebLibrariesSource, provider);
        }
        this.init();
        TableColumnModel tableColumnModel = this.myLibraryTable.getColumnModel();
        int[] nArray = new int[]{100, 20, 300};
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            tableColumnModel.getColumn(i2).setPreferredWidth(nArray[i2]);
        }
        TableSpeedSearch.installOn((JTable)this.myLibraryTable).setComparator(new SpeedSearchComparator(true));
        this.myLibraryTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e2) {
                TableModel tableModel = DownloadWebLibraryDialog.this.myLibraryTable.getModel();
                if (tableModel instanceof MyLibraryTableModel) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(true);
                    DownloadWebLibraryDialog.this.myLastSelectedElement = ((MyLibraryTableModel)tableModel).getDescriptionAt(DownloadWebLibraryDialog.this.myLibraryTable.getSelectedRow());
                }
            }
        });
    }

    private void u(final @NotNull Project project, final @NotNull DownloadableWebLibrariesSource downloadableWebLibrariesSource, final @NotNull LangScriptingContextProvider langScriptingContextProvider) {
        if (project == null) {
            DownloadWebLibraryDialog.u(1);
        }
        if (downloadableWebLibrariesSource == null) {
            DownloadWebLibraryDialog.u(2);
        }
        if (langScriptingContextProvider == null) {
            DownloadWebLibraryDialog.u(3);
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{WebCoreBundle.message((String)"library.download.dialog.fetching.text", (Object[])new Object[0])}, 1){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setOKActionEnabled(false);
        this.myLibraryTable.setModel((TableModel)defaultTableModel);
        defaultTableModel.setRowCount(15);
        ApplicationManager.getApplication().executeOnPooledThread(() -> downloadableWebLibrariesSource.prepareTableModel(new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl>(){

            public void onSuccess(@NotNull List<? extends DownloadableFileSetDescriptionWithUrl> versions) {
                if (versions == null) {
                    3.u(0);
                }
                if (!versions.isEmpty()) {
                    langScriptingContextProvider.filterExistingLibraries(project, versions);
                    ApplicationManager.getApplication().invokeLater(() -> DownloadWebLibraryDialog.this.myLibraryTable.setModel((TableModel)new MyLibraryTableModel(versions, downloadableWebLibrariesSource.includeVersionColumn())), ModalityState.any());
                }
            }

            public void onError(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    3.u(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> defaultTableModel.setColumnIdentifiers(new Object[]{"Error while fetching list of libraries: " + errorMessage}), ModalityState.any());
            }

            private static /* synthetic */ void u(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "versions";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccess";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Nullable
    protected String getHelpId() {
        return "JavaScript.Libraries";
    }

    protected JComponent createCenterPanel() {
        return this.contentPane;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.contentPane;
    }

    @Nullable
    public DownloadableFileSetDescriptionWithUrl getSelection() {
        return this.myLastSelectedElement;
    }

    private static /* synthetic */ void u(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void u() {
        JLabel jLabel;
        JBTable jBTable;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myLibraryTable = jBTable = new JBTable();
        jBTable.setAutoResizeMode(2);
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.myLibrariesTitle = jLabel = new JLabel();
        this.u(jLabel, DynamicBundle.getBundle((String)"messages/WebCoreBundle", DownloadWebLibraryDialog.class).getString("library.download.no_libraries_available.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private /* synthetic */ void u(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c10);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyLibraryTableModel
    extends AbstractTableModel {
        private final int NAME_COL;
        private final int VERSION_COL;
        private final int URL_COL;
        private final List<? extends DownloadableFileSetDescriptionWithUrl> myDescriptions;
        private final boolean myIncludeVersionColumn;

        @Contract(mutates="param1")
        MyLibraryTableModel(List<? extends DownloadableFileSetDescriptionWithUrl> descriptions, boolean includeVersionColumn) {
            this.myDescriptions = descriptions;
            this.myIncludeVersionColumn = includeVersionColumn;
            this.NAME_COL = 0;
            this.VERSION_COL = this.myIncludeVersionColumn ? 1 : -1;
            this.URL_COL = this.myIncludeVersionColumn ? 2 : 1;
            this.myDescriptions.sort((downloadableFileSetDescription, downloadableFileSetDescription2) -> {
                if (downloadableFileSetDescription.getName().equals(downloadableFileSetDescription2.getName())) {
                    return downloadableFileSetDescription.getVersionString().compareTo(downloadableFileSetDescription2.getVersionString());
                }
                return downloadableFileSetDescription.getName().compareToIgnoreCase(downloadableFileSetDescription2.getName());
            });
        }

        @Override
        public int getRowCount() {
            return this.myDescriptions.size();
        }

        @Override
        public int getColumnCount() {
            return this.myIncludeVersionColumn ? 3 : 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = this.myDescriptions.get(rowIndex);
            if (columnIndex == this.NAME_COL) {
                return downloadableFileSetDescriptionWithUrl.getName();
            }
            if (columnIndex == this.VERSION_COL) {
                return downloadableFileSetDescriptionWithUrl.getVersionString();
            }
            if (columnIndex == this.URL_COL) {
                return downloadableFileSetDescriptionWithUrl.getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            if (column == this.NAME_COL) {
                return WebCoreBundle.message((String)"library.download.dialog.table.name_column.label", (Object[])new Object[0]);
            }
            if (column == this.VERSION_COL) {
                return WebCoreBundle.message((String)"library.download.dialog.table.version_column.label", (Object[])new Object[0]);
            }
            if (column == this.URL_COL) {
                return WebCoreBundle.message((String)"library.download.dialog.table.url_column.label", (Object[])new Object[0]);
            }
            return "";
        }

        @Nullable
        public DownloadableFileSetDescriptionWithUrl getDescriptionAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.myDescriptions.size()) {
                return null;
            }
            return this.myDescriptions.get(rowIndex);
        }
    }
}

