/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui.settings.db;

import com.intellij.jpa.jpb.model.StateConfigurable;
import com.intellij.jpa.jpb.model.config.HibernateEnversConfig;
import com.intellij.jpa.jpb.model.config.HibernateEnversState;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.model.audit.EnversProperties;
import com.intellij.jpa.jpb.model.service.EnversService;
import com.intellij.jpa.jpb.model.ui.component.StudioForm;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import java.awt.event.ItemEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 (2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001(B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u001a\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000f2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0016J\b\u0010 \u001a\u00020\u001eH\u0016J\b\u0010!\u001a\u00020\u0002H\u0014J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0002H\u0014J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0002H\u0014J\b\u0010'\u001a\u00020\u001eH\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/HibernateEnversConfigurable;", "Lcom/intellij/jpa/jpb/model/StateConfigurable;", "Lcom/intellij/jpa/jpb/model/config/HibernateEnversState;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "myHibernateEnversConfig", "Lcom/intellij/jpa/jpb/model/config/HibernateEnversConfig;", "useSpringPropertiesField", "Lcom/intellij/ui/components/JBCheckBox;", "tablePrefixField", "Lcom/intellij/ui/components/JBTextField;", "tableSuffixField", "revisionFieldNameField", "revisionTypeFieldNameField", "defaultSchemaField", "auditVersionField", "trackEntitiesChangedField", "globalWithModifiedFlagField", "modifiedFlagSuffixField", "createComponent", "Ljavax/swing/JComponent;", "initEmptyText", "", "field", "defaultProp", "", "getId", "getDisplayName", "getState", "loadFromState", "state", "useSpringProperties", "", "saveToState", "getHelpTopic", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nHibernateEnversConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HibernateEnversConfigurable.kt\ncom/intellij/liquibase/common/gui/settings/db/HibernateEnversConfigurable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,152:1\n1#2:153\n*E\n"})
public final class HibernateEnversConfigurable
extends StateConfigurable<HibernateEnversState>
implements SearchableConfigurable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HibernateEnversConfig myHibernateEnversConfig;
    @NotNull
    private final JBCheckBox useSpringPropertiesField;
    @NotNull
    private final JBTextField tablePrefixField;
    @NotNull
    private final JBTextField tableSuffixField;
    @NotNull
    private final JBTextField revisionFieldNameField;
    @NotNull
    private final JBTextField revisionTypeFieldNameField;
    @NotNull
    private final JBTextField defaultSchemaField;
    @NotNull
    private final JBCheckBox auditVersionField;
    @NotNull
    private final JBCheckBox trackEntitiesChangedField;
    @NotNull
    private final JBCheckBox globalWithModifiedFlagField;
    @NotNull
    private final JBTextField modifiedFlagSuffixField;
    @NotNull
    private static final String ID = "com.intellij.jpb.ui.settings.db.HibernateEnversConfigurable";
    @NotNull
    private static final String DISPLAY_NAME = "Hibernate Envers";

    public HibernateEnversConfigurable(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.myHibernateEnversConfig = HibernateEnversConfig.Companion.getInstance(this.project);
        this.useSpringPropertiesField = new JBCheckBox(LiquibaseResourceBundle.message("envers.use.spring.properties", new Object[0]));
        this.tablePrefixField = new JBTextField();
        this.tableSuffixField = new JBTextField();
        this.revisionFieldNameField = new JBTextField();
        this.revisionTypeFieldNameField = new JBTextField();
        this.defaultSchemaField = new JBTextField();
        this.auditVersionField = new JBCheckBox(LiquibaseResourceBundle.message("envers.audit.version", new Object[0]));
        this.trackEntitiesChangedField = new JBCheckBox(LiquibaseResourceBundle.message("envers.track.entities.changed", new Object[0]));
        this.globalWithModifiedFlagField = new JBCheckBox(LiquibaseResourceBundle.message("envers.global.with.modified.flag", new Object[0]));
        this.modifiedFlagSuffixField = new JBTextField();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public JComponent createComponent() {
        this.useSpringPropertiesField.addItemListener(arg_0 -> HibernateEnversConfigurable.createComponent$lambda$0(this, arg_0));
        this.tablePrefixField.getDocument().addDocumentListener(this.documentListener);
        this.tableSuffixField.getDocument().addDocumentListener(this.documentListener);
        this.revisionFieldNameField.getDocument().addDocumentListener(this.documentListener);
        this.revisionTypeFieldNameField.getDocument().addDocumentListener(this.documentListener);
        this.defaultSchemaField.getDocument().addDocumentListener(this.documentListener);
        this.auditVersionField.addItemListener(arg_0 -> HibernateEnversConfigurable.createComponent$lambda$1(this, arg_0));
        this.trackEntitiesChangedField.addItemListener(arg_0 -> HibernateEnversConfigurable.createComponent$lambda$2(this, arg_0));
        this.globalWithModifiedFlagField.addItemListener(arg_0 -> HibernateEnversConfigurable.createComponent$lambda$3(this, arg_0));
        this.modifiedFlagSuffixField.getDocument().addDocumentListener(this.documentListener);
        EnversProperties defaultProperties = new EnversProperties(null, null, null, null, null, null, false, false, false, null, 1023, null);
        this.initEmptyText(this.tablePrefixField, defaultProperties.getAuditTablePrefix());
        this.initEmptyText(this.tableSuffixField, defaultProperties.getAuditTableSuffix());
        this.initEmptyText(this.revisionFieldNameField, defaultProperties.getRevisionFieldName());
        this.initEmptyText(this.revisionTypeFieldNameField, defaultProperties.getRevisionTypeFieldName());
        this.initEmptyText(this.defaultSchemaField, defaultProperties.getDefaultSchema());
        this.initEmptyText(this.modifiedFlagSuffixField, defaultProperties.getModifiedFlagSuffix());
        StudioForm studioForm = StudioForm.addComponent$default((StudioForm)new StudioForm(), (JComponent)((JComponent)this.useSpringPropertiesField), null, (int)2, null);
        String string = LiquibaseResourceBundle.messageWithColon("audit.table.prefix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"messageWithColon(...)");
        StudioForm studioForm2 = StudioForm.addLabeledComponent$default((StudioForm)studioForm, (String)string, (JComponent)((JComponent)this.tablePrefixField), null, null, null, (int)28, null);
        String string2 = LiquibaseResourceBundle.messageWithColon("audit.table.suffix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"messageWithColon(...)");
        StudioForm studioForm3 = StudioForm.addLabeledComponent$default((StudioForm)studioForm2, (String)string2, (JComponent)((JComponent)this.tableSuffixField), null, null, null, (int)28, null);
        String string3 = LiquibaseResourceBundle.messageWithColon("envers.revision.field.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"messageWithColon(...)");
        StudioForm studioForm4 = StudioForm.addLabeledComponent$default((StudioForm)studioForm3, (String)string3, (JComponent)((JComponent)this.revisionFieldNameField), null, null, null, (int)28, null);
        String string4 = LiquibaseResourceBundle.messageWithColon("envers.revision.type.field.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"messageWithColon(...)");
        StudioForm studioForm5 = StudioForm.addLabeledComponent$default((StudioForm)studioForm4, (String)string4, (JComponent)((JComponent)this.revisionTypeFieldNameField), null, null, null, (int)28, null);
        String string5 = LiquibaseResourceBundle.messageWithColon("envers.default.schema", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"messageWithColon(...)");
        StudioForm studioForm6 = StudioForm.addComponent$default((StudioForm)StudioForm.addComponent$default((StudioForm)StudioForm.addComponent$default((StudioForm)StudioForm.addLabeledComponent$default((StudioForm)studioForm5, (String)string5, (JComponent)((JComponent)this.defaultSchemaField), null, null, null, (int)28, null), (JComponent)((JComponent)this.auditVersionField), null, (int)2, null), (JComponent)((JComponent)this.trackEntitiesChangedField), null, (int)2, null), (JComponent)((JComponent)this.globalWithModifiedFlagField), null, (int)2, null);
        String string6 = LiquibaseResourceBundle.messageWithColon("envers.modified.flag.suffix", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"messageWithColon(...)");
        return (JComponent)StudioForm.addLabeledComponent$default((StudioForm)studioForm6, (String)string6, (JComponent)((JComponent)this.modifiedFlagSuffixField), null, null, null, (int)28, null);
    }

    private final void initEmptyText(JBTextField field, String defaultProp) {
        CharSequence charSequence;
        field.getEmptyText().setText("Use by default: " + ((charSequence = (CharSequence)defaultProp) == null || StringsKt.isBlank((CharSequence)charSequence) ? "<empty>" : defaultProp));
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    protected HibernateEnversState getState() {
        return this.myHibernateEnversConfig.getState();
    }

    protected void loadFromState(@NotNull HibernateEnversState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        boolean useSpringProperties = state.getUseSpringProperties();
        this.useSpringPropertiesField.setSelected(useSpringProperties);
        this.loadFromState(useSpringProperties);
    }

    private final void loadFromState(boolean useSpringProperties) {
        HibernateEnversState usedState = useSpringProperties ? EnversService.Companion.getInstance(this.project).getSpringEnversProperties() : this.getState();
        this.tablePrefixField.setEnabled(!useSpringProperties);
        this.tablePrefixField.setText(usedState.getAuditTablePrefix());
        this.tableSuffixField.setEnabled(!useSpringProperties);
        this.tableSuffixField.setText(usedState.getAuditTableSuffix());
        this.revisionFieldNameField.setEnabled(!useSpringProperties);
        this.revisionFieldNameField.setText(usedState.getRevisionFieldName());
        this.revisionTypeFieldNameField.setEnabled(!useSpringProperties);
        this.revisionTypeFieldNameField.setText(usedState.getRevisionTypeFieldName());
        this.defaultSchemaField.setEnabled(!useSpringProperties);
        this.defaultSchemaField.setText(usedState.getDefaultSchema());
        this.auditVersionField.setEnabled(!useSpringProperties);
        this.auditVersionField.setSelected(usedState.isAuditVersion());
        this.trackEntitiesChangedField.setEnabled(!useSpringProperties);
        this.trackEntitiesChangedField.setSelected(usedState.getTrackEntitiesChanged());
        this.globalWithModifiedFlagField.setEnabled(!useSpringProperties);
        this.globalWithModifiedFlagField.setSelected(usedState.getGlobalWithModifiedFlag());
        this.modifiedFlagSuffixField.setEnabled(!useSpringProperties && usedState.getGlobalWithModifiedFlag());
        this.modifiedFlagSuffixField.setText(usedState.getModifiedFlagSuffix());
    }

    protected void saveToState(@NotNull HibernateEnversState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        state.setUseSpringProperties(this.useSpringPropertiesField.isSelected());
        if (!this.useSpringPropertiesField.isSelected()) {
            CharSequence charSequence;
            CharSequence charSequence2;
            CharSequence charSequence3;
            CharSequence charSequence4;
            CharSequence charSequence5;
            CharSequence charSequence6;
            HibernateEnversState hibernateEnversState;
            HibernateEnversState hibernateEnversState2 = state;
            CharSequence charSequence7 = this.tablePrefixField.getText();
            if (charSequence7.length() == 0) {
                hibernateEnversState = hibernateEnversState2;
                boolean bl = false;
                charSequence6 = null;
                hibernateEnversState2 = hibernateEnversState;
            } else {
                charSequence6 = charSequence7;
            }
            hibernateEnversState2.setAuditTablePrefix((String)charSequence6);
            HibernateEnversState hibernateEnversState3 = state;
            charSequence7 = this.tableSuffixField.getText();
            if (charSequence7.length() == 0) {
                hibernateEnversState = hibernateEnversState3;
                boolean bl = false;
                charSequence5 = null;
                hibernateEnversState3 = hibernateEnversState;
            } else {
                charSequence5 = charSequence7;
            }
            hibernateEnversState3.setAuditTableSuffix((String)charSequence5);
            HibernateEnversState hibernateEnversState4 = state;
            charSequence7 = this.revisionFieldNameField.getText();
            if (charSequence7.length() == 0) {
                hibernateEnversState = hibernateEnversState4;
                boolean bl = false;
                charSequence4 = null;
                hibernateEnversState4 = hibernateEnversState;
            } else {
                charSequence4 = charSequence7;
            }
            hibernateEnversState4.setRevisionFieldName((String)charSequence4);
            HibernateEnversState hibernateEnversState5 = state;
            charSequence7 = this.revisionTypeFieldNameField.getText();
            if (charSequence7.length() == 0) {
                hibernateEnversState = hibernateEnversState5;
                boolean bl = false;
                charSequence3 = null;
                hibernateEnversState5 = hibernateEnversState;
            } else {
                charSequence3 = charSequence7;
            }
            hibernateEnversState5.setRevisionTypeFieldName((String)charSequence3);
            HibernateEnversState hibernateEnversState6 = state;
            charSequence7 = this.defaultSchemaField.getText();
            if (charSequence7.length() == 0) {
                hibernateEnversState = hibernateEnversState6;
                boolean bl = false;
                charSequence2 = null;
                hibernateEnversState6 = hibernateEnversState;
            } else {
                charSequence2 = charSequence7;
            }
            hibernateEnversState6.setDefaultSchema((String)charSequence2);
            state.setAuditVersion(this.auditVersionField.isSelected());
            state.setTrackEntitiesChanged(this.trackEntitiesChangedField.isSelected());
            state.setAuditVersion(this.auditVersionField.isSelected());
            state.setGlobalWithModifiedFlag(this.globalWithModifiedFlagField.isSelected());
            HibernateEnversState hibernateEnversState7 = state;
            charSequence7 = this.modifiedFlagSuffixField.getText();
            if (charSequence7.length() == 0) {
                hibernateEnversState = hibernateEnversState7;
                boolean bl = false;
                charSequence = null;
                hibernateEnversState7 = hibernateEnversState;
            } else {
                charSequence = charSequence7;
            }
            hibernateEnversState7.setModifiedFlagSuffix((String)charSequence);
        }
    }

    @NotNull
    public String getHelpTopic() {
        return JpaHelpConstants.Jboss.INSTANCE.getHibernateEnvers();
    }

    private static final void createComponent$lambda$0(HibernateEnversConfigurable this$0, ItemEvent it) {
        this$0.isModified = true;
        this$0.loadFromState(this$0.useSpringPropertiesField.isSelected());
    }

    private static final void createComponent$lambda$1(HibernateEnversConfigurable this$0, ItemEvent it) {
        this$0.isModified = true;
    }

    private static final void createComponent$lambda$2(HibernateEnversConfigurable this$0, ItemEvent it) {
        this$0.isModified = true;
    }

    private static final void createComponent$lambda$3(HibernateEnversConfigurable this$0, ItemEvent it) {
        this$0.isModified = true;
        this$0.modifiedFlagSuffixField.setEnabled(!this$0.useSpringPropertiesField.isSelected() && this$0.globalWithModifiedFlagField.isSelected());
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/HibernateEnversConfigurable$Companion;", "", "<init>", "()V", "ID", "", "getID", "()Ljava/lang/String;", "DISPLAY_NAME", "getDISPLAY_NAME", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getID() {
            return ID;
        }

        @NotNull
        public final String getDISPLAY_NAME() {
            return DISPLAY_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

