/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner.startup;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ApplicationKt;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfigKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaException;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.startup.QodanaModuleImportersServiceKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a,\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0002\u001a(\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00050\u00032\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u0005H\u0002\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"loadQodanaConfig", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "autoDetectImporters", "", "Lcom/intellij/projectImport/ProjectOpenProcessor;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectPath", "Ljava/nio/file/Path;", "scanDepthLimit", "", "searchImportersFor", "rootJavaProjects", "findProjectOpenProcessors", "", "virtualFile", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaModuleImportersService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaModuleImportersService.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/startup/QodanaModuleImportersServiceKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,87:1\n1285#2,2:88\n1299#2,4:90\n1387#2:94\n1475#2,5:95\n1504#2:100\n1534#2,3:101\n1537#2,3:111\n1252#2,4:116\n774#2:120\n865#2,2:121\n382#3,7:104\n463#3:114\n413#3:115\n*S KotlinDebug\n*F\n+ 1 QodanaModuleImportersService.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/startup/QodanaModuleImportersServiceKt\n*L\n48#1:88,2\n48#1:90,4\n77#1:94\n77#1:95,5\n78#1:100\n78#1:101,3\n78#1:111,3\n79#1:116,4\n83#1:120\n83#1:121,2\n78#1:104,7\n79#1:114\n79#1:115\n*E\n"})
public final class QodanaModuleImportersServiceKt {
    private static final QodanaConfig loadQodanaConfig() {
        QodanaConfig qodanaConfig = QodanaConfigKt.getQodanaAnalysisConfigForConfiguration(ApplicationKt.getApplication());
        if (qodanaConfig == null) {
            throw new QodanaException("Qodana configuration not found");
        }
        return qodanaConfig;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<ProjectOpenProcessor, List<VirtualFile>> autoDetectImporters(Path projectPath, int scanDepthLimit) {
        VirtualFile virtualFile = VfsUtil.findFile((Path)projectPath.normalize(), (boolean)true);
        if (virtualFile == null) {
            return MapsKt.emptyMap();
        }
        VirtualFile projectVirtualFile = virtualFile;
        if (VirtualFileUtil.isFile((VirtualFile)projectVirtualFile)) {
            void $this$associateWithTo$iv$iv;
            Iterable $this$associateWith$iv = QodanaModuleImportersServiceKt.findProjectOpenProcessors(projectVirtualFile);
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
            Iterable iterable = $this$associateWith$iv;
            Map destination$iv$iv = result$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                ProjectOpenProcessor projectOpenProcessor = (ProjectOpenProcessor)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                List list2 = CollectionsKt.listOf((Object)projectVirtualFile);
                map2.put(t, list2);
            }
            return destination$iv$iv;
        }
        Map providersAndFiles = new LinkedHashMap();
        VirtualFileVisitor.Option[] optionArray = new VirtualFileVisitor.Option[]{VirtualFileVisitor.NO_FOLLOW_SYMLINKS, VirtualFileVisitor.limit((int)scanDepthLimit)};
        VirtualFileVisitor.Option[] optionArray2 = optionArray;
        VfsUtil.visitChildrenRecursively((VirtualFile)projectVirtualFile, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Void>((Map<ProjectOpenProcessor, List<VirtualFile>>)providersAndFiles, optionArray2){
            final /* synthetic */ Map<ProjectOpenProcessor, List<VirtualFile>> $providersAndFiles;
            {
                this.$providersAndFiles = $providersAndFiles;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public VirtualFileVisitor.Result visitFileEx(VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (file2.isDirectory()) {
                    VirtualFile it;
                    void $this$filterTo$iv$iv;
                    if (Intrinsics.areEqual((Object)file2.getName(), (Object)".idea") || FileTypeRegistry.getInstance().isFileIgnored(file2)) {
                        VirtualFileVisitor.Result result2 = VirtualFileVisitor.SKIP_CHILDREN;
                        Intrinsics.checkNotNullExpressionValue((Object)result2, (String)"SKIP_CHILDREN");
                        return result2;
                    }
                    VirtualFile[] virtualFileArray = file2.getChildren();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
                    Object[] $this$filter$iv = virtualFileArray;
                    boolean $i$f$filter = false;
                    Object[] objectArray = $this$filter$iv;
                    Iterable<E> destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (void element$iv$iv : $this$filterTo$iv$iv) {
                        it = (VirtualFile)element$iv$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)it);
                        if (!VirtualFileUtil.isFile((VirtualFile)it)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List childrenFiles = (List)destination$iv$iv;
                    boolean projectFileCandidatesFound = false;
                    for (VirtualFile childFile : childrenFiles) {
                        void $this$forEach$iv;
                        Intrinsics.checkNotNull((Object)childFile);
                        destination$iv$iv = QodanaModuleImportersServiceKt.access$findProjectOpenProcessors(childFile);
                        Map<ProjectOpenProcessor, List<VirtualFile>> map2 = this.$providersAndFiles;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (ProjectOpenProcessor)element$iv;
                            boolean bl = false;
                            map2.computeIfAbsent((ProjectOpenProcessor)it, (Function<ProjectOpenProcessor, List<VirtualFile>>)autoDetectImporters.visitFileEx.1.1.INSTANCE).add(childFile);
                            projectFileCandidatesFound = true;
                        }
                    }
                    if (projectFileCandidatesFound) {
                        VirtualFileVisitor.Result result3 = VirtualFileVisitor.SKIP_CHILDREN;
                        Intrinsics.checkNotNullExpressionValue((Object)result3, (String)"SKIP_CHILDREN");
                        return result3;
                    }
                }
                VirtualFileVisitor.Result result4 = VirtualFileVisitor.CONTINUE;
                Intrinsics.checkNotNullExpressionValue((Object)result4, (String)"CONTINUE");
                return result4;
            }
        }));
        return providersAndFiles;
    }

    static /* synthetic */ Map autoDetectImporters$default(Path path, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return QodanaModuleImportersServiceKt.autoDetectImporters(path, n);
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<ProjectOpenProcessor, List<VirtualFile>> searchImportersFor(List<? extends Path> rootJavaProjects) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Object object;
        Map.Entry $this$getOrPut$iv$iv$iv;
        Object $this$groupByTo$iv$iv;
        Object list$iv$iv;
        Object it;
        Iterable $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = rootJavaProjects;
        boolean $i$f$flatMapSequence = false;
        Iterable iterable = $this$flatMap$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapSequenceTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (Path)element$iv$iv;
            boolean bl = false;
            list$iv$iv = MapsKt.asSequence((Map)QodanaModuleImportersServiceKt.autoDetectImporters$default((Path)it, 0, 2, null));
            CollectionsKt.addAll((Collection)destination$iv$iv, (Sequence)list$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$flatMapTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Object object2 = $this$groupByTo$iv$iv.iterator();
        while (object2.hasNext()) {
            void it2;
            Object object3;
            Object element$iv$iv;
            element$iv$iv = object2.next();
            it = (Map.Entry)element$iv$iv;
            boolean $i$a$-groupBy-QodanaModuleImportersServiceKt$searchImportersFor$42 = false;
            ProjectOpenProcessor key$iv$iv = (ProjectOpenProcessor)it.getKey();
            Object object4 = destination$iv$iv;
            ProjectOpenProcessor key$iv$iv$iv = key$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                object3 = answer$iv$iv$iv;
            } else {
                object3 = value$iv$iv$iv;
            }
            list$iv$iv = (List)object3;
            Map.Entry $i$a$-groupBy-QodanaModuleImportersServiceKt$searchImportersFor$42 = (Map.Entry)element$iv$iv;
            object = list$iv$iv;
            boolean bl = false;
            object.add((List)it2.getValue());
        }
        Object $this$mapValues$iv = destination$iv$iv;
        boolean $i$f$mapValues = false;
        $this$groupByTo$iv$iv = $this$mapValues$iv;
        destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        object2 = $this$mapValuesTo$iv$iv.entrySet();
        Object destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            $this$getOrPut$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
            Object object5 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = object5;
            boolean bl2 = false;
            List values = (List)entry.getValue();
            List list2 = CollectionsKt.flatten((Iterable)values);
            object.put(k, list2);
        }
        return destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<ProjectOpenProcessor> findProjectOpenProcessors(VirtualFile virtualFile) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = ProjectOpenProcessor.EXTENSION_POINT_NAME.getExtensionList();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ProjectOpenProcessor it = (ProjectOpenProcessor)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof PlatformProjectOpenProcessor) && it.canOpenProject(virtualFile))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ QodanaConfig access$loadQodanaConfig() {
        return QodanaModuleImportersServiceKt.loadQodanaConfig();
    }

    public static final /* synthetic */ Map access$searchImportersFor(List rootJavaProjects) {
        return QodanaModuleImportersServiceKt.searchImportersFor(rootJavaProjects);
    }

    public static final /* synthetic */ Map access$autoDetectImporters(Path projectPath, int scanDepthLimit) {
        return QodanaModuleImportersServiceKt.autoDetectImporters(projectPath, scanDepthLimit);
    }

    public static final /* synthetic */ Set access$findProjectOpenProcessors(VirtualFile virtualFile) {
        return QodanaModuleImportersServiceKt.findProjectOpenProcessors(virtualFile);
    }
}

