/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n23#3:393\n23#3:394\n23#3:395\n23#3:396\n23#3:397\n23#3:398\n23#3:399\n23#3:400\n23#3:401\n23#3:402\n23#3:403\n23#3:404\n23#3:405\n23#3:406\n23#3:407\n23#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 26288346723776L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(1148173200 - (char)-8954, 1148042130 + (char)-3773, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(1148173200 - (char)-8955, -1148173200 - -((char)-10314), (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 120908108927279L;
                thread = Thread.currentThread();
                ActionTimestamp[] actionTimestampArray = SshAgentIpcService.A();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (actionTimestampArray == null) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl2 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-484565790 + -25211, 484565790 + 10410, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-484565790 + -25212, -484565790 + -((char)-28609), (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-484565790 + -25217, 484565790 + 21388, (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        long l2;
        block14: {
            block15: {
                ActionTimestamp[] actionTimestampArray;
                l2 = 140623315411806L;
                Object object = this.lock;
                synchronized (object) {
                    boolean bl;
                    actionTimestampArray = SshAgentIpcService.A();
                    boolean bl2 = false;
                    try {
                        bl = this.connectionThread == null;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl3 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-1791202620 - -7501, 1791202620 - 7288, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1791202620 - -7502, 1791202620 - 15146, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.connectionThread = Thread.currentThread();
                    Unit unit = Unit.INSTANCE;
                }
                try {
                    try {
                        WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1791202620 - -7503, 1791202620 - (char)-31194, (int)l2));
                        this.hPipe = hANDLE;
                        windowsNamedPipeAgentIpc = this;
                        if (actionTimestampArray == null) break block14;
                        if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                        }
                        break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1791202620 - -7512, -1791202620 - -22141, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1791202620 - -7513, 1791202620 - 7121, (int)l2) + ErrorToolsKt.kernel32LastError());
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            this.state = NamedPipeState.Open;
            windowsNamedPipeAgentIpc = this;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
        boolean bl = false;
        try {
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1791202620 - -7514, 1791202620 - 15076, (int)l2));
            logger.info(WindowsNamedPipeAgentIpc.b(-1791202620 - -7512, -1791202620 - -22141, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1791202620 - -7515, 1791202620 - (char)-31326, (int)l2));
            if (ActionTimestamp.A() == null) {
                SshAgentIpcService.A(new ActionTimestamp[4]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
    }

    @Override
    public boolean isOpen() {
        int n2;
        block8: {
            block7: {
                ActionTimestamp[] actionTimestampArray;
                block6: {
                    long l2 = 116215303347849L;
                    actionTimestampArray = SshAgentIpcService.A();
                    try {
                        try {
                            n2 = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (actionTimestampArray == null) break block6;
                            if (n2 < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (actionTimestampArray == null) break block8;
                    if (n2 > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n2 = 1;
                break block8;
            }
            n2 = 0;
        }
        return n2 != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        Object object;
        Object object2;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block27: {
            block28: {
                l2 = 85614738610500L;
                this.assertConnectionThread();
                Object object3 = this.lock;
                actionTimestampArray = SshAgentIpcService.A();
                synchronized (object3) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block25: {
                        block26: {
                            boolean bl2 = false;
                            try {
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (actionTimestampArray == null) break block25;
                                if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block26;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2580, 1139391510 + (char)-13357, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2576, 1139522580 - (char)-16199, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2579, 1139522580 - (char)-12666, (int)l2) + this.state);
                            throw new ClosedChannelException();
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Open;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2576, 1139522580 - (char)-16199, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2582, -1139522580 - -((char)-15839), (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Connecting;
                    Unit unit = Unit.INSTANCE;
                }
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2580, 1139391510 + (char)-13357, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2576, 1139522580 - (char)-16199, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2581, -1139522580 - -((char)-904), (int)l2));
                    object2 = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block27;
                    if (object2.ConnectNamedPipe(this.hPipe, null)) break block28;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                int n2 = Kernel32.INSTANCE.GetLastError();
                if (n2 == 535) {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                    boolean bl5 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2580, 1139391510 + (char)-13357, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2576, 1139522580 - (char)-16199, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2552, -1139391510 + -((char)-11938), (int)l2));
                } else {
                    throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2576, 1139522580 - (char)-16199, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2551, 1139522580 - (char)-17016, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n2)).toString());
                }
            }
            object2 = this.lock;
        }
        Kernel32 kernel32 = object2;
        synchronized (kernel32) {
            boolean bl;
            NamedPipeState namedPipeState;
            NamedPipeState namedPipeState3;
            block29: {
                block30: {
                    boolean bl6 = false;
                    namedPipeState3 = this.state;
                    namedPipeState = NamedPipeState.Closing;
                    if (actionTimestampArray == null) break block29;
                    try {
                        block31: {
                            if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block30;
                            break block31;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                namedPipeState3 = this.state;
                namedPipeState = NamedPipeState.Connecting;
            }
            try {
                bl = namedPipeState3 == namedPipeState;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
            }
            if (!bl) {
                boolean bl7 = false;
                String string = WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2576, 1139522580 - (char)-16199, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2582, -1139522580 - -((char)-15839), (int)l2) + this.state;
                throw new IllegalArgumentException(string.toString());
            }
            this.state = NamedPipeState.Connected;
            object = Unit.INSTANCE;
        }
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2580, 1139391510 + (char)-13357, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2576, 1139522580 - (char)-16199, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(1139391510 + (char)-2554, -1139522580 - -((char)-2605), (int)l2));
        long l3 = this.getRequesterPid();
        this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
        object = new PipeReadableByteChannel(this);
        PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
        try {
            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                final /* synthetic */ PipeReadableByteChannel $read;
                final /* synthetic */ PipeWritableByteChannel $write;
                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                private static final String[] a;
                private static final String[] b;
                {
                    this.$read = $read;
                    this.$write = $write;
                    this.this$0 = $receiver;
                }

                public InputStream getInputStream() {
                    long l2 = 46504767093910L;
                    InputStream inputStream = Channels.newInputStream(this.$read);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-1138736160 + -((char)-1279), -1138736160 + -((char)-9443), (int)l2));
                    return inputStream;
                }

                public OutputStream getOutputStream() {
                    long l2 = 62578903342255L;
                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(1229829810 + 12853, -1229829810 + -1627, (int)l2));
                    return outputStream;
                }

                public void close() {
                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                }

                /*
                 * Unable to fully structure code
                 */
                static {
                    block13: {
                        var5 = new String[2];
                        var3_1 = 0;
                        var2_2 = "l\u008c\u00c3\u0016\u00d4\u00d0\u0016_k\u00ff!;{\u0099E\u00fc1]\u00bf\u0014\u00f9\u009cq\u0012\u0099\u0092\u00c2\u0092s@\u00e7\u0018a\u0004\u00c7\u00c4\u008c\u009c\u000fS";
                        var4_3 = "l\u008c\u00c3\u0016\u00d4\u00d0\u0016_k\u00ff!;{\u0099E\u00fc1]\u00bf\u0014\u00f9\u009cq\u0012\u0099\u0092\u00c2\u0092s@\u00e7\u0018a\u0004\u00c7\u00c4\u008c\u009c\u000fS".length();
                        var1_4 = 19;
                        var0_5 = -1;
lbl7:
                        // 2 sources

                        while (true) {
                            continue;
                            break;
                        }
lbl9:
                        // 1 sources

                        while (true) {
                            var5[var3_1++] = new String(v0).intern();
                            if ((var0_5 += var1_4) < var4_3) {
                                var1_4 = var2_2.charAt(var0_5);
                                ** continue;
                            }
                            break block13;
                            break;
                        }
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                        v3 = v2.length;
                        var6_6 = 0;
                        v4 = 99;
                        v5 = v2;
                        v6 = v3;
                        if (v3 > 1) ** GOTO lbl67
                        do {
                            v7 = v4;
                            v5 = v5;
                            v8 = v5;
                            v9 = v4;
                            v10 = var6_6;
                            while (true) {
                                switch (var6_6 % 7) {
                                    case 0: {
                                        v11 = 101;
                                        break;
                                    }
                                    case 1: {
                                        v11 = 73;
                                        break;
                                    }
                                    case 2: {
                                        v11 = 57;
                                        break;
                                    }
                                    case 3: {
                                        v11 = 33;
                                        break;
                                    }
                                    case 4: {
                                        v11 = 115;
                                        break;
                                    }
                                    case 5: {
                                        v11 = 41;
                                        break;
                                    }
                                    default: {
                                        v11 = 59;
                                    }
                                }
                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                ++var6_6;
                                v4 = v7;
                                if (v7 != 0) break;
                                v7 = v4;
                                v5 = v5;
                                v10 = v4;
                                v8 = v5;
                                v9 = v4;
                            }
lbl67:
                            // 2 sources

                            v0 = v5;
                            v6 = v6;
                        } while (v6 > var6_6);
                        ** while (true)
                    }
                    accept.3.a = var5;
                    accept.3.b = new String[2];
                }

                private static String a(int n2, int n3, int n4) {
                    int n5 = (n2 ^ n4 ^ 0x3449) & 0xFFFF;
                    if (b[n5] == null) {
                        int n6;
                        char[] cArray = a[n5].toCharArray();
                        int n7 = switch (cArray[0] & 0xFF) {
                            case 0 -> 196;
                            case 1 -> 222;
                            case 2 -> 111;
                            case 3 -> 62;
                            case 4 -> 85;
                            case 5 -> 10;
                            case 6 -> 59;
                            case 7 -> 179;
                            case 8 -> 229;
                            case 9 -> 178;
                            case 10 -> 246;
                            case 11 -> 13;
                            case 12 -> 65;
                            case 13 -> 101;
                            case 14 -> 25;
                            case 15 -> 137;
                            case 16 -> 117;
                            case 17 -> 77;
                            case 18 -> 140;
                            case 19 -> 230;
                            case 20 -> 122;
                            case 21 -> 219;
                            case 22 -> 206;
                            case 23 -> 163;
                            case 24 -> 221;
                            case 25 -> 68;
                            case 26 -> 228;
                            case 27 -> 41;
                            case 28 -> 124;
                            case 29 -> 169;
                            case 30 -> 79;
                            case 31 -> 167;
                            case 32 -> 86;
                            case 33 -> 44;
                            case 34 -> 181;
                            case 35 -> 106;
                            case 36 -> 132;
                            case 37 -> 248;
                            case 38 -> 189;
                            case 39 -> 200;
                            case 40 -> 42;
                            case 41 -> 255;
                            case 42 -> 252;
                            case 43 -> 202;
                            case 44 -> 145;
                            case 45 -> 22;
                            case 46 -> 239;
                            case 47 -> 127;
                            case 48 -> 104;
                            case 49 -> 60;
                            case 50 -> 233;
                            case 51 -> 27;
                            case 52 -> 47;
                            case 53 -> 182;
                            case 54 -> 190;
                            case 55 -> 242;
                            case 56 -> 20;
                            case 57 -> 108;
                            case 58 -> 98;
                            case 59 -> 50;
                            case 60 -> 238;
                            case 61 -> 66;
                            case 62 -> 72;
                            case 63 -> 164;
                            case 64 -> 195;
                            case 65 -> 177;
                            case 66 -> 225;
                            case 67 -> 171;
                            case 68 -> 173;
                            case 69 -> 61;
                            case 70 -> 90;
                            case 71 -> 80;
                            case 72 -> 131;
                            case 73 -> 33;
                            case 74 -> 49;
                            case 75 -> 197;
                            case 76 -> 193;
                            case 77 -> 241;
                            case 78 -> 15;
                            case 79 -> 84;
                            case 80 -> 235;
                            case 81 -> 175;
                            case 82 -> 14;
                            case 83 -> 110;
                            case 84 -> 236;
                            case 85 -> 18;
                            case 86 -> 74;
                            case 87 -> 120;
                            case 88 -> 240;
                            case 89 -> 113;
                            case 90 -> 29;
                            case 91 -> 40;
                            case 92 -> 119;
                            case 93 -> 63;
                            case 94 -> 7;
                            case 95 -> 172;
                            case 96 -> 152;
                            case 97 -> 102;
                            case 98 -> 55;
                            case 99 -> 159;
                            case 100 -> 6;
                            case 101 -> 100;
                            case 102 -> 247;
                            case 103 -> 19;
                            case 104 -> 94;
                            case 105 -> 201;
                            case 106 -> 81;
                            case 107 -> 105;
                            case 108 -> 97;
                            case 109 -> 220;
                            case 110 -> 71;
                            case 111 -> 234;
                            case 112 -> 73;
                            case 113 -> 0;
                            case 114 -> 58;
                            case 115 -> 183;
                            case 116 -> 82;
                            case 117 -> 232;
                            case 118 -> 5;
                            case 119 -> 125;
                            case 120 -> 69;
                            case 121 -> 245;
                            case 122 -> 212;
                            case 123 -> 199;
                            case 124 -> 166;
                            case 125 -> 12;
                            case 126 -> 53;
                            case 127 -> 95;
                            case 128 -> 21;
                            case 129 -> 32;
                            case 130 -> 174;
                            case 131 -> 251;
                            case 132 -> 96;
                            case 133 -> 218;
                            case 134 -> 118;
                            case 135 -> 126;
                            case 136 -> 143;
                            case 137 -> 161;
                            case 138 -> 35;
                            case 139 -> 37;
                            case 140 -> 135;
                            case 141 -> 51;
                            case 142 -> 186;
                            case 143 -> 128;
                            case 144 -> 43;
                            case 145 -> 45;
                            case 146 -> 136;
                            case 147 -> 170;
                            case 148 -> 187;
                            case 149 -> 38;
                            case 150 -> 191;
                            case 151 -> 121;
                            case 152 -> 180;
                            case 153 -> 123;
                            case 154 -> 216;
                            case 155 -> 115;
                            case 156 -> 26;
                            case 157 -> 213;
                            case 158 -> 148;
                            case 159 -> 168;
                            case 160 -> 157;
                            case 161 -> 184;
                            case 162 -> 244;
                            case 163 -> 253;
                            case 164 -> 144;
                            case 165 -> 188;
                            case 166 -> 226;
                            case 167 -> 28;
                            case 168 -> 165;
                            case 169 -> 149;
                            case 170 -> 70;
                            case 171 -> 223;
                            case 172 -> 249;
                            case 173 -> 243;
                            case 174 -> 150;
                            case 175 -> 217;
                            case 176 -> 139;
                            case 177 -> 162;
                            case 178 -> 224;
                            case 179 -> 156;
                            case 180 -> 147;
                            case 181 -> 209;
                            case 182 -> 138;
                            case 183 -> 54;
                            case 184 -> 39;
                            case 185 -> 129;
                            case 186 -> 52;
                            case 187 -> 112;
                            case 188 -> 24;
                            case 189 -> 57;
                            case 190 -> 30;
                            case 191 -> 64;
                            case 192 -> 34;
                            case 193 -> 93;
                            case 194 -> 99;
                            case 195 -> 67;
                            case 196 -> 107;
                            case 197 -> 92;
                            case 198 -> 23;
                            case 199 -> 153;
                            case 200 -> 151;
                            case 201 -> 91;
                            case 202 -> 1;
                            case 203 -> 215;
                            case 204 -> 87;
                            case 205 -> 8;
                            case 206 -> 176;
                            case 207 -> 158;
                            case 208 -> 56;
                            case 209 -> 17;
                            case 210 -> 31;
                            case 211 -> 160;
                            case 212 -> 141;
                            case 213 -> 11;
                            case 214 -> 76;
                            case 215 -> 227;
                            case 216 -> 48;
                            case 217 -> 16;
                            case 218 -> 194;
                            case 219 -> 133;
                            case 220 -> 78;
                            case 221 -> 9;
                            case 222 -> 134;
                            case 223 -> 4;
                            case 224 -> 204;
                            case 225 -> 155;
                            case 226 -> 88;
                            case 227 -> 130;
                            case 228 -> 250;
                            case 229 -> 192;
                            case 230 -> 231;
                            case 231 -> 89;
                            case 232 -> 146;
                            case 233 -> 185;
                            case 234 -> 237;
                            case 235 -> 154;
                            case 236 -> 211;
                            case 237 -> 83;
                            case 238 -> 3;
                            case 239 -> 103;
                            case 240 -> 75;
                            case 241 -> 210;
                            case 242 -> 114;
                            case 243 -> 109;
                            case 244 -> 2;
                            case 245 -> 205;
                            case 246 -> 208;
                            case 247 -> 198;
                            case 248 -> 142;
                            case 249 -> 46;
                            case 250 -> 207;
                            case 251 -> 36;
                            case 252 -> 214;
                            case 253 -> 254;
                            case 254 -> 116;
                            default -> 203;
                        };
                        int n8 = ((n3 ^= n4) & 0xFF) - n7;
                        if (n8 < 0) {
                            n8 += 256;
                        }
                        if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                            n6 += 256;
                        }
                        int n9 = 0;
                        while (n9 < cArray.length) {
                            int n10 = n9 % 2;
                            int n11 = n9;
                            char[] cArray2 = cArray;
                            char c2 = cArray[n11];
                            if (n10 == 0) {
                                cArray2[n11] = (char)(c2 ^ n8);
                                n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                            } else {
                                cArray2[n11] = (char)(c2 ^ n6);
                                n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                            }
                            ++n9;
                        }
                        accept.3.b[n5] = new String(cArray).intern();
                    }
                    return b[n5];
                }
            };
            if (actionTimestampArray == null) {
                ActionTimestamp.A(new int[1]);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n2;
            long l3;
            block2: {
                block3: {
                    l3 = 87755141646629L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.A();
                    try {
                        n2 = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (actionTimestampArray == null) break block2;
                        if (n2 == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-369879540 - -3159, -369879540 - -380, (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(-369879540 - -3163, -369879540 - -21806, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-369879540 - -3184, 369879540 - 19745, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n2 = Kernel32.INSTANCE.GetLastError();
            }
            int n3 = n2;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-369879540 - -3159, -369879540 - -380, (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(-369879540 - -3163, -369879540 - -21806, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(-369879540 - -3183, -369879540 - -19158, (int)l3) + ErrorToolsKt.prettyHRESULT((int)n3));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    ActionTimestamp[] actionTimestampArray;
                    block13: {
                        long l2 = 45200213199153L;
                        ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.A();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(22675110 - (char)-25544, -22675110 - -((char)-6909), (int)l2));
                        actionTimestampArray = actionTimestampArray2;
                        try {
                            try {
                                try {
                                    try {
                                        if (actionTimestampArray == null || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (actionTimestampArray == null) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(22675110 - (char)-25543, -22675110 - -((char)-22819), (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (actionTimestampArray == null) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        ActionTimestamp[] actionTimestampArray;
        long l2;
        block25: {
            block26: {
                l2 = 77202087522157L;
                ActionTimestamp[] actionTimestampArray2 = SshAgentIpcService.A();
                this.assertConnectionThread();
                actionTimestampArray = actionTimestampArray2;
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    boolean bl2 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (actionTimestampArray == null) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (actionTimestampArray == null) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl3 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-299), -50330880 + -((char)-11968), (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-303), -50330880 + -((char)-19058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-304), -50330880 + -((char)-7489), (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl) {
                        boolean bl4 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-303), -50330880 + -((char)-19058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-297), 50330880 + (char)-19676, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-299), -50330880 + -((char)-11968), (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-303), -50330880 + -((char)-19058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-319), 50330880 + (char)-26966, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (actionTimestampArray == null) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-299), -50330880 + -((char)-11968), (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-303), -50330880 + -((char)-19058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-318), -50330880 + -((char)-20119), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (actionTimestampArray == null) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-299), -50330880 + -((char)-11968), (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-303), -50330880 + -((char)-19058), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-50330880 + -((char)-317), 50330880 + (char)-13736, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n2;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                ActionTimestamp[] actionTimestampArray;
                block16: {
                    l2 = 105426319911677L;
                    Object object = this.lock;
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                actionTimestampArray = SshAgentIpcService.A();
                                boolean bl2 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (actionTimestampArray == null) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl3 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052687270 - -1889, -2052687270 - -14838, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-2052687270 - -1893, -2052687270 - -20104, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052687270 - -1874, 2052687270 - 29963, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-2052687270 - -1873, 2052687270 - 22233, (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052687270 - -1889, -2052687270 - -14838, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-2052687270 - -1893, -2052687270 - -20104, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052687270 - -1872, -2052687270 - -21716, (int)l2));
                            n2 = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (actionTimestampArray == null) break block15;
                            if (n2 != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n2 = Kernel32.INSTANCE.GetLastError();
                        if (actionTimestampArray == null) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n3 = n2;
                    if (n3 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl4 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052687270 - -1889, -2052687270 - -14838, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-2052687270 - -1893, -2052687270 - -20104, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052687270 - -1871, 2052687270 - 4337, (int)l2) + ErrorToolsKt.prettyHRESULT((int)n3));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052687270 - -1889, -2052687270 - -14838, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-2052687270 - -1893, -2052687270 - -20104, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052687270 - -1870, -2052687270 - -24762, (int)l2));
                    if (actionTimestampArray == null) break block17;
                    n2 = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n2 == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-2052687270 - -1889, -2052687270 - -14838, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-2052687270 - -1893, -2052687270 - -20104, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-2052687270 - -1853, -2052687270 - -22082, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-2052687270 - -1852, -2052687270 - -((char)-32482), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "\r\u001c\u009d}\u00b25\u0006\u00a0\u00141\u0081\")\u00bb7\u0088\u00fa\u00cb\u0098\u00a9\u0011\u00cc\u00d5 _\u00c3\u00e4k.\u0006\u00dc\u0082\u00a7\u00ae\u009f\u000e\u0018S\u00c7\u000e\u00d1\u00bc\u00edja_\u00964\u00a0\u0019\u001c\u00c8\u00e4w\u00fa\u00d3p\u00b9G\u00f7.\tb\u00e4\u00b6\u0004\u00c0\u00c8\u00fd\u008d\u0091\u0005\u00e3\t@\u00dfy\b\u00bd\u00a0\u008b\u009b\"\u00cf\u0012\u001d\u00144\u001d\u00fa!\u00cd>sL\u00da\u0093 \u00c4\u00b7\u00cc\u00f4\u0091K\u00ee\u0083-\u0005\u0005e\u009cR\u00e2\u001e\u00e6\u0015\u00f58R\u0014\u0015$\u0015*6\u00b0\u0015>\u00eb\u00c4\u00f2o\u00b16Y\u00a0\u00e7\u001f{D\u00c2\u00a55U\u0010\u00c4GU\u00b7\u0011\u00d7\u008b\u00a5\u00bb\u00a8n\u001d\u0018\u00de\u00e5G\t\u00b5\u00e3\u009a\u00f5\u0016\u00d1\u00011\u00e0\u0010\u0095\u00b2\u007f\tT\u0000#_\u00ae\u00f7\u00cc\u00f6L\u00a3o\u00e8?\u00c009\u009c\u00c6\u0089\u0002\u00fb\u0086\u0000\u0001\u000eL\u001f\u00fd\u00d9\u00f5\u00a9,+dQ;G\u00f0\u00a7\u00bem\u008d\u001a\u0004\u00ca\r4\u0097\u00c5>ak \u00d0\u00d1\u00f3!-\u00d8F\u00fe\u0014g\u009b\u00f0\u00c6NW\u00e7\u0013:\u0000\u00e4\u00a1\u0086\u008d\bg'\u00d0kI\u00d1\u007f\u00de\f\u00fe\u00e9\u00f3\u00a90\u00eb\u00be\u009e4\u0087\u00cd\u00fcF\u0083H\\\u009d\u00c5m\u0000N\u00e3\u0091=\u00fa]\u0089\u00c0-\u00aePG\u00bb\u001b\u0011\u00d7}[\u00cb8\u00eb\u00e2\u00e3\u00d3\u00c9\u00cb\u00e2\u008d>\u00a7S\u00f3\u00a2P\u0094hr\u00807\u00a7~\u00cf\u008f\u0086G\u008a.\u00c8\u00f0\u007f\u00ac\u001b\u008a\u00f1\"\u00db\u008d\r'\u00e7J\u00e4\u0016\u001f\u00c7\b\u00d1\u009b\u00d6`\u0085\u00aa\u0007\u00fbt\u008a]d\u00e9>\u00c9\u00d8\u00ab\n\u00d1\u00a7!T\u00c2\u00fd\u00e2^,\u00db\b\u000b\u008a\u00c1}\u00ac\u00e1K\u0084\u008as\t/\u0015\u00b6\u00bf\u00fa`\u0016\u00ba\u0096\u00c9\u000f\u0081h\u000e`XS\u00efev\u00e3\u00a6\u00ee)\u0086\u00ca\u00f9\u00c3\u00d3k%\u00cb\u0013\u00d7\u00f6\u000f\t\u00de\u00fdl\u0014\u001a\u00cb\u00f5- x\u00bc\u0086\u00a9\u00bd\u00ac\u00e8q\u0012\u00a5\r\u00ca3\u00b6n_A\u008a\u00a5\u0007\u0012ca\u00ec\u00e4\u00d3X\u0007\u00a1js\u00a1A\u0095\u00fa(\u0016\u00c4\u00a7#\u00a8\u001d\u00bc\"P=\u00b4db2\u00d2r\u00f6t9{\u0012\u00cf\u00f0\u008a\u0007\u00d3;\u0098\u000f\u00975`\u0012\u0019Na{\u00d8p\u0089\u000f\u0086%\u00fb6\u00cb\u00d3u8\u001c\u00f3\u009c\u00ec\u00c7w\u00f8\"\u00b1\u009b\u001f\u00e9\u000f.\u00bec`\u00c2\u0098\u00ad\u00c7\u0086@\u00a9H\u008b\u00ca\u0085\u00e7.\u0081-*\u00cf\u00e5\u00be\u00c7\u0001U\u00ac\u00cb\u0018\u000e\u00e6\u001b\u00f7\u00f1J+E'\u001a\u0010\\\u0090\u00d3\u00f2\u001b$\u00e6\u00a8KZ\u00c9\u00d2'\u00bf\u0097ea\u00a4\u00fa\n0\u00a9\u0012K*\u00ec\u00ef\u0093\u00b3#q\u0091\n\u00da\u00de\u00b3K--\u00ef\u0091\u00b3#\u0018\u00ce\u0012\u00f5\u00d8\u00f0\u0007\u00a6\u00a0/\u00ae\u00b5\u00d9\u0007\u00be\u0082\u0099\u00cf&P\u00d5\u00f7[\u00abv)\u0001E\t2\u00cdU\u00e6\fk/\u00f9\u0010\u00ec4\u00deJ\u000e\u00abW\u0006\u0084N\u0004}|\u0003\u007f\u0015\u00e3\u001a\u00c8Ys\u008b)\n\u00f3\u00ec\u00f2\u00fc\u00d3\t\u0005S\u008c\u00fd\u00de\u001fN\u00b3\u00b4";
                var4_3 = "\r\u001c\u009d}\u00b25\u0006\u00a0\u00141\u0081\")\u00bb7\u0088\u00fa\u00cb\u0098\u00a9\u0011\u00cc\u00d5 _\u00c3\u00e4k.\u0006\u00dc\u0082\u00a7\u00ae\u009f\u000e\u0018S\u00c7\u000e\u00d1\u00bc\u00edja_\u00964\u00a0\u0019\u001c\u00c8\u00e4w\u00fa\u00d3p\u00b9G\u00f7.\tb\u00e4\u00b6\u0004\u00c0\u00c8\u00fd\u008d\u0091\u0005\u00e3\t@\u00dfy\b\u00bd\u00a0\u008b\u009b\"\u00cf\u0012\u001d\u00144\u001d\u00fa!\u00cd>sL\u00da\u0093 \u00c4\u00b7\u00cc\u00f4\u0091K\u00ee\u0083-\u0005\u0005e\u009cR\u00e2\u001e\u00e6\u0015\u00f58R\u0014\u0015$\u0015*6\u00b0\u0015>\u00eb\u00c4\u00f2o\u00b16Y\u00a0\u00e7\u001f{D\u00c2\u00a55U\u0010\u00c4GU\u00b7\u0011\u00d7\u008b\u00a5\u00bb\u00a8n\u001d\u0018\u00de\u00e5G\t\u00b5\u00e3\u009a\u00f5\u0016\u00d1\u00011\u00e0\u0010\u0095\u00b2\u007f\tT\u0000#_\u00ae\u00f7\u00cc\u00f6L\u00a3o\u00e8?\u00c009\u009c\u00c6\u0089\u0002\u00fb\u0086\u0000\u0001\u000eL\u001f\u00fd\u00d9\u00f5\u00a9,+dQ;G\u00f0\u00a7\u00bem\u008d\u001a\u0004\u00ca\r4\u0097\u00c5>ak \u00d0\u00d1\u00f3!-\u00d8F\u00fe\u0014g\u009b\u00f0\u00c6NW\u00e7\u0013:\u0000\u00e4\u00a1\u0086\u008d\bg'\u00d0kI\u00d1\u007f\u00de\f\u00fe\u00e9\u00f3\u00a90\u00eb\u00be\u009e4\u0087\u00cd\u00fcF\u0083H\\\u009d\u00c5m\u0000N\u00e3\u0091=\u00fa]\u0089\u00c0-\u00aePG\u00bb\u001b\u0011\u00d7}[\u00cb8\u00eb\u00e2\u00e3\u00d3\u00c9\u00cb\u00e2\u008d>\u00a7S\u00f3\u00a2P\u0094hr\u00807\u00a7~\u00cf\u008f\u0086G\u008a.\u00c8\u00f0\u007f\u00ac\u001b\u008a\u00f1\"\u00db\u008d\r'\u00e7J\u00e4\u0016\u001f\u00c7\b\u00d1\u009b\u00d6`\u0085\u00aa\u0007\u00fbt\u008a]d\u00e9>\u00c9\u00d8\u00ab\n\u00d1\u00a7!T\u00c2\u00fd\u00e2^,\u00db\b\u000b\u008a\u00c1}\u00ac\u00e1K\u0084\u008as\t/\u0015\u00b6\u00bf\u00fa`\u0016\u00ba\u0096\u00c9\u000f\u0081h\u000e`XS\u00efev\u00e3\u00a6\u00ee)\u0086\u00ca\u00f9\u00c3\u00d3k%\u00cb\u0013\u00d7\u00f6\u000f\t\u00de\u00fdl\u0014\u001a\u00cb\u00f5- x\u00bc\u0086\u00a9\u00bd\u00ac\u00e8q\u0012\u00a5\r\u00ca3\u00b6n_A\u008a\u00a5\u0007\u0012ca\u00ec\u00e4\u00d3X\u0007\u00a1js\u00a1A\u0095\u00fa(\u0016\u00c4\u00a7#\u00a8\u001d\u00bc\"P=\u00b4db2\u00d2r\u00f6t9{\u0012\u00cf\u00f0\u008a\u0007\u00d3;\u0098\u000f\u00975`\u0012\u0019Na{\u00d8p\u0089\u000f\u0086%\u00fb6\u00cb\u00d3u8\u001c\u00f3\u009c\u00ec\u00c7w\u00f8\"\u00b1\u009b\u001f\u00e9\u000f.\u00bec`\u00c2\u0098\u00ad\u00c7\u0086@\u00a9H\u008b\u00ca\u0085\u00e7.\u0081-*\u00cf\u00e5\u00be\u00c7\u0001U\u00ac\u00cb\u0018\u000e\u00e6\u001b\u00f7\u00f1J+E'\u001a\u0010\\\u0090\u00d3\u00f2\u001b$\u00e6\u00a8KZ\u00c9\u00d2'\u00bf\u0097ea\u00a4\u00fa\n0\u00a9\u0012K*\u00ec\u00ef\u0093\u00b3#q\u0091\n\u00da\u00de\u00b3K--\u00ef\u0091\u00b3#\u0018\u00ce\u0012\u00f5\u00d8\u00f0\u0007\u00a6\u00a0/\u00ae\u00b5\u00d9\u0007\u00be\u0082\u0099\u00cf&P\u00d5\u00f7[\u00abv)\u0001E\t2\u00cdU\u00e6\fk/\u00f9\u0010\u00ec4\u00deJ\u000e\u00abW\u0006\u0084N\u0004}|\u0003\u007f\u0015\u00e3\u001a\u00c8Ys\u008b)\n\u00f3\u00ec\u00f2\u00fc\u00d3\t\u0005S\u008c\u00fd\u00de\u001fN\u00b3\u00b4".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 93;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00e4Q\u00cd\u00c8-r\u0082\u0090\u009f\u00c4\u001f\u0015H\u00ec2)\u00eb\u00b3\u00c3\u00f9;\u00f6x\u00cc Q\u001dbG\u0014\u0012\u00ed>\u00dc@\u00f1\u008fZS\u00f4\u00c2\u00e4\u00d9\u0013\u00fa\u00ff\u00e0\u0088w\u00db";
                    var4_3 = "\u00e4Q\u00cd\u00c8-r\u0082\u0090\u009f\u00c4\u001f\u0015H\u00ec2)\u00eb\u00b3\u00c3\u00f9;\u00f6x\u00cc Q\u001dbG\u0014\u0012\u00ed>\u00dc@\u00f1\u008fZS\u00f4\u00c2\u00e4\u00d9\u0013\u00fa\u00ff\u00e0\u0088w\u00db".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 70;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 93;
                            break;
                        }
                        case 1: {
                            v15 = 105;
                            break;
                        }
                        case 2: {
                            v15 = 111;
                            break;
                        }
                        case 3: {
                            v15 = 4;
                            break;
                        }
                        case 4: {
                            v15 = 52;
                            break;
                        }
                        case 5: {
                            v15 = 68;
                            break;
                        }
                        default: {
                            v15 = 14;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n2, int n3, int n4) {
        int n5 = (n2 ^ n4 ^ 0xFFFFAB4A) & 0xFFFF;
        if (d[n5] == null) {
            int n6;
            char[] cArray = c[n5].toCharArray();
            int n7 = switch (cArray[0] & 0xFF) {
                case 0 -> 119;
                case 1 -> 13;
                case 2 -> 35;
                case 3 -> 70;
                case 4 -> 6;
                case 5 -> 170;
                case 6 -> 139;
                case 7 -> 184;
                case 8 -> 12;
                case 9 -> 69;
                case 10 -> 214;
                case 11 -> 219;
                case 12 -> 186;
                case 13 -> 152;
                case 14 -> 48;
                case 15 -> 177;
                case 16 -> 27;
                case 17 -> 60;
                case 18 -> 10;
                case 19 -> 230;
                case 20 -> 56;
                case 21 -> 189;
                case 22 -> 246;
                case 23 -> 173;
                case 24 -> 63;
                case 25 -> 141;
                case 26 -> 38;
                case 27 -> 140;
                case 28 -> 16;
                case 29 -> 88;
                case 30 -> 62;
                case 31 -> 147;
                case 32 -> 0;
                case 33 -> 86;
                case 34 -> 222;
                case 35 -> 202;
                case 36 -> 72;
                case 37 -> 135;
                case 38 -> 143;
                case 39 -> 199;
                case 40 -> 9;
                case 41 -> 162;
                case 42 -> 148;
                case 43 -> 124;
                case 44 -> 204;
                case 45 -> 82;
                case 46 -> 54;
                case 47 -> 90;
                case 48 -> 79;
                case 49 -> 110;
                case 50 -> 100;
                case 51 -> 116;
                case 52 -> 209;
                case 53 -> 231;
                case 54 -> 101;
                case 55 -> 30;
                case 56 -> 183;
                case 57 -> 94;
                case 58 -> 164;
                case 59 -> 126;
                case 60 -> 235;
                case 61 -> 206;
                case 62 -> 76;
                case 63 -> 237;
                case 64 -> 234;
                case 65 -> 32;
                case 66 -> 248;
                case 67 -> 224;
                case 68 -> 185;
                case 69 -> 247;
                case 70 -> 97;
                case 71 -> 41;
                case 72 -> 243;
                case 73 -> 103;
                case 74 -> 215;
                case 75 -> 3;
                case 76 -> 50;
                case 77 -> 217;
                case 78 -> 104;
                case 79 -> 23;
                case 80 -> 153;
                case 81 -> 37;
                case 82 -> 159;
                case 83 -> 25;
                case 84 -> 229;
                case 85 -> 84;
                case 86 -> 213;
                case 87 -> 212;
                case 88 -> 245;
                case 89 -> 211;
                case 90 -> 98;
                case 91 -> 226;
                case 92 -> 122;
                case 93 -> 144;
                case 94 -> 67;
                case 95 -> 174;
                case 96 -> 191;
                case 97 -> 210;
                case 98 -> 55;
                case 99 -> 39;
                case 100 -> 137;
                case 101 -> 93;
                case 102 -> 85;
                case 103 -> 236;
                case 104 -> 201;
                case 105 -> 14;
                case 106 -> 102;
                case 107 -> 239;
                case 108 -> 207;
                case 109 -> 131;
                case 110 -> 61;
                case 111 -> 155;
                case 112 -> 26;
                case 113 -> 175;
                case 114 -> 46;
                case 115 -> 227;
                case 116 -> 200;
                case 117 -> 36;
                case 118 -> 225;
                case 119 -> 193;
                case 120 -> 132;
                case 121 -> 34;
                case 122 -> 142;
                case 123 -> 252;
                case 124 -> 66;
                case 125 -> 33;
                case 126 -> 43;
                case 127 -> 73;
                case 128 -> 254;
                case 129 -> 29;
                case 130 -> 241;
                case 131 -> 15;
                case 132 -> 205;
                case 133 -> 169;
                case 134 -> 11;
                case 135 -> 233;
                case 136 -> 167;
                case 137 -> 151;
                case 138 -> 75;
                case 139 -> 81;
                case 140 -> 24;
                case 141 -> 117;
                case 142 -> 165;
                case 143 -> 228;
                case 144 -> 8;
                case 145 -> 163;
                case 146 -> 115;
                case 147 -> 21;
                case 148 -> 176;
                case 149 -> 187;
                case 150 -> 71;
                case 151 -> 255;
                case 152 -> 1;
                case 153 -> 128;
                case 154 -> 216;
                case 155 -> 68;
                case 156 -> 127;
                case 157 -> 78;
                case 158 -> 108;
                case 159 -> 244;
                case 160 -> 2;
                case 161 -> 52;
                case 162 -> 18;
                case 163 -> 118;
                case 164 -> 154;
                case 165 -> 250;
                case 166 -> 158;
                case 167 -> 65;
                case 168 -> 74;
                case 169 -> 129;
                case 170 -> 109;
                case 171 -> 125;
                case 172 -> 172;
                case 173 -> 249;
                case 174 -> 96;
                case 175 -> 5;
                case 176 -> 136;
                case 177 -> 111;
                case 178 -> 64;
                case 179 -> 232;
                case 180 -> 51;
                case 181 -> 53;
                case 182 -> 106;
                case 183 -> 49;
                case 184 -> 150;
                case 185 -> 195;
                case 186 -> 105;
                case 187 -> 57;
                case 188 -> 44;
                case 189 -> 197;
                case 190 -> 42;
                case 191 -> 221;
                case 192 -> 208;
                case 193 -> 161;
                case 194 -> 220;
                case 195 -> 123;
                case 196 -> 99;
                case 197 -> 179;
                case 198 -> 168;
                case 199 -> 203;
                case 200 -> 188;
                case 201 -> 134;
                case 202 -> 40;
                case 203 -> 242;
                case 204 -> 146;
                case 205 -> 253;
                case 206 -> 223;
                case 207 -> 178;
                case 208 -> 133;
                case 209 -> 77;
                case 210 -> 91;
                case 211 -> 19;
                case 212 -> 218;
                case 213 -> 138;
                case 214 -> 121;
                case 215 -> 149;
                case 216 -> 251;
                case 217 -> 87;
                case 218 -> 58;
                case 219 -> 17;
                case 220 -> 59;
                case 221 -> 240;
                case 222 -> 130;
                case 223 -> 145;
                case 224 -> 182;
                case 225 -> 31;
                case 226 -> 181;
                case 227 -> 7;
                case 228 -> 47;
                case 229 -> 113;
                case 230 -> 89;
                case 231 -> 171;
                case 232 -> 160;
                case 233 -> 95;
                case 234 -> 157;
                case 235 -> 20;
                case 236 -> 22;
                case 237 -> 45;
                case 238 -> 80;
                case 239 -> 194;
                case 240 -> 198;
                case 241 -> 120;
                case 242 -> 166;
                case 243 -> 190;
                case 244 -> 28;
                case 245 -> 4;
                case 246 -> 112;
                case 247 -> 238;
                case 248 -> 114;
                case 249 -> 192;
                case 250 -> 107;
                case 251 -> 196;
                case 252 -> 180;
                case 253 -> 83;
                case 254 -> 92;
                default -> 156;
            };
            int n8 = ((n3 ^= n4) & 0xFF) - n7;
            if (n8 < 0) {
                n8 += 256;
            }
            if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                n6 += 256;
            }
            int n9 = 0;
            while (n9 < cArray.length) {
                int n10 = n9 % 2;
                int n11 = n9;
                char[] cArray2 = cArray;
                char c2 = cArray[n11];
                if (n10 == 0) {
                    cArray2[n11] = (char)(c2 ^ n8);
                    n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                } else {
                    cArray2[n11] = (char)(c2 ^ n6);
                    n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                }
                ++n9;
            }
            WindowsNamedPipeAgentIpc.d[n5] = new String(cArray).intern();
        }
        return d[n5];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 3958158106962L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1801688220 + 27793, -1801688220 + -32029, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        ActionTimestamp[] actionTimestampArray;
                        block4: {
                            l2 = 67183497185750L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            actionTimestampArray = SshAgentIpcService.A();
                            try {
                                hANDLE2 = hANDLE;
                                if (actionTimestampArray == null) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (actionTimestampArray == null) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl2 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1618714500 + -((char)-18732), -1618714500 + -((char)-22544), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1618714500 + -((char)-18735), -1618714500 + -((char)-16189), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(-1618714500 + -((char)-18734), -1618714500 + -((char)-16346), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u0001\u00d9\u00f5\u0018+dy\u00e2\u0010*\u00f6a\\\u0003W\u0085\u00dd\u00aaN\u0091U\u001a\u009b\u00cd?";
                    var4_3 = "\u0001\u00d9\u00f5\u0018+dy\u00e2\u0010*\u00f6a\\\u0003W\u0085\u00dd\u00aaN\u0091U\u001a\u009b\u00cd?".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 101;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u0082\u00e7\u00b9\u00e3\u00ee5eWR\u0099A\u00ea\u00e9\u00fdl\u00cd\u00e7\u00d9\u001f\u00dcTa\u000b\u0096\u00cc\u009c\u0014vu\"\u00b9\fIB\u00b7#GK1ydyi\t$\u00eeHW#\u00f5\u00b7HO\u00bf\u00f1\u00ed\u00d8Q\n";
                        var4_3 = "\u0082\u00e7\u00b9\u00e3\u00ee5eWR\u0099A\u00ea\u00e9\u00fdl\u00cd\u00e7\u00d9\u001f\u00dcTa\u000b\u0096\u00cc\u009c\u0014vu\"\u00b9\fIB\u00b7#GK1ydyi\t$\u00eeHW#\u00f5\u00b7HO\u00bf\u00f1\u00ed\u00d8Q\n".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 23;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 75;
                                break;
                            }
                            case 1: {
                                v15 = 76;
                                break;
                            }
                            case 2: {
                                v15 = 123;
                                break;
                            }
                            case 3: {
                                v15 = 66;
                                break;
                            }
                            case 4: {
                                v15 = 29;
                                break;
                            }
                            case 5: {
                                v15 = 78;
                                break;
                            }
                            default: {
                                v15 = 88;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0xFFFFA07F) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 52;
                    case 1 -> 4;
                    case 2 -> 234;
                    case 3 -> 135;
                    case 4 -> 247;
                    case 5 -> 252;
                    case 6 -> 139;
                    case 7 -> 96;
                    case 8 -> 133;
                    case 9 -> 171;
                    case 10 -> 62;
                    case 11 -> 136;
                    case 12 -> 118;
                    case 13 -> 244;
                    case 14 -> 144;
                    case 15 -> 240;
                    case 16 -> 153;
                    case 17 -> 2;
                    case 18 -> 17;
                    case 19 -> 194;
                    case 20 -> 44;
                    case 21 -> 23;
                    case 22 -> 166;
                    case 23 -> 175;
                    case 24 -> 216;
                    case 25 -> 255;
                    case 26 -> 48;
                    case 27 -> 33;
                    case 28 -> 102;
                    case 29 -> 80;
                    case 30 -> 163;
                    case 31 -> 113;
                    case 32 -> 201;
                    case 33 -> 210;
                    case 34 -> 88;
                    case 35 -> 81;
                    case 36 -> 18;
                    case 37 -> 54;
                    case 38 -> 152;
                    case 39 -> 191;
                    case 40 -> 95;
                    case 41 -> 6;
                    case 42 -> 183;
                    case 43 -> 251;
                    case 44 -> 0;
                    case 45 -> 197;
                    case 46 -> 21;
                    case 47 -> 182;
                    case 48 -> 34;
                    case 49 -> 241;
                    case 50 -> 36;
                    case 51 -> 145;
                    case 52 -> 187;
                    case 53 -> 132;
                    case 54 -> 105;
                    case 55 -> 50;
                    case 56 -> 116;
                    case 57 -> 125;
                    case 58 -> 164;
                    case 59 -> 11;
                    case 60 -> 237;
                    case 61 -> 242;
                    case 62 -> 124;
                    case 63 -> 30;
                    case 64 -> 110;
                    case 65 -> 77;
                    case 66 -> 150;
                    case 67 -> 69;
                    case 68 -> 39;
                    case 69 -> 231;
                    case 70 -> 137;
                    case 71 -> 149;
                    case 72 -> 230;
                    case 73 -> 76;
                    case 74 -> 134;
                    case 75 -> 246;
                    case 76 -> 156;
                    case 77 -> 51;
                    case 78 -> 250;
                    case 79 -> 195;
                    case 80 -> 7;
                    case 81 -> 85;
                    case 82 -> 217;
                    case 83 -> 112;
                    case 84 -> 189;
                    case 85 -> 24;
                    case 86 -> 225;
                    case 87 -> 97;
                    case 88 -> 22;
                    case 89 -> 40;
                    case 90 -> 185;
                    case 91 -> 98;
                    case 92 -> 89;
                    case 93 -> 84;
                    case 94 -> 114;
                    case 95 -> 47;
                    case 96 -> 83;
                    case 97 -> 179;
                    case 98 -> 200;
                    case 99 -> 63;
                    case 100 -> 161;
                    case 101 -> 143;
                    case 102 -> 169;
                    case 103 -> 66;
                    case 104 -> 8;
                    case 105 -> 227;
                    case 106 -> 160;
                    case 107 -> 159;
                    case 108 -> 162;
                    case 109 -> 232;
                    case 110 -> 78;
                    case 111 -> 212;
                    case 112 -> 67;
                    case 113 -> 235;
                    case 114 -> 59;
                    case 115 -> 138;
                    case 116 -> 111;
                    case 117 -> 86;
                    case 118 -> 154;
                    case 119 -> 142;
                    case 120 -> 167;
                    case 121 -> 92;
                    case 122 -> 151;
                    case 123 -> 57;
                    case 124 -> 103;
                    case 125 -> 65;
                    case 126 -> 42;
                    case 127 -> 28;
                    case 128 -> 109;
                    case 129 -> 245;
                    case 130 -> 214;
                    case 131 -> 35;
                    case 132 -> 178;
                    case 133 -> 207;
                    case 134 -> 233;
                    case 135 -> 53;
                    case 136 -> 177;
                    case 137 -> 26;
                    case 138 -> 16;
                    case 139 -> 146;
                    case 140 -> 1;
                    case 141 -> 253;
                    case 142 -> 68;
                    case 143 -> 101;
                    case 144 -> 58;
                    case 145 -> 9;
                    case 146 -> 157;
                    case 147 -> 249;
                    case 148 -> 181;
                    case 149 -> 93;
                    case 150 -> 19;
                    case 151 -> 79;
                    case 152 -> 49;
                    case 153 -> 168;
                    case 154 -> 72;
                    case 155 -> 106;
                    case 156 -> 70;
                    case 157 -> 243;
                    case 158 -> 126;
                    case 159 -> 3;
                    case 160 -> 254;
                    case 161 -> 15;
                    case 162 -> 147;
                    case 163 -> 45;
                    case 164 -> 223;
                    case 165 -> 87;
                    case 166 -> 226;
                    case 167 -> 131;
                    case 168 -> 148;
                    case 169 -> 115;
                    case 170 -> 120;
                    case 171 -> 29;
                    case 172 -> 248;
                    case 173 -> 75;
                    case 174 -> 123;
                    case 175 -> 209;
                    case 176 -> 158;
                    case 177 -> 238;
                    case 178 -> 215;
                    case 179 -> 205;
                    case 180 -> 141;
                    case 181 -> 122;
                    case 182 -> 117;
                    case 183 -> 27;
                    case 184 -> 128;
                    case 185 -> 172;
                    case 186 -> 38;
                    case 187 -> 198;
                    case 188 -> 61;
                    case 189 -> 165;
                    case 190 -> 55;
                    case 191 -> 121;
                    case 192 -> 99;
                    case 193 -> 213;
                    case 194 -> 41;
                    case 195 -> 192;
                    case 196 -> 12;
                    case 197 -> 127;
                    case 198 -> 218;
                    case 199 -> 64;
                    case 200 -> 107;
                    case 201 -> 196;
                    case 202 -> 43;
                    case 203 -> 32;
                    case 204 -> 155;
                    case 205 -> 228;
                    case 206 -> 190;
                    case 207 -> 20;
                    case 208 -> 220;
                    case 209 -> 239;
                    case 210 -> 73;
                    case 211 -> 184;
                    case 212 -> 130;
                    case 213 -> 140;
                    case 214 -> 37;
                    case 215 -> 188;
                    case 216 -> 104;
                    case 217 -> 174;
                    case 218 -> 10;
                    case 219 -> 129;
                    case 220 -> 25;
                    case 221 -> 221;
                    case 222 -> 193;
                    case 223 -> 199;
                    case 224 -> 173;
                    case 225 -> 119;
                    case 226 -> 90;
                    case 227 -> 13;
                    case 228 -> 71;
                    case 229 -> 186;
                    case 230 -> 206;
                    case 231 -> 236;
                    case 232 -> 170;
                    case 233 -> 219;
                    case 234 -> 202;
                    case 235 -> 5;
                    case 236 -> 208;
                    case 237 -> 224;
                    case 238 -> 108;
                    case 239 -> 91;
                    case 240 -> 100;
                    case 241 -> 211;
                    case 242 -> 203;
                    case 243 -> 204;
                    case 244 -> 60;
                    case 245 -> 94;
                    case 246 -> 14;
                    case 247 -> 222;
                    case 248 -> 46;
                    case 249 -> 229;
                    case 250 -> 180;
                    case 251 -> 82;
                    case 252 -> 56;
                    case 253 -> 74;
                    case 254 -> 176;
                    default -> 31;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 93662907646284L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "V+\u001aj\f2E\u000f\tQ!\t`ApX\u0013g";
                    var5_4 = "V+\u001aj\f2E\u000f\tQ!\t`ApX\u0013g".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 24;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 37;
                                    break;
                                }
                                case 1: {
                                    v11 = 86;
                                    break;
                                }
                                case 2: {
                                    v11 = 112;
                                    break;
                                }
                                case 3: {
                                    v11 = 28;
                                    break;
                                }
                                case 4: {
                                    v11 = 113;
                                    break;
                                }
                                case 5: {
                                    v11 = 70;
                                    break;
                                }
                                default: {
                                    v11 = 110;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 98427510455107L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "\u0013o$BHcS\u0004\u0015q(X\n\u0019n#XDaK3o*\t\u0019n#XDaK?e\r\u001eh>UNlQ?b9_Oe";
                    var5_4 = "\u0013o$BHcS\u0004\u0015q(X\n\u0019n#XDaK3o*\t\u0019n#XDaK?e\r\u001eh>UNlQ?b9_Oe".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 111;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "Q%j\r\u0000$\u0010\u0006Q%j\r\f.";
                        var5_4 = "Q%j\r\u0000$\u0010\u0006Q%j\r\f.".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 39;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 53;
                                break;
                            }
                            case 1: {
                                v15 = 110;
                                break;
                            }
                            case 2: {
                                v15 = 34;
                                break;
                            }
                            case 3: {
                                v15 = 89;
                                break;
                            }
                            case 4: {
                                v15 = 78;
                                break;
                            }
                            case 5: {
                                v15 = 109;
                                break;
                            }
                            default: {
                                v15 = 80;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n23#2:392\n23#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 21144488434482L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(364505670 - (char)-4689, 364505670 - (char)-772, (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 39247051528370L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "e\u00cd\u00868\u008e\u0003\u0088\u00a6\u008f\u0005\u0014\u00ab\u008e0l\r\u00fc=\u00a5\u00a8\u00fc@\u00dc?\u00f5O\u00ff`-\u0010[9\u0096\u00c3\u00a5\u00b8\u00dc\u001d<\u008f%5\u0090\u001a\u00a1\u00b2\u0005\u00e1\u00fb0:\u00bb3m\u00d3\u00b0H\u00b4\u008d\u00ce\u00af\u0003$Ii\u00db\u00c0\u00e4\u00f6\u00c8%\u00a7\u00cao\u00bb\u00fd\u00f69m\u0090\u00893o\r\u00c5\u00dd.\u00a8\u00f9\u008b\u00be\u0092v#\u00af^Y\u008c\u00f5\"\u0002dk\u001b";
                    var4_3 = "e\u00cd\u00868\u008e\u0003\u0088\u00a6\u008f\u0005\u0014\u00ab\u008e0l\r\u00fc=\u00a5\u00a8\u00fc@\u00dc?\u00f5O\u00ff`-\u0010[9\u0096\u00c3\u00a5\u00b8\u00dc\u001d<\u008f%5\u0090\u001a\u00a1\u00b2\u0005\u00e1\u00fb0:\u00bb3m\u00d3\u00b0H\u00b4\u008d\u00ce\u00af\u0003$Ii\u00db\u00c0\u00e4\u00f6\u00c8%\u00a7\u00cao\u00bb\u00fd\u00f69m\u0090\u00893o\r\u00c5\u00dd.\u00a8\u00f9\u008b\u00be\u0092v#\u00af^Y\u008c\u00f5\"\u0002dk\u001b".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 22;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00e2\u000b\u009b\u00bf>\r\u0095\u0091/$}z\u00a1\u00c9\u00bd\u00f2L\u0085\u00e7\u0080\u00e8w/\u00d2\u00bbN\u00f2\u00fd\u0019\u00bf+\u00ed\u00d7\u00d6\u00ea\u00a1\u00ff\u00fdC\u00bfqhL\u00a5QU\u0007\u0014\u009d\u00d4\u00f1\u00c2$\u00ce\u00e1:\u00c1:\u009e\u00888y=m\u0019E\u0006\u00edg\u00a6\u0093\u007fU}\u00ef\b\u00e6be\u00a6\u007f\u0080s-W\u00cf\u0019\u00b5A2\u00070\u00d5";
                        var4_3 = "\u00e2\u000b\u009b\u00bf>\r\u0095\u0091/$}z\u00a1\u00c9\u00bd\u00f2L\u0085\u00e7\u0080\u00e8w/\u00d2\u00bbN\u00f2\u00fd\u0019\u00bf+\u00ed\u00d7\u00d6\u00ea\u00a1\u00ff\u00fdC\u00bfqhL\u00a5QU\u0007\u0014\u009d\u00d4\u00f1\u00c2$\u00ce\u00e1:\u00c1:\u009e\u00888y=m\u0019E\u0006\u00edg\u00a6\u0093\u007fU}\u00ef\b\u00e6be\u00a6\u007f\u0080s-W\u00cf\u0019\u00b5A2\u00070\u00d5".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 15;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 39;
                                break;
                            }
                            case 1: {
                                v15 = 79;
                                break;
                            }
                            case 2: {
                                v15 = 50;
                                break;
                            }
                            case 3: {
                                v15 = 89;
                                break;
                            }
                            case 4: {
                                v15 = 113;
                                break;
                            }
                            case 5: {
                                v15 = 44;
                                break;
                            }
                            default: {
                                v15 = 69;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x27A5) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 201;
                    case 1 -> 113;
                    case 2 -> 222;
                    case 3 -> 234;
                    case 4 -> 226;
                    case 5 -> 92;
                    case 6 -> 41;
                    case 7 -> 213;
                    case 8 -> 45;
                    case 9 -> 140;
                    case 10 -> 134;
                    case 11 -> 76;
                    case 12 -> 193;
                    case 13 -> 54;
                    case 14 -> 81;
                    case 15 -> 20;
                    case 16 -> 180;
                    case 17 -> 179;
                    case 18 -> 158;
                    case 19 -> 207;
                    case 20 -> 104;
                    case 21 -> 115;
                    case 22 -> 39;
                    case 23 -> 189;
                    case 24 -> 129;
                    case 25 -> 38;
                    case 26 -> 186;
                    case 27 -> 91;
                    case 28 -> 123;
                    case 29 -> 149;
                    case 30 -> 11;
                    case 31 -> 165;
                    case 32 -> 239;
                    case 33 -> 135;
                    case 34 -> 9;
                    case 35 -> 112;
                    case 36 -> 102;
                    case 37 -> 195;
                    case 38 -> 227;
                    case 39 -> 80;
                    case 40 -> 46;
                    case 41 -> 43;
                    case 42 -> 150;
                    case 43 -> 96;
                    case 44 -> 138;
                    case 45 -> 181;
                    case 46 -> 163;
                    case 47 -> 87;
                    case 48 -> 109;
                    case 49 -> 171;
                    case 50 -> 154;
                    case 51 -> 55;
                    case 52 -> 118;
                    case 53 -> 58;
                    case 54 -> 219;
                    case 55 -> 204;
                    case 56 -> 119;
                    case 57 -> 230;
                    case 58 -> 216;
                    case 59 -> 23;
                    case 60 -> 12;
                    case 61 -> 205;
                    case 62 -> 245;
                    case 63 -> 151;
                    case 64 -> 231;
                    case 65 -> 133;
                    case 66 -> 101;
                    case 67 -> 203;
                    case 68 -> 94;
                    case 69 -> 30;
                    case 70 -> 254;
                    case 71 -> 50;
                    case 72 -> 10;
                    case 73 -> 27;
                    case 74 -> 5;
                    case 75 -> 156;
                    case 76 -> 223;
                    case 77 -> 246;
                    case 78 -> 178;
                    case 79 -> 160;
                    case 80 -> 221;
                    case 81 -> 97;
                    case 82 -> 7;
                    case 83 -> 17;
                    case 84 -> 67;
                    case 85 -> 172;
                    case 86 -> 248;
                    case 87 -> 175;
                    case 88 -> 153;
                    case 89 -> 116;
                    case 90 -> 114;
                    case 91 -> 210;
                    case 92 -> 198;
                    case 93 -> 228;
                    case 94 -> 69;
                    case 95 -> 32;
                    case 96 -> 253;
                    case 97 -> 173;
                    case 98 -> 71;
                    case 99 -> 157;
                    case 100 -> 244;
                    case 101 -> 235;
                    case 102 -> 25;
                    case 103 -> 194;
                    case 104 -> 53;
                    case 105 -> 108;
                    case 106 -> 1;
                    case 107 -> 250;
                    case 108 -> 208;
                    case 109 -> 211;
                    case 110 -> 72;
                    case 111 -> 19;
                    case 112 -> 147;
                    case 113 -> 22;
                    case 114 -> 35;
                    case 115 -> 168;
                    case 116 -> 31;
                    case 117 -> 217;
                    case 118 -> 86;
                    case 119 -> 242;
                    case 120 -> 127;
                    case 121 -> 197;
                    case 122 -> 185;
                    case 123 -> 126;
                    case 124 -> 141;
                    case 125 -> 49;
                    case 126 -> 29;
                    case 127 -> 103;
                    case 128 -> 13;
                    case 129 -> 155;
                    case 130 -> 212;
                    case 131 -> 64;
                    case 132 -> 51;
                    case 133 -> 170;
                    case 134 -> 95;
                    case 135 -> 60;
                    case 136 -> 183;
                    case 137 -> 196;
                    case 138 -> 167;
                    case 139 -> 77;
                    case 140 -> 174;
                    case 141 -> 79;
                    case 142 -> 238;
                    case 143 -> 2;
                    case 144 -> 59;
                    case 145 -> 190;
                    case 146 -> 125;
                    case 147 -> 161;
                    case 148 -> 66;
                    case 149 -> 142;
                    case 150 -> 169;
                    case 151 -> 237;
                    case 152 -> 220;
                    case 153 -> 255;
                    case 154 -> 8;
                    case 155 -> 83;
                    case 156 -> 166;
                    case 157 -> 75;
                    case 158 -> 200;
                    case 159 -> 105;
                    case 160 -> 14;
                    case 161 -> 215;
                    case 162 -> 56;
                    case 163 -> 26;
                    case 164 -> 249;
                    case 165 -> 225;
                    case 166 -> 70;
                    case 167 -> 159;
                    case 168 -> 107;
                    case 169 -> 65;
                    case 170 -> 24;
                    case 171 -> 224;
                    case 172 -> 18;
                    case 173 -> 206;
                    case 174 -> 42;
                    case 175 -> 6;
                    case 176 -> 188;
                    case 177 -> 52;
                    case 178 -> 136;
                    case 179 -> 187;
                    case 180 -> 202;
                    case 181 -> 132;
                    case 182 -> 191;
                    case 183 -> 106;
                    case 184 -> 121;
                    case 185 -> 84;
                    case 186 -> 241;
                    case 187 -> 99;
                    case 188 -> 110;
                    case 189 -> 232;
                    case 190 -> 90;
                    case 191 -> 199;
                    case 192 -> 36;
                    case 193 -> 21;
                    case 194 -> 4;
                    case 195 -> 74;
                    case 196 -> 182;
                    case 197 -> 117;
                    case 198 -> 85;
                    case 199 -> 218;
                    case 200 -> 192;
                    case 201 -> 68;
                    case 202 -> 164;
                    case 203 -> 88;
                    case 204 -> 131;
                    case 205 -> 139;
                    case 206 -> 33;
                    case 207 -> 214;
                    case 208 -> 15;
                    case 209 -> 98;
                    case 210 -> 89;
                    case 211 -> 61;
                    case 212 -> 184;
                    case 213 -> 144;
                    case 214 -> 44;
                    case 215 -> 143;
                    case 216 -> 40;
                    case 217 -> 209;
                    case 218 -> 48;
                    case 219 -> 177;
                    case 220 -> 120;
                    case 221 -> 243;
                    case 222 -> 176;
                    case 223 -> 63;
                    case 224 -> 252;
                    case 225 -> 93;
                    case 226 -> 229;
                    case 227 -> 146;
                    case 228 -> 247;
                    case 229 -> 152;
                    case 230 -> 78;
                    case 231 -> 3;
                    case 232 -> 128;
                    case 233 -> 28;
                    case 234 -> 37;
                    case 235 -> 130;
                    case 236 -> 148;
                    case 237 -> 82;
                    case 238 -> 0;
                    case 239 -> 47;
                    case 240 -> 137;
                    case 241 -> 162;
                    case 242 -> 236;
                    case 243 -> 122;
                    case 244 -> 62;
                    case 245 -> 73;
                    case 246 -> 233;
                    case 247 -> 124;
                    case 248 -> 57;
                    case 249 -> 34;
                    case 250 -> 251;
                    case 251 -> 240;
                    case 252 -> 111;
                    case 253 -> 16;
                    case 254 -> 145;
                    default -> 100;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeReadableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 116025141335846L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(894814890 - 2198, -894814890 + -8356, (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n2;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 103796378307597L;
                    ActionTimestamp[] actionTimestampArray = SshAgentIpcService.A();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(-96336450 - -21376, -96336450 - -29523, (int)l2));
                    ActionTimestamp[] actionTimestampArray2 = actionTimestampArray;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n2 = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (actionTimestampArray2 == null) break block7;
                            if (n2 != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n2 = intByReference.getValue();
            }
            return n2;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 26320267911490L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u00b0\u0089\u00f4S)\u0003#\u00f1\u00d0";
                var4_3 = "\u00b0\u0089\u00f4S)\u0003#\u00f1\u00d0".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 20;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 17;
                                break;
                            }
                            case 1: {
                                v11 = 57;
                                break;
                            }
                            case 2: {
                                v11 = 126;
                                break;
                            }
                            case 3: {
                                v11 = 54;
                                break;
                            }
                            case 4: {
                                v11 = 83;
                                break;
                            }
                            case 5: {
                                v11 = 59;
                                break;
                            }
                            default: {
                                v11 = 58;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n2, int n3, int n4) {
            int n5 = (n2 ^ n4 ^ 0x5532) & 0xFFFF;
            if (b[n5] == null) {
                int n6;
                char[] cArray = a[n5].toCharArray();
                int n7 = switch (cArray[0] & 0xFF) {
                    case 0 -> 62;
                    case 1 -> 30;
                    case 2 -> 51;
                    case 3 -> 28;
                    case 4 -> 234;
                    case 5 -> 222;
                    case 6 -> 70;
                    case 7 -> 187;
                    case 8 -> 193;
                    case 9 -> 44;
                    case 10 -> 153;
                    case 11 -> 139;
                    case 12 -> 81;
                    case 13 -> 216;
                    case 14 -> 232;
                    case 15 -> 254;
                    case 16 -> 66;
                    case 17 -> 26;
                    case 18 -> 34;
                    case 19 -> 7;
                    case 20 -> 173;
                    case 21 -> 185;
                    case 22 -> 229;
                    case 23 -> 96;
                    case 24 -> 50;
                    case 25 -> 156;
                    case 26 -> 121;
                    case 27 -> 79;
                    case 28 -> 49;
                    case 29 -> 195;
                    case 30 -> 24;
                    case 31 -> 151;
                    case 32 -> 89;
                    case 33 -> 48;
                    case 34 -> 160;
                    case 35 -> 255;
                    case 36 -> 87;
                    case 37 -> 214;
                    case 38 -> 199;
                    case 39 -> 221;
                    case 40 -> 143;
                    case 41 -> 177;
                    case 42 -> 64;
                    case 43 -> 174;
                    case 44 -> 91;
                    case 45 -> 191;
                    case 46 -> 69;
                    case 47 -> 152;
                    case 48 -> 63;
                    case 49 -> 14;
                    case 50 -> 114;
                    case 51 -> 10;
                    case 52 -> 33;
                    case 53 -> 67;
                    case 54 -> 90;
                    case 55 -> 129;
                    case 56 -> 11;
                    case 57 -> 163;
                    case 58 -> 179;
                    case 59 -> 35;
                    case 60 -> 86;
                    case 61 -> 115;
                    case 62 -> 27;
                    case 63 -> 243;
                    case 64 -> 110;
                    case 65 -> 75;
                    case 66 -> 71;
                    case 67 -> 230;
                    case 68 -> 58;
                    case 69 -> 147;
                    case 70 -> 109;
                    case 71 -> 122;
                    case 72 -> 164;
                    case 73 -> 210;
                    case 74 -> 181;
                    case 75 -> 231;
                    case 76 -> 56;
                    case 77 -> 233;
                    case 78 -> 172;
                    case 79 -> 55;
                    case 80 -> 97;
                    case 81 -> 42;
                    case 82 -> 117;
                    case 83 -> 88;
                    case 84 -> 215;
                    case 85 -> 249;
                    case 86 -> 198;
                    case 87 -> 251;
                    case 88 -> 103;
                    case 89 -> 142;
                    case 90 -> 20;
                    case 91 -> 154;
                    case 92 -> 29;
                    case 93 -> 217;
                    case 94 -> 74;
                    case 95 -> 167;
                    case 96 -> 43;
                    case 97 -> 68;
                    case 98 -> 84;
                    case 99 -> 241;
                    case 100 -> 107;
                    case 101 -> 252;
                    case 102 -> 46;
                    case 103 -> 9;
                    case 104 -> 12;
                    case 105 -> 141;
                    case 106 -> 166;
                    case 107 -> 15;
                    case 108 -> 204;
                    case 109 -> 150;
                    case 110 -> 159;
                    case 111 -> 106;
                    case 112 -> 22;
                    case 113 -> 250;
                    case 114 -> 203;
                    case 115 -> 105;
                    case 116 -> 37;
                    case 117 -> 112;
                    case 118 -> 148;
                    case 119 -> 72;
                    case 120 -> 220;
                    case 121 -> 127;
                    case 122 -> 138;
                    case 123 -> 211;
                    case 124 -> 60;
                    case 125 -> 242;
                    case 126 -> 4;
                    case 127 -> 180;
                    case 128 -> 78;
                    case 129 -> 120;
                    case 130 -> 239;
                    case 131 -> 207;
                    case 132 -> 246;
                    case 133 -> 118;
                    case 134 -> 201;
                    case 135 -> 132;
                    case 136 -> 59;
                    case 137 -> 168;
                    case 138 -> 3;
                    case 139 -> 225;
                    case 140 -> 213;
                    case 141 -> 19;
                    case 142 -> 140;
                    case 143 -> 165;
                    case 144 -> 52;
                    case 145 -> 6;
                    case 146 -> 134;
                    case 147 -> 53;
                    case 148 -> 36;
                    case 149 -> 218;
                    case 150 -> 16;
                    case 151 -> 186;
                    case 152 -> 205;
                    case 153 -> 94;
                    case 154 -> 247;
                    case 155 -> 125;
                    case 156 -> 189;
                    case 157 -> 32;
                    case 158 -> 137;
                    case 159 -> 158;
                    case 160 -> 155;
                    case 161 -> 208;
                    case 162 -> 98;
                    case 163 -> 130;
                    case 164 -> 182;
                    case 165 -> 100;
                    case 166 -> 223;
                    case 167 -> 102;
                    case 168 -> 200;
                    case 169 -> 226;
                    case 170 -> 8;
                    case 171 -> 40;
                    case 172 -> 73;
                    case 173 -> 116;
                    case 174 -> 85;
                    case 175 -> 1;
                    case 176 -> 126;
                    case 177 -> 144;
                    case 178 -> 57;
                    case 179 -> 184;
                    case 180 -> 244;
                    case 181 -> 192;
                    case 182 -> 253;
                    case 183 -> 176;
                    case 184 -> 206;
                    case 185 -> 196;
                    case 186 -> 240;
                    case 187 -> 77;
                    case 188 -> 183;
                    case 189 -> 237;
                    case 190 -> 23;
                    case 191 -> 45;
                    case 192 -> 104;
                    case 193 -> 113;
                    case 194 -> 92;
                    case 195 -> 194;
                    case 196 -> 41;
                    case 197 -> 65;
                    case 198 -> 157;
                    case 199 -> 108;
                    case 200 -> 136;
                    case 201 -> 238;
                    case 202 -> 99;
                    case 203 -> 21;
                    case 204 -> 162;
                    case 205 -> 95;
                    case 206 -> 38;
                    case 207 -> 13;
                    case 208 -> 25;
                    case 209 -> 93;
                    case 210 -> 83;
                    case 211 -> 39;
                    case 212 -> 146;
                    case 213 -> 188;
                    case 214 -> 202;
                    case 215 -> 161;
                    case 216 -> 76;
                    case 217 -> 175;
                    case 218 -> 209;
                    case 219 -> 101;
                    case 220 -> 170;
                    case 221 -> 248;
                    case 222 -> 224;
                    case 223 -> 145;
                    case 224 -> 82;
                    case 225 -> 178;
                    case 226 -> 171;
                    case 227 -> 135;
                    case 228 -> 61;
                    case 229 -> 227;
                    case 230 -> 245;
                    case 231 -> 18;
                    case 232 -> 80;
                    case 233 -> 5;
                    case 234 -> 190;
                    case 235 -> 235;
                    case 236 -> 123;
                    case 237 -> 124;
                    case 238 -> 128;
                    case 239 -> 212;
                    case 240 -> 17;
                    case 241 -> 236;
                    case 242 -> 119;
                    case 243 -> 0;
                    case 244 -> 54;
                    case 245 -> 219;
                    case 246 -> 169;
                    case 247 -> 111;
                    case 248 -> 133;
                    case 249 -> 47;
                    case 250 -> 149;
                    case 251 -> 197;
                    case 252 -> 31;
                    case 253 -> 2;
                    case 254 -> 228;
                    default -> 131;
                };
                int n8 = ((n3 ^= n4) & 0xFF) - n7;
                if (n8 < 0) {
                    n8 += 256;
                }
                if ((n6 = ((n3 & 0xFFFF) >>> 8) - n7) < 0) {
                    n6 += 256;
                }
                int n9 = 0;
                while (n9 < cArray.length) {
                    int n10 = n9 % 2;
                    int n11 = n9;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n11];
                    if (n10 == 0) {
                        cArray2[n11] = (char)(c2 ^ n8);
                        n8 = ((n8 >>> 3 | n8 << 5) ^ cArray[n9]) & 0xFF;
                    } else {
                        cArray2[n11] = (char)(c2 ^ n6);
                        n6 = ((n6 >>> 3 | n6 << 5) ^ cArray[n9]) & 0xFF;
                    }
                    ++n9;
                }
                PipeWritableByteChannel.b[n5] = new String(cArray).intern();
            }
            return b[n5];
        }
    }
}

