/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.debugger;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.jupyter.py.debugger.JupyterCellSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterDebugCellId;
import com.intellij.jupyter.py.debugger.JupyterDebugCellIdManager;
import com.intellij.jupyter.py.debugger.JupyterEditorSourcePosition;
import com.intellij.jupyter.py.debugger.JupyterSourcePosition;
import com.intellij.jupyter.py.editor.JupyterFileUtilKt;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyLocalPositionConverter;
import com.jetbrains.python.debugger.PySourcePosition;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u0013\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterPositionConverter;", "Lcom/jetbrains/python/debugger/PyLocalPositionConverter;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getCellStartPosition", "Lcom/intellij/jupyter/py/debugger/JupyterCellSourcePosition;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "convertPythonToFrame", "Lcom/jetbrains/python/debugger/PySourcePosition;", "filePath", "", "line", "", "convertFrameToPython", "convertToPython", "convertFromPython", "frameName", "getCellStart", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterPositionConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterPositionConverter.kt\ncom/intellij/jupyter/py/debugger/JupyterPositionConverter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,85:1\n23#2:86\n23#2:87\n*S KotlinDebug\n*F\n+ 1 JupyterPositionConverter.kt\ncom/intellij/jupyter/py/debugger/JupyterPositionConverter\n*L\n33#1:86\n54#1:87\n*E\n"})
public final class JupyterPositionConverter
extends PyLocalPositionConverter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public JupyterPositionConverter(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @TestOnly
    @Nullable
    public final JupyterCellSourcePosition getCellStartPosition(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.getCellStart(position);
    }

    @NotNull
    public PySourcePosition convertPythonToFrame(@NotNull String filePath, int line) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        JupyterDebugCellIdManager jupyterDebugCellIdManager = JupyterDebugCellIdManager.Companion.getInstance(this.project);
        if (!jupyterDebugCellIdManager.isCellId-nnF9l_Q(JupyterDebugCellId.constructor-impl(filePath))) {
            PySourcePosition pySourcePosition = super.convertPythonToFrame(filePath, line);
            Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertPythonToFrame(...)");
            return pySourcePosition;
        }
        JupyterCellSourcePosition cellPosition = jupyterDebugCellIdManager.getCellPositionByCellId-uHQkgfc(this.project, JupyterDebugCellId.constructor-impl(filePath));
        if (cellPosition == null) {
            JupyterPositionConverter $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(JupyterPositionConverter.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Failed to find cell position for cell id " + filePath + ".");
            PySourcePosition pySourcePosition = super.convertPythonToFrame(filePath, line);
            Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertPythonToFrame(...)");
            return pySourcePosition;
        }
        PySourcePosition pySourcePosition = super.convertPythonToFrame(cellPosition.getStart().getFile().getPath(), cellPosition.getStart().getLine() + line + 1);
        Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertPythonToFrame(...)");
        return pySourcePosition;
    }

    @NotNull
    public PySourcePosition convertFrameToPython(@NotNull PySourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        XSourcePosition xSourcePosition = this.convertFromPython(position, "");
        if (xSourcePosition == null) {
            return position;
        }
        XSourcePosition sourcePosition = xSourcePosition;
        Object object = ReadAction.compute(() -> JupyterPositionConverter.convertFrameToPython$lambda$0(this, sourcePosition));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (PySourcePosition)object;
    }

    @NotNull
    public PySourcePosition convertToPython(@NotNull XSourcePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        JupyterCellSourcePosition cellPosition = this.getCellStart(position);
        if (cellPosition == null) {
            JupyterDebugCellIdManager jupyterDebugCellIdManager = JupyterDebugCellIdManager.Companion.getInstance(this.project);
            String string = position.getFile().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            boolean isIndexed = jupyterDebugCellIdManager.isFileIndexed(string);
            if (isIndexed) {
                JupyterPositionConverter $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(JupyterPositionConverter.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)new PyDebuggerException("Failed to find cell position for " + position));
            }
            PySourcePosition pySourcePosition = super.convertToPython(position);
            Intrinsics.checkNotNullExpressionValue((Object)pySourcePosition, (String)"convertToPython(...)");
            return pySourcePosition;
        }
        String cellId = JupyterDebugCellIdManager.Companion.getInstance(this.project).getCellIdByPosition-AG_RinQ(cellPosition);
        return new JupyterSourcePosition(cellId, position.getLine() - cellPosition.getStart().getLine(), null);
    }

    @Nullable
    public XSourcePosition convertFromPython(@NotNull PySourcePosition position, @NotNull String frameName) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter((Object)frameName, (String)"frameName");
        XSourcePosition xSourcePosition = super.convertFromPython(position, frameName);
        if (xSourcePosition == null) {
            return null;
        }
        XSourcePosition xSourcePosition2 = xSourcePosition;
        return new JupyterEditorSourcePosition(xSourcePosition2);
    }

    private final JupyterCellSourcePosition getCellStart(XSourcePosition position) {
        VirtualFile virtualFile = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
        VirtualFile virtualFile2 = JupyterFileExtensionsKt.getOriginalVirtualFile((VirtualFile)virtualFile);
        BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(virtualFile2);
        if (backedNotebookVirtualFile == null) {
            return null;
        }
        BackedNotebookVirtualFile notebookFile = backedNotebookVirtualFile;
        int line = position.getLine();
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = JupyterHelper.INSTANCE.getJupyterVirtualFileByOriginalVirtualFile(virtualFile2);
        if (backedNotebookVirtualFile2 == null) {
            return null;
        }
        BackedNotebookVirtualFile jupyterVirtualFile = backedNotebookVirtualFile2;
        NotebookCellLines.Interval interval = JupyterHelper.INSTANCE.getIntervalByLine(jupyterVirtualFile, line);
        if (interval == null) {
            return null;
        }
        NotebookCellLines.Interval interval2 = interval;
        NotebookIntervalPointer notebookIntervalPointer = JupyterHelper.INSTANCE.getIntervalPointer(this.project, notebookFile, interval2);
        if (notebookIntervalPointer == null) {
            return null;
        }
        NotebookIntervalPointer pointer = notebookIntervalPointer;
        return JupyterFileUtilKt.getCellPositionForJupyterCell(virtualFile2, pointer);
    }

    private static final PySourcePosition convertFrameToPython$lambda$0(JupyterPositionConverter this$0, XSourcePosition $sourcePosition) {
        return this$0.convertToPython($sourcePosition);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/py/debugger/JupyterPositionConverter$Companion;", "", "<init>", "()V", "getJupyterLineStartOffset", "", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "(Lcom/intellij/openapi/vfs/VirtualFile;I)Ljava/lang/Integer;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Integer getJupyterLineStartOffset(@NotNull VirtualFile originalFile, int line) {
            Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
            Document document = FileDocumentManager.getInstance().getDocument(originalFile);
            return document != null ? Integer.valueOf(document.getLineStartOffset(line)) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

