/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.comms.common.netty.server;

import com.intellij.station.comms.common.ServicesServerHostApplication;
import com.intellij.station.comms.common.api.Codec;
import com.intellij.station.comms.common.api.HttpContext;
import com.intellij.station.comms.common.api.HttpContextWithResponse;
import com.intellij.station.comms.common.api.StationRestRequestHandler;
import com.intellij.station.comms.common.api.StationServiceRequestHandler;
import com.intellij.station.comms.common.api.StationWebsocketRequestHandler;
import com.intellij.station.comms.common.netty.server.HttpContextKt;
import com.intellij.station.comms.common.netty.util.ExtensionsKt;
import com.intellij.station.comms.common.netty.util.SimpleChannelInboundHandlerAdapter;
import com.intellij.station.comms.common.netty.websocket.WebSocketClientImpl;
import com.intellij.station.comms.common.utils.Logging;
import com.intellij.station.comms.common.utils.StationConstants;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.URI;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0014J \u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J@\u0010\u0013\u001a\u00020\n\"\b\b\u0000\u0010\u0014*\u00020\u0015\"\b\b\u0001\u0010\u0016*\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00160\u0019H\u0002J@\u0010\u001c\u001a\u00020\n\"\b\b\u0000\u0010\u0014*\u00020\u0015\"\b\b\u0001\u0010\u0016*\u00020\u00152\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00022\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00160\u001dH\u0002J\u001c\u0010\u001e\u001a\u00020\n2\b\u0010\u001f\u001a\u0004\u0018\u00010\f2\b\u0010 \u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/station/comms/common/netty/server/RootHandler;", "Lcom/intellij/station/comms/common/netty/util/SimpleChannelInboundHandlerAdapter;", "Lio/netty/handler/codec/http/FullHttpRequest;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "hostApplication", "Lcom/intellij/station/comms/common/ServicesServerHostApplication;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/intellij/station/comms/common/ServicesServerHostApplication;)V", "messageReceived", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "message", "logErrorAndSendResponse", "throwable", "", "uri", "", "handleRest", "Request", "", "Response", "request", "handler", "Lcom/intellij/station/comms/common/api/StationRestRequestHandler;", "factory", "Lio/netty/handler/codec/http/websocketx/WebSocketServerHandshakerFactory;", "handleWebsocket", "Lcom/intellij/station/comms/common/api/StationWebsocketRequestHandler;", "exceptionCaught", "ctx", "cause", "Companion", "intellij.station.comms.common"})
@SourceDebugExtension(value={"SMAP\nRootHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RootHandler.kt\ncom/intellij/station/comms/common/netty/server/RootHandler\n+ 2 Logging.kt\ncom/intellij/station/comms/common/utils/LoggingKt\n+ 3 Logging.kt\ncom/intellij/station/comms/common/utils/Logging\n*L\n1#1,132:1\n12#2,3:133\n7#3:136\n*S KotlinDebug\n*F\n+ 1 RootHandler.kt\ncom/intellij/station/comms/common/netty/server/RootHandler\n*L\n41#1:133,3\n27#1:136\n*E\n"})
public final class RootHandler
extends SimpleChannelInboundHandlerAdapter<FullHttpRequest> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ServicesServerHostApplication hostApplication;
    @NotNull
    private final WebSocketServerHandshakerFactory factory;
    @NotNull
    private static final Logger logger;
    private static final int maxContentLength;

    public RootHandler(@NotNull CoroutineScope scope, @NotNull ServicesServerHostApplication hostApplication) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)hostApplication, (String)"hostApplication");
        this.scope = scope;
        this.hostApplication = hostApplication;
        this.factory = new WebSocketServerHandshakerFactory("", null, false, maxContentLength);
    }

    @Override
    protected void messageReceived(@NotNull ChannelHandlerContext context, @NotNull FullHttpRequest message) {
        block8: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Logger $this$debug$iv = logger;
            boolean $i$f$debug = false;
            if ($this$debug$iv.isDebugEnabled()) {
                Logger logger = $this$debug$iv;
                boolean bl = false;
                logger.debug("Message received: " + message);
            }
            URI uri = URI.create(message.uri());
            String string = uri.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            StationServiceRequestHandler<?, ?> handler2 = this.hostApplication.getServiceForEndpoint(string);
            HttpContext httpContextBase = HttpContextKt.toContext((HttpRequest)message);
            if (handler2 == null || !handler2.accept(httpContextBase)) {
                if (handler2 == null) {
                    logger.info("Handler for address " + uri.getPath() + " not found");
                } else {
                    logger.info("Handler for address " + uri.getPath() + " rejected the request");
                }
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.NOT_FOUND;
                Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"NOT_FOUND");
                FullHttpResponse response = RootHandler.Companion.response(httpResponseStatus);
                response.headers().add(StationConstants.INSTANCE.getStationFailureHeader(), (Object)StationConstants.INSTANCE.getUnknownEndpointValue());
                context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            try {
                StationServiceRequestHandler<?, ?> response = handler2;
                if (response instanceof StationRestRequestHandler) {
                    this.handleRest(context, message, (StationRestRequestHandler)handler2);
                    break block8;
                }
                if (response instanceof StationWebsocketRequestHandler) {
                    this.handleWebsocket(context, message, (StationWebsocketRequestHandler)handler2);
                    break block8;
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (Throwable t) {
                String string2 = uri.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                this.logErrorAndSendResponse(context, t, string2);
            }
        }
    }

    private final void logErrorAndSendResponse(ChannelHandlerContext context, Throwable throwable, String uri) {
        logger.error("Exception while handling a request to " + uri, throwable);
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
        Intrinsics.checkNotNullExpressionValue((Object)httpResponseStatus, (String)"INTERNAL_SERVER_ERROR");
        FullHttpResponse response = RootHandler.Companion.response(httpResponseStatus);
        context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private final <Request, Response> void handleRest(ChannelHandlerContext context, FullHttpRequest request2, StationRestRequestHandler<Request, Response> handler2) {
        ByteBuf byteBuf = request2.content();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
        byte[] data = ExtensionsKt.readAllToArray(byteBuf);
        Codec codec = handler2.getMetaInfo().getCodec();
        Object parsedData = codec.decodeRequest(data);
        HttpContextWithResponse httpContext = HttpContextKt.toContext(request2, context);
        String uri = request2.uri();
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        CoroutineScope requestScope = ExtensionsKt.boundedScope(channel, this.scope, "Request handler for " + uri);
        BuildersKt.launch$default((CoroutineScope)requestScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handler2, parsedData, httpContext, codec, this, context, uri, null){
            int label;
            final /* synthetic */ StationRestRequestHandler<Request, Response> $handler;
            final /* synthetic */ Request $parsedData;
            final /* synthetic */ HttpContextWithResponse $httpContext;
            final /* synthetic */ Codec<Request, Response> $codec;
            final /* synthetic */ RootHandler this$0;
            final /* synthetic */ ChannelHandlerContext $context;
            final /* synthetic */ String $uri;
            {
                this.$handler = $handler;
                this.$parsedData = $parsedData;
                this.$httpContext = $httpContext;
                this.$codec = $codec;
                this.this$0 = $receiver;
                this.$context = $context;
                this.$uri = $uri;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$handler.handle(this.$parsedData, this.$httpContext, (Continuation)this);
                        ** if (v0 != var4_2) goto lbl11
lbl10:
                        // 1 sources

                        return var4_2;
lbl11:
                        // 1 sources

                        ** GOTO lbl17
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl17:
                            // 2 sources

                            responseData = v0;
                            encoded = this.$codec.encodeResponse(responseData);
                            this.$httpContext.ok(this.$codec.getContentType(), encoded);
                        }
                        catch (Throwable t) {
                            var3_6 = this.$uri;
                            Intrinsics.checkNotNull((Object)var3_6);
                            RootHandler.access$logErrorAndSendResponse(this.this$0, this.$context, t, var3_6);
                            if (!(t instanceof CancellationException)) ** GOTO lbl27
                            throw t;
                        }
lbl27:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final <Request, Response> void handleWebsocket(ChannelHandlerContext context, FullHttpRequest request2, StationWebsocketRequestHandler<Request, Response> handler2) {
        WebSocketServerHandshaker handshaker = this.factory.newHandshaker((HttpRequest)request2);
        if (handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)context.channel());
            return;
        }
        if (!context.channel().isOpen()) {
            return;
        }
        HttpContext httpContext = HttpContextKt.toContext((HttpRequest)request2);
        Codec codec = handler2.getMetaInfo().getCodec();
        String uri = request2.uri();
        Channel channel = context.channel();
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
        CoroutineScope clientScope = ExtensionsKt.boundedScope(channel, this.scope, "Websocket handler for " + uri);
        BuildersKt.launch$default((CoroutineScope)clientScope, (CoroutineContext)((CoroutineContext)Dispatchers.getUnconfined()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(handshaker, context, request2, uri, codec, handler2, clientScope, httpContext, null){
            int label;
            final /* synthetic */ WebSocketServerHandshaker $handshaker;
            final /* synthetic */ ChannelHandlerContext $context;
            final /* synthetic */ FullHttpRequest $request;
            final /* synthetic */ String $uri;
            final /* synthetic */ Codec<Request, Response> $codec;
            final /* synthetic */ StationWebsocketRequestHandler<Request, Response> $handler;
            final /* synthetic */ CoroutineScope $clientScope;
            final /* synthetic */ HttpContext $httpContext;
            {
                this.$handshaker = $handshaker;
                this.$context = $context;
                this.$request = $request;
                this.$uri = $uri;
                this.$codec = $codec;
                this.$handler = $handler;
                this.$clientScope = $clientScope;
                this.$httpContext = $httpContext;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = this.$handshaker.handshake(this.$context.channel(), this.$request);
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"handshake(...)");
                        this.label = 1;
                        v1 = ExtensionsKt.awaitSuspend(v0, (Continuation<? super Channel>)((Continuation)this));
                        if (v1 == var4_2) {
                            return var4_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl15:
                        // 2 sources

                        v2 = "handler for " + this.$uri;
                        v3 = this.$context.channel();
                        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"channel(...)");
                        client = new WebSocketClientImpl<Request, Response>(v2, v3, this.$codec);
                        var3_4 = new ChannelHandler[]{client};
                        this.$context.pipeline().addLast(var3_4);
                        messageChannelHandlerContext = this.$context.pipeline().context((ChannelHandler)client);
                        this.$context.pipeline().addBefore(messageChannelHandlerContext.name(), "WebSocketFrameAggregator", (ChannelHandler)new WebSocketFrameAggregator(RootHandler.access$getMaxContentLength$cp()));
                        this.$handler.connected(this.$clientScope, client, this.$httpContext);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    public void exceptionCaught(@Nullable ChannelHandlerContext ctx, @Nullable Throwable cause) {
        Throwable throwable = cause;
        logger.error("Exception in handler: " + (throwable != null ? throwable.getMessage() : null), cause);
    }

    public static final /* synthetic */ void access$logErrorAndSendResponse(RootHandler $this, ChannelHandlerContext context, Throwable throwable, String uri) {
        $this.logErrorAndSendResponse(context, throwable, uri);
    }

    public static final /* synthetic */ int access$getMaxContentLength$cp() {
        return maxContentLength;
    }

    static {
        Logging logging = Logging.INSTANCE;
        Companion $this$myLogger$iv = Companion;
        boolean $i$f$myLogger = false;
        Logger logger = LoggerFactory.getLogger(Companion.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        RootHandler.logger = logger;
        maxContentLength = 0xA00000;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/station/comms/common/netty/server/RootHandler$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "response", "Lio/netty/handler/codec/http/FullHttpResponse;", "status", "Lio/netty/handler/codec/http/HttpResponseStatus;", "maxContentLength", "", "intellij.station.comms.common"})
    public static final class Companion {
        private Companion() {
        }

        private final FullHttpResponse response(HttpResponseStatus status) {
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
            return (FullHttpResponse)response;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

