/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui.settings.db;

import com.intellij.jpa.jpb.model.ui.renderer.JavaTypeCellRender;
import com.intellij.liquibase.common.config.DatabaseInfo;
import com.intellij.liquibase.common.config.MappingType;
import com.intellij.liquibase.common.gui.settings.db.JavaTypeColumn;
import com.intellij.liquibase.common.gui.settings.db.LiquibaseTypeColumn;
import com.intellij.liquibase.common.gui.settings.db.MappingTypeEditor;
import com.intellij.liquibase.common.gui.settings.db.TableHeaderRenderer;
import com.intellij.liquibase.common.gui.settings.db.TypeParametersColumn;
import com.intellij.liquibase.common.msg.LiquibaseResourceBundle;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.table.JBTable;
import com.intellij.util.SmartList;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0012\u0010\u001c\u001a\u00020\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/intellij/liquibase/common/gui/settings/db/DatabaseInfoPanel;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "mappingTable", "Lcom/intellij/ui/table/JBTable;", "mappingTableModel", "Lcom/intellij/util/ui/ListTableModel;", "Lcom/intellij/liquibase/common/config/MappingType;", "myPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "value", "Lcom/intellij/liquibase/common/config/DatabaseInfo;", "databaseInfo", "getDatabaseInfo", "()Lcom/intellij/liquibase/common/config/DatabaseInfo;", "setDatabaseInfo", "(Lcom/intellij/liquibase/common/config/DatabaseInfo;)V", "checkDumbMode", "", "relativePoint", "Lcom/intellij/ui/awt/RelativePoint;", "showDumbPopup", "", "editItem", "apply", "getPanel", "Ljavax/swing/JPanel;", "intellij.liquibase.common"})
public class DatabaseInfoPanel {
    @NotNull
    private final Project project;
    @NotNull
    private final JBTable mappingTable;
    @NotNull
    private final ListTableModel<MappingType> mappingTableModel;
    @NotNull
    private final BorderLayoutPanel myPanel;
    @Nullable
    private DatabaseInfo databaseInfo;

    /*
     * WARNING - void declaration
     */
    public DatabaseInfoPanel(@NotNull Project project) {
        void it;
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        SmartList smartList = new SmartList[]{new JavaTypeColumn(), new LiquibaseTypeColumn(), new TypeParametersColumn()};
        SmartList smartList2 = smartList;
        smartList = new SmartList();
        this.mappingTableModel = (ListTableModel)new ListTableModel<MappingType>(smartList2, (SmartList<MappingType>)smartList){

            public void addRow() {
                this.addRow(new MappingType());
            }
        };
        this.mappingTable = new JBTable((TableModel)this.mappingTableModel);
        this.mappingTable.getEmptyText().setText(LiquibaseResourceBundle.message("no.override.mappings", new Object[0]));
        this.mappingTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block1: {
                    MouseEvent mouseEvent = e;
                    if (mouseEvent == null) break block1;
                    MouseEvent mouseEvent2 = mouseEvent;
                    DatabaseInfoPanel databaseInfoPanel = this;
                    MouseEvent it = mouseEvent2;
                    boolean bl = false;
                    if (e.getClickCount() == 2) {
                        databaseInfoPanel.editItem(new RelativePoint(it));
                    }
                }
            }
        });
        this.mappingTable.getColumnModel().getColumn(0).setPreferredWidth(220);
        this.mappingTable.getColumnModel().getColumn(0).setCellRenderer((TableCellRenderer)new JavaTypeCellRender());
        this.mappingTable.getColumnModel().getColumn(2).setPreferredWidth(90);
        this.mappingTable.getTableHeader().setDefaultRenderer(new TableHeaderRenderer());
        JPanel jPanel2 = ToolbarDecorator.createDecorator((JTable)((JTable)this.mappingTable)).setToolbarPosition(ActionToolbarPosition.TOP).setEditAction(arg_0 -> DatabaseInfoPanel._init_$lambda$0(this, arg_0)).setAddAction(arg_0 -> DatabaseInfoPanel._init_$lambda$1(this, arg_0)).disableUpAction().disableDownAction().createPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel2, (String)"createPanel(...)");
        JPanel tableDecoratorPanel = jPanel2;
        JPanel form = FormBuilder.createFormBuilder().getPanel();
        this.myPanel = new BorderLayoutPanel(10, 12);
        this.myPanel.addToTop((Component)form);
        JPanel jPanel3 = jPanel = new JPanel(new BorderLayout(10, 4));
        BorderLayoutPanel borderLayoutPanel = this.myPanel;
        boolean bl = false;
        it.add((Component)new JBLabel(LiquibaseResourceBundle.messageWithColon("database.mappingTypes", new Object[0])), "North");
        it.add((Component)tableDecoratorPanel, "Center");
        borderLayoutPanel.addToCenter((Component)jPanel);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final DatabaseInfo getDatabaseInfo() {
        return this.databaseInfo;
    }

    public final void setDatabaseInfo(@Nullable DatabaseInfo value) {
        this.apply();
        this.databaseInfo = value;
        if (value != null) {
            this.mappingTableModel.setItems(value.getMappingTypes());
        }
    }

    private final boolean checkDumbMode(RelativePoint relativePoint) {
        if (DumbService.Companion.isDumb(this.project)) {
            this.showDumbPopup(relativePoint);
            return true;
        }
        return false;
    }

    private final void showDumbPopup(RelativePoint relativePoint) {
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(LiquibaseResourceBundle.message("modifying.type.is.not.available.during.indexing", new Object[0]), MessageType.WARNING, null).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon balloon2 = balloon;
        if (relativePoint != null) {
            balloon2.show(relativePoint, Balloon.Position.below);
        } else {
            balloon2.showInCenterOf((JComponent)this.mappingTable);
        }
    }

    private final void editItem(RelativePoint relativePoint) {
        if (this.checkDumbMode(relativePoint)) {
            return;
        }
        int selectedRow = this.mappingTable.getSelectedRow();
        if (selectedRow < 0 || this.databaseInfo == null) {
            return;
        }
        MappingType selectedItem = (MappingType)this.mappingTableModel.getItem(selectedRow);
        DatabaseInfo databaseInfo = this.databaseInfo;
        Intrinsics.checkNotNull((Object)databaseInfo);
        Intrinsics.checkNotNull((Object)selectedItem);
        MappingTypeEditor mappingTypeEditor = new MappingTypeEditor(this.project, databaseInfo, selectedItem);
        mappingTypeEditor.show();
    }

    public final void apply() {
        if (this.databaseInfo == null) {
            return;
        }
        DatabaseInfo databaseInfo = this.databaseInfo;
        Intrinsics.checkNotNull((Object)databaseInfo);
        List list = this.mappingTableModel.getItems();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
        databaseInfo.setMappingTypes(CollectionsKt.toMutableList((Collection)list));
    }

    @NotNull
    public final JPanel getPanel() {
        return (JPanel)this.myPanel;
    }

    private static final void _init_$lambda$0(DatabaseInfoPanel this$0, AnActionButton it) {
        this$0.editItem(it.getPreferredPopupPoint());
    }

    private static final void _init_$lambda$1(DatabaseInfoPanel this$0, AnActionButton it) {
        if (this$0.checkDumbMode(it.getPreferredPopupPoint())) {
            return;
        }
        MappingType newMappingType = new MappingType();
        Project project = this$0.project;
        DatabaseInfo databaseInfo = this$0.databaseInfo;
        Intrinsics.checkNotNull((Object)databaseInfo);
        MappingTypeEditor mappingTypeEditor = new MappingTypeEditor(project, databaseInfo, newMappingType);
        if (mappingTypeEditor.showAndGet()) {
            this$0.mappingTableModel.addRow((Object)newMappingType);
        }
    }
}

