/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.javaee.ui.JavaeeCodeStyleSettings;
import com.intellij.javaee.ui.NewAbstractDataHolder;
import com.intellij.javaee.web.CommonFilter;
import com.intellij.javaee.web.ServletDataHolder;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.javaee.web.model.xml.Filter;
import com.intellij.psi.PsiClass;

public class FilterDataHolder
extends NewAbstractDataHolder {
    private final boolean myShouldCreateClasses;

    public FilterDataHolder(WebFacet webFacet) {
        super(webFacet.getModule(), webFacet.getWebModel().getFilters(), null);
        this.setName(this.getUniqueName());
        this.setClassName(this.getName());
        this.myShouldCreateClasses = true;
    }

    public FilterDataHolder(Filter source) {
        super(source.getModule(), source.getParent().getFilters(), (String)source.getFilterName().getValue());
        this.setName((String)source.getFilterName().getValue());
        this.setClassName(source.getFilterClass().getStringValue());
        PsiClass psiClass = (PsiClass)source.getFilterClass().getValue();
        if (psiClass != null) {
            this.setClassDirectory(psiClass.getContainingFile().getContainingDirectory());
        }
        this.myShouldCreateClasses = false;
    }

    public String getNamePrefix(JavaeeCodeStyleSettings settings) {
        return settings.FILTER_CLASS_PREFIX;
    }

    public String getNameSuffix(JavaeeCodeStyleSettings settings) {
        return settings.FILTER_CLASS_SUFFIX;
    }

    private boolean shouldCreateClasses() {
        return this.myShouldCreateClasses;
    }

    protected String getDefaultName() {
        return "Filter";
    }

    protected String getObjectName(Object o) {
        return (String)((CommonFilter)o).getFilterName().getValue();
    }

    public void installTo(Filter filter) {
        filter.getFilterName().setValue((Object)this.getName());
        filter.getFilterClass().setStringValue(this.getClassName());
        if (this.shouldCreateClasses()) {
            ServletDataHolder.createClass(this, "Filter Class.java");
        }
    }
}

