/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.javaee.util.JavaeeHighlightingVisitor;
import com.intellij.javaee.web.WebBundle;
import com.intellij.javaee.web.model.xml.FilterMapping;
import com.intellij.javaee.web.model.xml.ServletMapping;
import com.intellij.javaee.web.model.xml.WebApp;
import com.intellij.javaee.web.model.xml.WebAppVersion;
import com.intellij.patterns.CharPattern;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.util.Consumer;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class WebXmlInspection
extends BasicDomElementsInspection<WebApp> {
    private static final ElementPattern URL_PATTERN_PATTERN = StandardPatterns.not((ElementPattern)StandardPatterns.string().contains((ElementPattern)CharPattern.whitespaceCharacter()));

    public WebXmlInspection() {
        super(WebApp.class, new Class[0]);
    }

    protected void checkDomElement(@NotNull DomElement element, @NotNull DomElementAnnotationHolder holder, @NotNull DomHighlightingHelper helper) {
        if (element == null) {
            WebXmlInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            WebXmlInspection.$$$reportNull$$$0(1);
        }
        if (helper == null) {
            WebXmlInspection.$$$reportNull$$$0(2);
        }
        int oldSize = holder.getSize();
        if (element instanceof ServletMapping) {
            WebXmlInspection.checkUrlPatterns(holder, ((ServletMapping)element).getUrlPatterns());
        } else if (element instanceof FilterMapping) {
            FilterMapping filterMapping = (FilterMapping)element;
            List urlPatterns = filterMapping.getUrlPatterns();
            List servletNames = filterMapping.getServletNames();
            if (urlPatterns.isEmpty() && servletNames.isEmpty()) {
                holder.createProblem(element, WebBundle.message("error.message.servlet.name.or.uri.pattern.should.be.defined", new Object[0]), new LocalQuickFix[0]);
            }
            WebXmlInspection.checkUrlPatterns(holder, urlPatterns);
        } else if (element instanceof WebApp) {
            WebApp webApp = (WebApp)element;
            Consumer duplicateUrlPattern = genericDomValue -> holder.createProblem((DomElement)genericDomValue, WebBundle.message("error.message.duplicate.url.pattern", new Object[0]), new LocalQuickFix[0]);
            JavaeeHighlightingVisitor.checkDuplicates((Collection)webApp.getServletMappings(), (servletMapping, pairConsumer) -> {
                for (GenericDomValue value : servletMapping.getUrlPatterns()) {
                    pairConsumer.consume((Object)value, (Object)value.getStringValue());
                }
            }, (Consumer)duplicateUrlPattern);
        }
        if (oldSize == holder.getSize()) {
            super.checkDomElement(element, holder, helper);
        }
    }

    private static void checkUrlPatterns(DomElementAnnotationHolder holder, List<? extends GenericDomValue<String>> urlPatterns) {
        for (GenericDomValue<String> genericDomValue : urlPatterns) {
            Required required;
            WebAppVersion version;
            WebApp app;
            String stringValue = genericDomValue.getStringValue();
            if (!URL_PATTERN_PATTERN.accepts((Object)stringValue)) {
                holder.createProblem(genericDomValue, WebBundle.message("error.message.uri.pattern.must.not.contain.whitespaces", new Object[0]), new LocalQuickFix[0]);
            }
            if (stringValue == null || !stringValue.isEmpty() || (app = (WebApp)DomUtil.getParentOfType(genericDomValue, WebApp.class, (boolean)true)) == null || (version = (WebAppVersion)app.getVersion().getValue()) == null || WebAppVersion.WebAppVersion_3_0.compareTo((Enum)version) < 0 || (required = (Required)genericDomValue.getAnnotation(Required.class)) != null && required.nonEmpty()) continue;
            holder.createProblem(genericDomValue, XmlDomBundle.message((String)"dom.inspections.value.must.not.be.empty", (Object[])new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "helper";
                break;
            }
        }
        objectArray[1] = "com/intellij/javaee/web/highlighting/WebXmlInspection";
        objectArray[2] = "checkDomElement";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

