/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.runtime;

import com.intellij.spring.runtime.SpringRuntimeBeanResolver;
import com.intellij.spring.runtime.SpringRuntimeBeanResolverImpl;
import com.intellij.spring.runtime.SpringRuntimeResolverService;
import com.intellij.spring.runtime.SpringRuntimeResource;
import com.intellij.spring.runtime.SpringRuntimeResourceImpl;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J8\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u00072\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/spring/runtime/SpringRuntimeResolverServiceImpl;", "Lcom/intellij/spring/runtime/SpringRuntimeResolverService;", "<init>", "()V", "createResource", "Lcom/intellij/spring/runtime/SpringRuntimeResource;", "description", "", "path", "createBeanResolver", "Lcom/intellij/spring/runtime/SpringRuntimeBeanResolver;", "id", "type", "name", "factoryMethodName", "resource", "removeFileProtocol", "extractPath", "intellij.spring.core"})
public final class SpringRuntimeResolverServiceImpl
implements SpringRuntimeResolverService {
    @NotNull
    public SpringRuntimeResource createResource(@NotNull String description, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new SpringRuntimeResourceImpl(description, path);
    }

    @NotNull
    public SpringRuntimeBeanResolver createBeanResolver(@NotNull String id, @Nullable String type, @Nullable String name, @Nullable String factoryMethodName, @Nullable SpringRuntimeResource resource) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return new SpringRuntimeBeanResolverImpl(id, type, name, factoryMethodName, resource);
    }

    @NotNull
    public String removeFileProtocol(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.removePrefix((String)StringsKt.removePrefix((String)path, (CharSequence)"file:"), (CharSequence)"//");
    }

    @Nullable
    public String extractPath(@NotNull String description) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        int start = StringsKt.indexOf$default((CharSequence)description, (char)'[', (int)0, (boolean)false, (int)6, null);
        if (start < 0 || start == description.length() - 1) {
            return null;
        }
        String string = description.substring(start + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String path = string;
        int end = StringsKt.indexOf$default((CharSequence)path, (char)']', (int)0, (boolean)false, (int)6, null);
        if (end == 0) {
            return null;
        }
        if (end > 0) {
            String string2 = path.substring(0, end);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return string2;
        }
        end = StringsKt.indexOf$default((CharSequence)path, (char)'\'', (int)0, (boolean)false, (int)6, null);
        if (end == 0) {
            return null;
        }
        if (end > 0) {
            String string3 = path.substring(0, end);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return string3;
        }
        return path;
    }
}

