/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.security.references;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.PomTarget;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.PomTargetPsiElementImpl;
import com.intellij.spring.security.SpringSecurityIcons;
import com.intellij.spring.security.model.jam.roles.SpringJamRolesHolder;
import com.intellij.spring.security.model.xml.converters.roles.SpringSecurityPomTargetRole;
import com.intellij.spring.security.references.SpringSecurityRoleUtils;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class SpringSecurityRolePsiReference
extends PsiReferenceBase<PsiElement>
implements HighlightedReference {
    private static final List<String> PREDEFINED_ROLES = Arrays.asList("IS_AUTHENTICATED_ANONYMOUSLY", "IS_AUTHENTICATED_FULLY", "IS_AUTHENTICATED_REMEMBERED");
    private final String myRoleName;
    private final Module myModule;
    private final boolean myIncludePredefinedRoles;

    public SpringSecurityRolePsiReference(@NotNull PsiElement element, @NotNull String roleName, @NotNull Module module, boolean includePredefinedRoles) {
        if (element == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(0);
        }
        if (roleName == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(1);
        }
        if (module == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(2);
        }
        this(element, roleName, module, includePredefinedRoles, false);
    }

    public SpringSecurityRolePsiReference(@NotNull PsiElement element, @NotNull String roleName, @NotNull Module module, boolean includePredefinedRoles, boolean soft) {
        if (element == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(3);
        }
        if (roleName == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(4);
        }
        if (module == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(5);
        }
        this(element, SpringSecurityRolePsiReference.getTextRange(element, roleName), roleName, module, includePredefinedRoles, soft);
    }

    public SpringSecurityRolePsiReference(@NotNull PsiElement element, @NotNull TextRange range, @NotNull String roleName, @NotNull Module module, boolean includePredefinedRoles, boolean soft) {
        if (element == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(6);
        }
        if (range == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(7);
        }
        if (roleName == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(8);
        }
        if (module == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(9);
        }
        super(element, range, soft);
        this.myRoleName = roleName;
        this.myModule = module;
        this.myIncludePredefinedRoles = includePredefinedRoles;
    }

    private static TextRange getTextRange(PsiElement element, String roleName) {
        if (roleName.isEmpty()) {
            return TextRange.EMPTY_RANGE;
        }
        int offset = element.getText().indexOf(roleName);
        if (offset == -1) {
            return TextRange.EMPTY_RANGE;
        }
        return TextRange.from((int)offset, (int)roleName.length());
    }

    public PsiElement resolve() {
        if (StringUtil.isEmptyOrSpaces((String)this.myRoleName)) {
            return null;
        }
        return this.createSpringSecurityRolePomTargetPsiElement();
    }

    @NotNull
    protected PomTargetPsiElementImpl createSpringSecurityRolePomTargetPsiElement() {
        return new SpringSecurityRoleFakeElement(this.getElement().getProject(), (PomTarget)SpringSecurityPomTargetRole.create(this.myRoleName));
    }

    public Object @NotNull [] getVariants() {
        LinkedHashSet<LookupElementBuilder> variants = new LinkedHashSet<LookupElementBuilder>();
        for (SpringJamRolesHolder<?> holder : SpringSecurityRoleUtils.collectJamRoles(this.myModule)) {
            variants.addAll(SpringSecurityRolePsiReference.getLookupElements(holder.getRoles()));
        }
        variants.addAll(SpringSecurityRolePsiReference.getLookupElements(SpringSecurityRoleUtils.collectRoles(this.myModule)));
        if (this.myIncludePredefinedRoles) {
            ContainerUtil.addAll(variants, (Object[])ContainerUtil.map2Array(PREDEFINED_ROLES, s -> LookupElementBuilder.create((String)s).withIcon(SpringSecurityIcons.SpringSecurity).withTypeText("Predefined Role").bold()));
        }
        Object[] objectArray = ContainerUtil.map2Array(variants, le -> {
            if (le instanceof LookupElement) {
                LookupElement element = (LookupElement)le;
                return PrioritizedLookupElement.withPriority((LookupElement)element, (double)1000.0);
            }
            return le;
        });
        if (objectArray == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(10);
        }
        return objectArray;
    }

    @NotNull
    private static Set<LookupElementBuilder> getLookupElements(@NotNull Set<String> roles) {
        if (roles == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(11);
        }
        Set<LookupElementBuilder> set = roles.stream().filter(s -> StringUtil.isNotEmpty((String)s)).map(s -> LookupElementBuilder.create((String)s).withTypeText("Application Role").withIcon(SpringSecurityIcons.SpringSecurity).bold()).collect(Collectors.toSet());
        if (set == null) {
            SpringSecurityRolePsiReference.$$$reportNull$$$0(12);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roleName";
                break;
            }
            case 2: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/security/references/SpringSecurityRolePsiReference";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/security/references/SpringSecurityRolePsiReference";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 12: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLookupElements";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 10, 12 -> new IllegalStateException(string);
        };
    }

    public static final class SpringSecurityRoleFakeElement
    extends PomTargetPsiElementImpl {
        public SpringSecurityRoleFakeElement(@NotNull Project project, @NotNull PomTarget target) {
            if (project == null) {
                SpringSecurityRoleFakeElement.$$$reportNull$$$0(0);
            }
            if (target == null) {
                SpringSecurityRoleFakeElement.$$$reportNull$$$0(1);
            }
            super(project, target);
        }

        public boolean canNavigate() {
            return true;
        }

        public void navigate(boolean requestFocus) {
            if (DumbService.getInstance((Project)this.getProject()).isDumb()) {
                return;
            }
            Editor editor = FileEditorManager.getInstance((Project)this.getProject()).getSelectedTextEditor();
            if (editor == null) {
                return;
            }
            ShowUsagesAction.startFindUsages((PsiElement)this, (RelativePoint)JBPopupFactory.getInstance().guessBestPopupLocation(editor), (Editor)editor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "target";
                    break;
                }
            }
            objectArray[1] = "com/intellij/spring/security/references/SpringSecurityRolePsiReference$SpringSecurityRoleFakeElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

