/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.runScope;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.javascript.testing.JsTestConfigurationUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0002#$B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0013\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\u000bH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001c\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006%"}, d2={"Lcom/intellij/javascript/testing/runScope/JsTestRunScope;", "", "builder", "Lcom/intellij/javascript/testing/runScope/JsTestRunScope$Builder;", "<init>", "(Lcom/intellij/javascript/testing/runScope/JsTestRunScope$Builder;)V", "kind", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;", "getKind", "()Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;", "testDirectoryPath", "", "getTestDirectoryPath", "()Ljava/lang/String;", "testFilePath", "getTestFilePath", "testNames", "", "Lcom/intellij/openapi/util/NlsSafe;", "getTestNames", "()Ljava/util/List;", "writeExternal", "", "element", "Lorg/jdom/Element;", "validateForRunConfiguration", "expandMacrosInTestFilePath", "", "normalize", "isNormalized", "equals", "other", "hashCode", "", "toString", "Builder", "Companion", "intellij.javascript.backend"})
public final class JsTestRunScope {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JsTestRunScopeKind kind;
    @NotNull
    private final String testDirectoryPath;
    @NotNull
    private final String testFilePath;
    @NotNull
    private final List<String> testNames;
    @NotNull
    private static final String TAG__SCOPE_KIND = "scope-kind";
    @NotNull
    private static final String TAG__TEST_DIRECTORY = "test-directory";
    @NotNull
    private static final String TAG__TEST_FILE = "test-file";
    @NotNull
    private static final String TAG__TEST_NAMES = "test-names";
    @NotNull
    private static final String TAG__TEST_NAME = "test-name";

    private JsTestRunScope(Builder builder2) {
        this.kind = builder2.getKind();
        this.testDirectoryPath = builder2.getTestDirectoryPath();
        this.testFilePath = builder2.getTestFilePath();
        List<String> list = Collections.unmodifiableList(builder2.getTestNames());
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        this.testNames = list;
    }

    @NotNull
    public final JsTestRunScopeKind getKind() {
        return this.kind;
    }

    @NotNull
    public final String getTestDirectoryPath() {
        return this.testDirectoryPath;
    }

    @NotNull
    public final String getTestFilePath() {
        return this.testFilePath;
    }

    @NotNull
    public final List<String> getTestNames() {
        return this.testNames;
    }

    @NotNull
    public final Builder builder() {
        return new Builder(this.kind, this.testDirectoryPath, this.testFilePath, this.testNames);
    }

    public final void writeExternal(@NotNull Element element2) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__SCOPE_KIND, this.kind.name());
        if (this.kind == JsTestRunScopeKind.DIRECTORY) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__TEST_DIRECTORY, FileUtil.toSystemIndependentName((String)this.testDirectoryPath));
        }
        if (this.kind == JsTestRunScopeKind.TEST_FILE || this.kind == JsTestRunScopeKind.SUITE || this.kind == JsTestRunScopeKind.TEST) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element2, TAG__TEST_FILE, FileUtil.toSystemIndependentName((String)this.testFilePath));
        }
        if (this.kind == JsTestRunScopeKind.SUITE || this.kind == JsTestRunScopeKind.TEST) {
            Element testNamesElement = new Element(TAG__TEST_NAMES);
            if (!((Collection)this.testNames).isEmpty()) {
                JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)testNamesElement, (String)TAG__TEST_NAME, this.testNames);
            }
            element2.addContent(testNamesElement);
        }
    }

    public final void validateForRunConfiguration(boolean expandMacrosInTestFilePath) {
        if (this.kind == JsTestRunScopeKind.DIRECTORY) {
            JsTestConfigurationUtil.INSTANCE.validatePath(true, "test directory", this.testDirectoryPath);
        } else if (this.kind == JsTestRunScopeKind.TEST_FILE || this.kind == JsTestRunScopeKind.SUITE || this.kind == JsTestRunScopeKind.TEST) {
            if (!expandMacrosInTestFilePath || Intrinsics.areEqual((Object)this.testFilePath, (Object)ProgramParametersConfigurator.expandMacros((String)this.testFilePath))) {
                JsTestConfigurationUtil.INSTANCE.validatePath(false, "test file", this.testFilePath);
            }
            if (this.kind == JsTestRunScopeKind.SUITE && this.testNames.isEmpty()) {
                throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.unspecified.suite.name", (Object[])new Object[0]));
            }
            if (this.kind == JsTestRunScopeKind.TEST && this.testNames.isEmpty()) {
                throw new RuntimeConfigurationError(JavaScriptBundle.message((String)"dialog.message.unspecified.test.name", (Object[])new Object[0]));
            }
        }
    }

    @NotNull
    public final JsTestRunScope normalize() {
        Builder builder2;
        if (this.isNormalized()) {
            return this;
        }
        Builder it = builder2 = new Builder(null, null, null, null, 15, null);
        boolean bl = false;
        it.setKind(this.kind);
        switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                it.setTestDirectoryPath(this.testDirectoryPath);
                break;
            }
            case 3: {
                it.setTestFilePath(this.testFilePath);
                break;
            }
            case 4: 
            case 5: {
                it.setTestFilePath(this.testFilePath);
                it.setTestNames(this.testNames);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return builder2.build();
    }

    private final boolean isNormalized() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.kind.ordinal()]) {
            case 1 -> {
                if (((CharSequence)this.testDirectoryPath).length() == 0 && ((CharSequence)this.testFilePath).length() == 0 && this.testNames.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (((CharSequence)this.testFilePath).length() == 0 && this.testNames.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                if (((CharSequence)this.testDirectoryPath).length() == 0 && this.testNames.isEmpty()) {
                    yield true;
                }
                yield false;
            }
            case 4, 5 -> {
                if (((CharSequence)this.testDirectoryPath).length() == 0) {
                    yield true;
                }
                yield false;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.intellij.javascript.testing.runScope.JsTestRunScope");
        JsTestRunScope cfr_ignored_0 = (JsTestRunScope)object2;
        return this.kind == ((JsTestRunScope)other).kind && Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)this.testDirectoryPath), (Object)FileUtil.toSystemIndependentName((String)((JsTestRunScope)other).testDirectoryPath)) && Intrinsics.areEqual((Object)FileUtil.toSystemIndependentName((String)this.testFilePath), (Object)FileUtil.toSystemIndependentName((String)((JsTestRunScope)other).testFilePath)) && Intrinsics.areEqual(this.testNames, ((JsTestRunScope)other).testNames);
    }

    public int hashCode() {
        int result2 = this.kind.hashCode();
        result2 = 31 * result2 + FileUtil.toSystemIndependentName((String)this.testDirectoryPath).hashCode();
        result2 = 31 * result2 + FileUtil.toSystemIndependentName((String)this.testFilePath).hashCode();
        result2 = 31 * result2 + ((Object)this.testNames).hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "(" + this.kind + ", testDirectoryPath='" + this.testDirectoryPath + "', testFilePath='" + this.testFilePath + "', testNames=" + this.testNames + ")";
    }

    @JvmStatic
    @NotNull
    public static final JsTestRunScope readExternal(@NotNull Element element2) {
        return Companion.readExternal(element2);
    }

    public /* synthetic */ JsTestRunScope(Builder builder2, DefaultConstructorMarker $constructor_marker) {
        this(builder2);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B:\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\u0013\b\u0002\u0010\u0007\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0005J\u0014\u0010\u0007\u001a\u00020\u00002\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u0006\u0010\u001a\u001a\u00020\u001bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0011\"\u0004\b\u0015\u0010\u0013R%\u0010\u0007\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\t0\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/intellij/javascript/testing/runScope/JsTestRunScope$Builder;", "", "kind", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;", "testDirectoryPath", "", "testFilePath", "testNames", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getKind", "()Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;", "setKind", "(Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;)V", "getTestDirectoryPath", "()Ljava/lang/String;", "setTestDirectoryPath", "(Ljava/lang/String;)V", "getTestFilePath", "setTestFilePath", "getTestNames", "()Ljava/util/List;", "setTestNames", "(Ljava/util/List;)V", "build", "Lcom/intellij/javascript/testing/runScope/JsTestRunScope;", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nJsTestRunScope.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsTestRunScope.kt\ncom/intellij/javascript/testing/runScope/JsTestRunScope$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
    public static final class Builder {
        @NotNull
        private JsTestRunScopeKind kind;
        @NotNull
        private String testDirectoryPath;
        @NotNull
        private String testFilePath;
        @NotNull
        private List<String> testNames;

        public Builder(@NotNull JsTestRunScopeKind kind, @NotNull String testDirectoryPath, @NotNull String testFilePath, @NotNull List<String> testNames) {
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Intrinsics.checkNotNullParameter((Object)testDirectoryPath, (String)"testDirectoryPath");
            Intrinsics.checkNotNullParameter((Object)testFilePath, (String)"testFilePath");
            Intrinsics.checkNotNullParameter(testNames, (String)"testNames");
            this.kind = kind;
            this.testDirectoryPath = testDirectoryPath;
            this.testFilePath = testFilePath;
            this.testNames = testNames;
        }

        public /* synthetic */ Builder(JsTestRunScopeKind jsTestRunScopeKind, String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                jsTestRunScopeKind = JsTestRunScopeKind.ALL;
            }
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                string2 = "";
            }
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(jsTestRunScopeKind, string, string2, list);
        }

        @NotNull
        public final JsTestRunScopeKind getKind() {
            return this.kind;
        }

        public final void setKind(@NotNull JsTestRunScopeKind jsTestRunScopeKind) {
            Intrinsics.checkNotNullParameter((Object)((Object)jsTestRunScopeKind), (String)"<set-?>");
            this.kind = jsTestRunScopeKind;
        }

        @NotNull
        public final String getTestDirectoryPath() {
            return this.testDirectoryPath;
        }

        public final void setTestDirectoryPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.testDirectoryPath = string;
        }

        @NotNull
        public final String getTestFilePath() {
            return this.testFilePath;
        }

        public final void setTestFilePath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.testFilePath = string;
        }

        @NotNull
        public final List<String> getTestNames() {
            return this.testNames;
        }

        public final void setTestNames(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.testNames = list;
        }

        @NotNull
        public final Builder kind(@NotNull JsTestRunScopeKind kind) {
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
            Builder it = builder2 = this;
            boolean bl = false;
            this.kind = kind;
            return builder2;
        }

        @NotNull
        public final Builder testDirectoryPath(@NotNull String testDirectoryPath) {
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)testDirectoryPath, (String)"testDirectoryPath");
            Builder it = builder2 = this;
            boolean bl = false;
            this.testDirectoryPath = testDirectoryPath;
            return builder2;
        }

        @NotNull
        public final Builder testFilePath(@NotNull String testFilePath) {
            Builder builder2;
            Intrinsics.checkNotNullParameter((Object)testFilePath, (String)"testFilePath");
            Builder it = builder2 = this;
            boolean bl = false;
            this.testFilePath = testFilePath;
            return builder2;
        }

        @NotNull
        public final Builder testNames(@NotNull List<String> testNames) {
            Builder builder2;
            Intrinsics.checkNotNullParameter(testNames, (String)"testNames");
            Builder it = builder2 = this;
            boolean bl = false;
            this.testNames = testNames;
            return builder2;
        }

        @NotNull
        public final JsTestRunScope build() {
            return new JsTestRunScope(this, null);
        }

        public Builder() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u0007H\u0002R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/testing/runScope/JsTestRunScope$Companion;", "", "<init>", "()V", "readExternal", "Lcom/intellij/javascript/testing/runScope/JsTestRunScope;", "element", "Lorg/jdom/Element;", "readScopeKind", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;", "readTestNames", "", "", "parent", "TAG__SCOPE_KIND", "TAG__TEST_DIRECTORY", "TAG__TEST_FILE", "TAG__TEST_NAMES", "TAG__TEST_NAME", "intellij.javascript.backend"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JsTestRunScope readExternal(@NotNull Element element2) {
            Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
            Builder builder2 = new Builder(null, null, null, null, 15, null);
            JsTestRunScopeKind scopeKind = this.readScopeKind(element2);
            builder2.setKind(scopeKind);
            if (scopeKind == JsTestRunScopeKind.DIRECTORY) {
                String string = JsTestConfigurationUtil.INSTANCE.readValue(element2, JsTestRunScope.TAG__TEST_DIRECTORY);
                if (string == null) {
                    string = "";
                }
                builder2.setTestDirectoryPath(string);
            }
            if (scopeKind == JsTestRunScopeKind.TEST_FILE || scopeKind == JsTestRunScopeKind.SUITE || scopeKind == JsTestRunScopeKind.TEST) {
                String string = JsTestConfigurationUtil.INSTANCE.readValue(element2, JsTestRunScope.TAG__TEST_FILE);
                if (string == null) {
                    string = "";
                }
                builder2.setTestFilePath(string);
            }
            if (scopeKind == JsTestRunScopeKind.SUITE || scopeKind == JsTestRunScopeKind.TEST) {
                builder2.setTestNames(this.readTestNames(element2));
            }
            return builder2.build();
        }

        private final JsTestRunScopeKind readScopeKind(Element element2) {
            JsTestRunScopeKind jsTestRunScopeKind;
            String string = JsTestConfigurationUtil.INSTANCE.readValue(element2, JsTestRunScope.TAG__SCOPE_KIND);
            if (string == null) {
                string = "";
            }
            String scopeKindStr = string;
            try {
                jsTestRunScopeKind = JsTestRunScopeKind.valueOf(scopeKindStr);
            }
            catch (Exception ignored) {
                jsTestRunScopeKind = JsTestRunScopeKind.ALL;
            }
            return jsTestRunScopeKind;
        }

        private final List<String> readTestNames(Element parent) {
            Element element2 = parent.getChild(JsTestRunScope.TAG__TEST_NAMES);
            if (element2 == null) {
                return CollectionsKt.emptyList();
            }
            Element testNamesElement = element2;
            List list = JDOMExternalizerUtil.getChildrenValueAttributes((Element)testNamesElement, (String)JsTestRunScope.TAG__TEST_NAME);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenValueAttributes(...)");
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[JsTestRunScopeKind.values().length];
            try {
                nArray[JsTestRunScopeKind.ALL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.DIRECTORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.TEST_FILE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.TEST.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JsTestRunScopeKind.SUITE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

