/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.intentions.CommentsMover;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JSJoinVariableStatementsIntention
extends JavaScriptIntention
implements LowPriorityAction {
    public JSJoinVariableStatementsIntention() {
        this.setText(this.getFamilyName());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element2) throws IncorrectOperationException {
        if (project == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(0);
        }
        if (element2 == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(1);
        }
        List<JSVarStatement> statements = JSJoinVariableStatementsIntention.findSubsequentVarStatements(element2);
        StringBuilder newStatementBuilder = new StringBuilder();
        JSVarStatement initialStatement = statements.get(0);
        boolean isExported = JSPsiImplUtils.hasModifier((JSAttributeListOwner)initialStatement, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.EXPORT);
        boolean isDeclare = JSPsiImplUtils.hasModifier((JSAttributeListOwner)initialStatement, (JSAttributeList.ModifierType)JSAttributeList.ModifierType.DECLARE);
        if (isExported) {
            newStatementBuilder.append("export ");
        }
        if (isDeclare) {
            newStatementBuilder.append("declare ");
        }
        newStatementBuilder.append(Objects.requireNonNull(initialStatement.getVarKeyword()).getText()).append(" ");
        boolean first = true;
        for (JSVarStatement statement : statements) {
            JSInitializerOwner[] declarations = statement.getDeclarations();
            for (JSInitializerOwner variable : declarations) {
                if (first) {
                    first = false;
                } else {
                    newStatementBuilder.append(", ");
                }
                newStatementBuilder.append(variable.getText());
            }
        }
        newStatementBuilder.append(JSCodeStyleSettings.getSemicolon((PsiElement)element2));
        JSStatement newStatement = JSPsiElementFactory.createJSStatement((String)newStatementBuilder.toString(), (PsiElement)element2);
        JSVarStatement replaced = (JSVarStatement)initialStatement.getParent().addBefore((PsiElement)newStatement, (PsiElement)initialStatement);
        HashSet elements = ContainerUtil.newHashSet((Object[])new PsiElement[]{replaced});
        for (JSVarStatement statement : statements) {
            JSInitializerOwner[] declarations = statement.getDeclarations();
            if (declarations.length != 1 || !(declarations[0] instanceof JSVariable)) {
                CommentsMover commentsMover = new CommentsMover((JSSourceElement)statement);
                commentsMover.move(elements, elements);
            } else {
                String name = ((JSVariable)declarations[0]).getName();
                CommentsMover commentsMover = new CommentsMover((JSSourceElement)statement, true);
                for (JSVariable variable : replaced.getVariables()) {
                    if (!Objects.equals(name, variable.getName())) continue;
                    HashSet varr = ContainerUtil.newHashSet((Object[])new PsiElement[]{variable});
                    commentsMover.move(varr, varr);
                    break;
                }
            }
            NewLineEraser eraser = new NewLineEraser((PsiElement)statement);
            statement.delete();
            eraser.process();
        }
        JSJoinVariableStatementsIntention.fixCommentsIndents(editor, replaced);
    }

    private static void fixCommentsIndents(@NotNull Editor editor, @NotNull JSVarStatement replaced) {
        if (editor == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(2);
        }
        if (replaced == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(3);
        }
        LogicalPosition position = editor.offsetToLogicalPosition(replaced.getTextOffset());
        int offsetFromLineStart = position.column;
        String shift = StringUtil.repeat((String)" ", (int)offsetFromLineStart);
        PsiElement prevSibling = replaced.getPrevSibling();
        ArrayList<PsiElement> possiblyToDelete = new ArrayList<PsiElement>();
        while (prevSibling instanceof PsiComment || prevSibling instanceof PsiWhiteSpace) {
            if (prevSibling instanceof PsiWhiteSpace) {
                possiblyToDelete.add(prevSibling);
            } else {
                JSJoinVariableStatementsIntention.deleteWhitespaceIfNeeded(shift, possiblyToDelete);
            }
            prevSibling = prevSibling.getPrevSibling();
        }
        JSJoinVariableStatementsIntention.deleteWhitespaceIfNeeded(shift, possiblyToDelete);
    }

    private static void deleteWhitespaceIfNeeded(@NotNull String shift, @NotNull List<PsiElement> possiblyToDelete) {
        if (shift == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(4);
        }
        if (possiblyToDelete == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(5);
        }
        if (!possiblyToDelete.isEmpty()) {
            boolean one = true;
            for (PsiElement psiElement : ContainerUtil.reverse(possiblyToDelete)) {
                if (one) {
                    one = false;
                    psiElement.replace(JSChangeUtil.createTokenElement((PsiElement)psiElement, (IElementType)JSTokenTypes.WHITE_SPACE, (CharSequence)(StringUtil.convertLineSeparators((String)"\r\n") + shift)));
                    continue;
                }
                psiElement.delete();
            }
            possiblyToDelete.clear();
        }
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element2) {
        if (project == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(6);
        }
        if (element2 == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(7);
        }
        return JSJoinVariableStatementsIntention.findSubsequentVarStatements(element2).size() > 1;
    }

    @NotNull
    private static List<JSVarStatement> findSubsequentVarStatements(PsiElement element2) {
        PsiElement parent = element2.getParent();
        JSVarStatement initial = null;
        if (parent instanceof JSVarStatement) {
            initial = (JSVarStatement)parent;
        } else if (parent instanceof JSVariable) {
            initial = ((JSVariable)parent).getStatement();
        }
        if (initial == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSJoinVariableStatementsIntention.$$$reportNull$$$0(8);
            }
            return list;
        }
        JSVarStatement.VarKeyword initialVarKeyword = initial.getVarKeyword();
        if (initialVarKeyword == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSJoinVariableStatementsIntention.$$$reportNull$$$0(9);
            }
            return list;
        }
        boolean isDeclareInitial = JSJoinVariableStatementsIntention.isDeclare(initial);
        boolean isExportInitial = JSJoinVariableStatementsIntention.isExport(initial);
        ArrayList<JSVarStatement> statements = new ArrayList<JSVarStatement>();
        PsiElement prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)initial);
        while (prev instanceof JSVarStatement && ((JSVarStatement)prev).getVarKeyword() == initialVarKeyword && isDeclareInitial == JSJoinVariableStatementsIntention.isDeclare((JSVarStatement)prev) && isExportInitial == JSJoinVariableStatementsIntention.isExport((JSVarStatement)prev)) {
            statements.add(0, (JSVarStatement)prev);
            prev = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)prev);
        }
        statements.add(initial);
        PsiElement next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)initial);
        while (next instanceof JSVarStatement && ((JSVarStatement)next).getVarKeyword() == initialVarKeyword && isDeclareInitial == JSJoinVariableStatementsIntention.isDeclare((JSVarStatement)next) && isExportInitial == JSJoinVariableStatementsIntention.isExport((JSVarStatement)next)) {
            statements.add((JSVarStatement)next);
            next = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)next);
        }
        ArrayList<JSVarStatement> arrayList = statements;
        if (arrayList == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private static boolean isDeclare(JSVarStatement initial) {
        JSAttributeList attributeList = initial.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    private static boolean isExport(JSVarStatement initial) {
        JSAttributeList attributeList = initial.getAttributeList();
        return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.EXPORT);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = JavaScriptBundle.message((String)"js.join.vars.intention", (Object[])new Object[0]);
        if (string == null) {
            JSJoinVariableStatementsIntention.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaced";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shift";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possiblyToDelete";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSJoinVariableStatementsIntention";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSJoinVariableStatementsIntention";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findSubsequentVarStatements";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fixCommentsIndents";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteWhitespaceIfNeeded";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 10, 11 -> new IllegalStateException(string);
        };
    }
}

