/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.structure.sorting;

import com.intellij.jupyter.core.jupyter.helper.JupyterCellLinesExtensionsKt;
import com.intellij.jupyter.core.jupyter.structure.elements.JupyterStructureViewCellElement;
import com.intellij.jupyter.core.jupyter.structure.model.JupyterStructureViewModel;
import com.intellij.jupyter.core.jupyter.structure.sorting.JupyterStructureSortingOptionsState;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J*\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0012j\b\u0012\u0004\u0012\u00020\n`\u00132\u0006\u0010\r\u001a\u00020\u000eJ,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\n0\u0012j\b\u0012\u0004\u0012\u00020\n`\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingUtils;", "", "<init>", "()V", "getSettings", "Lcom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingOptionsState;", "project", "Lcom/intellij/openapi/project/Project;", "applySorting", "", "Lcom/intellij/jupyter/core/jupyter/structure/elements/JupyterStructureViewCellElement;", "elements", "", "psiFile", "Lorg/jetbrains/plugins/notebooks/psi/jupyter/psi/JupyterFile;", "model", "Lcom/intellij/jupyter/core/jupyter/structure/model/JupyterStructureViewModel;", "createExecutionOrderComparator", "Ljava/util/Comparator;", "Lkotlin/Comparator;", "applyPriorityFilters", "sortingSettings", "createPrioritizedGroupComparator", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterStructureSortingUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterStructureSortingUtils.kt\ncom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,65:1\n3301#2,10:66\n1056#2:76\n*S KotlinDebug\n*F\n+ 1 JupyterStructureSortingUtils.kt\ncom/intellij/jupyter/core/jupyter/structure/sorting/JupyterStructureSortingUtils\n*L\n39#1:66,10\n50#1:76\n*E\n"})
public final class JupyterStructureSortingUtils {
    @NotNull
    public static final JupyterStructureSortingUtils INSTANCE = new JupyterStructureSortingUtils();

    private JupyterStructureSortingUtils() {
    }

    @NotNull
    public final JupyterStructureSortingOptionsState getSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return JupyterStructureSortingOptionsState.Companion.getInstance(project);
    }

    @NotNull
    public final List<JupyterStructureViewCellElement> applySorting(@NotNull List<JupyterStructureViewCellElement> elements, @NotNull JupyterFile psiFile, @NotNull JupyterStructureViewModel model) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)((Object)model), (String)"model");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        JupyterStructureSortingOptionsState sortingSettings = this.getSettings(project);
        List sortedElements = switch (WhenMappings.$EnumSwitchMapping$0[sortingSettings.getSortBy().ordinal()]) {
            case 1 -> elements;
            case 2 -> CollectionsKt.sortedWith((Iterable)elements, this.createExecutionOrderComparator(psiFile));
            default -> throw new NoWhenBranchMatchedException();
        };
        return this.applyPriorityFilters(sortedElements, sortingSettings, model);
    }

    @NotNull
    public final Comparator<JupyterStructureViewCellElement> createExecutionOrderComparator(@NotNull JupyterFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Comparator comparator = new Comparator(psiFile){
            final /* synthetic */ JupyterFile $psiFile$inlined;
            {
                this.$psiFile$inlined = jupyterFile;
            }

            public final int compare(T a, T b) {
                Object object;
                Object object2;
                JupyterStructureViewCellElement element = (JupyterStructureViewCellElement)b;
                boolean bl = false;
                NotebookCellLines.Interval interval = element.getInterval();
                Comparable comparable = !Intrinsics.areEqual((Object)JupyterCellLinesExtensionsKt.toJupyterCellType(interval.getType()), (Object)JupyterCellType.Companion.getCODE()) ? (Comparable)Integer.valueOf(Integer.MAX_VALUE) : (Comparable)Integer.valueOf((object2 = JupyterCellLinesExtensionsKt.toJupyterCell(interval, this.$psiFile$inlined)) != null && (object2 = object2.getExecutionCount()) != null ? (Integer)object2 : Integer.MAX_VALUE);
                element = (JupyterStructureViewCellElement)a;
                Comparable comparable2 = comparable;
                bl = false;
                interval = element.getInterval();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)(!Intrinsics.areEqual((Object)JupyterCellLinesExtensionsKt.toJupyterCellType(interval.getType()), (Object)JupyterCellType.Companion.getCODE()) ? (Comparable)Integer.valueOf(Integer.MAX_VALUE) : (Comparable)Integer.valueOf((object = JupyterCellLinesExtensionsKt.toJupyterCell(interval, this.$psiFile$inlined)) != null && (object = object.getExecutionCount()) != null ? (Integer)object : Integer.MAX_VALUE)));
            }
        };
        return new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    JupyterStructureViewCellElement it = (JupyterStructureViewCellElement)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getInterval().getOrdinal());
                    it = (JupyterStructureViewCellElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInterval().getOrdinal()));
                }
                return n;
            }
        };
    }

    private final List<JupyterStructureViewCellElement> applyPriorityFilters(List<JupyterStructureViewCellElement> elements, JupyterStructureSortingOptionsState sortingSettings, JupyterStructureViewModel model) {
        List list;
        if (!sortingSettings.getAreErrorsAndDeclinedOnTop() && !sortingSettings.getAreNonExecutedOnTop()) {
            return elements;
        }
        Iterable $this$partition$iv = elements;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            boolean bl;
            JupyterStructureViewCellElement element = (JupyterStructureViewCellElement)element$iv;
            boolean bl2 = false;
            NotebookCellLines.Interval interval = element.getInterval();
            if (!Intrinsics.areEqual((Object)JupyterCellLinesExtensionsKt.toJupyterCellType(interval.getType()), (Object)JupyterCellType.Companion.getCODE())) {
                bl = false;
            } else {
                ProgressStatus status = model.getCellStatus(interval.getOrdinal());
                bl = sortingSettings.getAreErrorsAndDeclinedOnTop() && status == ProgressStatus.STOPPED_ERROR || sortingSettings.getAreNonExecutedOnTop() && status == ProgressStatus.NOT_STARTED;
            }
            boolean bl3 = bl ? first$iv.add(element$iv) : second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List prioritizedCells = (List)pair.component1();
        List normalCells = (List)pair.component2();
        if (sortingSettings.getAreErrorsAndDeclinedOnTop() && sortingSettings.getAreNonExecutedOnTop()) {
            list = CollectionsKt.sortedWith((Iterable)prioritizedCells, this.createPrioritizedGroupComparator(model));
        } else {
            Iterable $this$sortedBy$iv = prioritizedCells;
            boolean $i$f$sortedBy = false;
            list = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    JupyterStructureViewCellElement it = (JupyterStructureViewCellElement)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getInterval().getOrdinal());
                    it = (JupyterStructureViewCellElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInterval().getOrdinal()));
                }
            });
        }
        List sortedPrioritized = list;
        return CollectionsKt.plus((Collection)sortedPrioritized, (Iterable)normalCells);
    }

    private final Comparator<JupyterStructureViewCellElement> createPrioritizedGroupComparator(JupyterStructureViewModel model) {
        Comparator comparator = new Comparator(model){
            final /* synthetic */ JupyterStructureViewModel $model$inlined;
            {
                this.$model$inlined = jupyterStructureViewModel;
            }

            public final int compare(T a, T b) {
                Comparable comparable;
                Comparable comparable2;
                JupyterStructureViewCellElement element = (JupyterStructureViewCellElement)a;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$1[this.$model$inlined.getCellStatus(element.getInterval().getOrdinal()).ordinal()]) {
                    case 1: {
                        comparable2 = Integer.valueOf(0);
                        break;
                    }
                    case 2: {
                        comparable2 = Integer.valueOf(1);
                        break;
                    }
                    default: {
                        comparable2 = Integer.valueOf(2);
                    }
                }
                element = (JupyterStructureViewCellElement)b;
                Comparable comparable3 = comparable2;
                bl = false;
                switch (WhenMappings.$EnumSwitchMapping$1[this.$model$inlined.getCellStatus(element.getInterval().getOrdinal()).ordinal()]) {
                    case 1: {
                        comparable = Integer.valueOf(0);
                        break;
                    }
                    case 2: {
                        comparable = Integer.valueOf(1);
                        break;
                    }
                    default: {
                        comparable = Integer.valueOf(2);
                    }
                }
                return ComparisonsKt.compareValues((Comparable)comparable3, (Comparable)comparable);
            }
        };
        return new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    JupyterStructureViewCellElement it = (JupyterStructureViewCellElement)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getInterval().getOrdinal());
                    it = (JupyterStructureViewCellElement)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getInterval().getOrdinal()));
                }
                return n;
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[JupyterStructureSortingOptionsState.SortBy.values().length];
            try {
                nArray[JupyterStructureSortingOptionsState.SortBy.CELLS_ORDER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[JupyterStructureSortingOptionsState.SortBy.EXECUTION_ORDER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.NOT_STARTED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

