/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.code.provenance.ui.view.diff;

import com.intellij.code.provenance.DocumentChangesKind;
import com.intellij.code.provenance.core.ProvenanceRegistry;
import com.intellij.code.provenance.core.blame.AuthorshipComputationService;
import com.intellij.code.provenance.core.blame.AuthorshipInfoStorageKt;
import com.intellij.code.provenance.core.events.utils.UtilsKt;
import com.intellij.code.provenance.ui.ProvenanceUiBundle;
import com.intellij.code.provenance.ui.view.diff.AIAuthorshipDiffHighlightingPass;
import com.intellij.code.provenance.ui.view.diff.AIAuthorshipDiffHighlightingPassKt;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J-\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\t\u0012\u00070\u0015\u00a2\u0006\u0002\b\u00160\f2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0006H\u0002J!\u0010\u001a\u001a\u00020\u001b*\u00020\u00062\u0006\u0010\u001c\u001a\u00020\r2\u000b\u0010\u001d\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016H\u0002J\u000e\u0010\u001e\u001a\u0004\u0018\u00010\u0015*\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/code/provenance/ui/view/diff/AIAuthorshipDiffHighlightingPass;", "Lcom/intellij/codeHighlighting/TextEditorHighlightingPass;", "Lcom/intellij/openapi/project/DumbAware;", "myFile", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "authorshipService", "Lcom/intellij/code/provenance/core/blame/AuthorshipComputationService;", "findAuthorship", "", "", "Lcom/intellij/code/provenance/DocumentChangesKind;", "doCollectInformation", "", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "doApplyInformationToEditor", "computeLineMarkerInfo", "", "Lcom/intellij/openapi/util/NlsSafe;", "authorshipInfo", "getCurrentDiffContent", "Lcom/intellij/diff/contents/DocumentContent;", "addAuthorshipHighlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "line", "indicator", "getIndicator", "AIAuthorshipGutterIconRenderer", "intellij.code.provenance.ui"})
@SourceDebugExtension(value={"SMAP\nAIAuthorshipDiffHighlightingPass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AIAuthorshipDiffHighlightingPass.kt\ncom/intellij/code/provenance/ui/view/diff/AIAuthorshipDiffHighlightingPass\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,168:1\n3919#2:169\n4434#2,2:170\n1208#3,2:172\n1236#3,4:174\n3301#3,10:178\n488#4,7:188\n*S KotlinDebug\n*F\n+ 1 AIAuthorshipDiffHighlightingPass.kt\ncom/intellij/code/provenance/ui/view/diff/AIAuthorshipDiffHighlightingPass\n*L\n66#1:169\n66#1:170,2\n67#1:172,2\n67#1:174,4\n69#1:178,10\n74#1:188,7\n*E\n"})
public final class AIAuthorshipDiffHighlightingPass
extends TextEditorHighlightingPass
implements DumbAware {
    @NotNull
    private final Editor editor;
    @NotNull
    private final AuthorshipComputationService authorshipService;

    public AIAuthorshipDiffHighlightingPass(@NotNull PsiFile myFile, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)myFile, (String)"myFile");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(myFile.getProject(), editor.getDocument());
        this.editor = editor;
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        this.authorshipService = AuthorshipComputationService.Companion.getInstance(project);
    }

    private final Map<Integer, DocumentChangesKind> findAuthorship() {
        Map map;
        DocumentContent documentContent = this.getCurrentDiffContent(this.editor);
        if (documentContent == null) {
            return null;
        }
        DocumentContent currentContent = documentContent;
        VirtualFile virtualFile = currentContent.getHighlightFile();
        if (virtualFile != null) {
            VirtualFile file = virtualFile;
            boolean bl = false;
            map = AuthorshipInfoStorageKt.getAuthorshipInfo((UserDataHolder)((UserDataHolder)currentContent));
            if (map == null) {
                AIAuthorshipDiffHighlightingPass $this$findAuthorship_u24lambda_u240_u240 = this;
                boolean bl2 = false;
                Document document = currentContent.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                Document document2 = document;
                AuthorshipComputationService authorshipComputationService = $this$findAuthorship_u24lambda_u240_u240.authorshipService;
                Iterable iterable = (Iterable)RangesKt.until((int)0, (int)document2.getLineCount());
                CharSequence charSequence = document2.getImmutableCharSequence();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getImmutableCharSequence(...)");
                authorshipComputationService.requestAuthorshipComputation(iterable, charSequence, file, (UserDataHolder)currentContent);
                map = null;
            }
        } else {
            map = null;
        }
        return map;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        Intrinsics.checkNotNullParameter((Object)progress, (String)"progress");
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        String string = ProvenanceUiBundle.message("provenance.ui.diff.init.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        UtilsKt.runInSuspendContext((Project)project, (String)string, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ AIAuthorshipDiffHighlightingPass this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ActionsKt.runInEdt$default(null, () -> doCollectInformation.1.invokeSuspend$lambda$0(this.this$0), (int)1, null);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(AIAuthorshipDiffHighlightingPass this$0) {
                AIAuthorshipDiffHighlightingPass.access$findAuthorship(this$0);
                return Unit.INSTANCE;
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    public void doApplyInformationToEditor() {
        String newIndicator;
        String oldIndicator;
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        boolean bl;
        RangeHighlighter it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (!ProvenanceRegistry.INSTANCE.isProvenanceEnabled()) {
            return;
        }
        Map<Integer, DocumentChangesKind> map = this.findAuthorship();
        if (map == null) {
            return;
        }
        Map<Integer, DocumentChangesKind> authorshipInfo = map;
        Map<Integer, String> markers = this.computeLineMarkerInfo(authorshipInfo);
        RangeHighlighter[] rangeHighlighterArray = this.editor.getMarkupModel().getAllHighlighters();
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterArray, (String)"getAllHighlighters(...)");
        Object[] objectArray = rangeHighlighterArray;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl2 = false;
        for (void var11_20 : $this$filterTo$iv$iv) {
            it = (RangeHighlighter)var11_20;
            bl = false;
            if (!(it.getGutterIconRenderer() instanceof AIAuthorshipGutterIconRenderer)) continue;
            destination$iv$iv.add(var11_20);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map map2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object t : $this$associateByTo$iv$iv) {
            it = (RangeHighlighter)t;
            Map map3 = map2;
            bl = false;
            map3.put(this.editor.getDocument().getLineNumber(it.getStartOffset()), t);
        }
        Map highlighters = map2;
        Iterable $this$partition$iv = highlighters.entrySet();
        boolean $i$f$partition = false;
        ArrayList<Object> first$iv = new ArrayList<Object>();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (Object element$iv : $this$partition$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl3 = false;
            int line = ((Number)entry.getKey()).intValue();
            RangeHighlighter rangeHighlighter = (RangeHighlighter)highlighters.get(line);
            oldIndicator = rangeHighlighter != null ? this.getIndicator(rangeHighlighter) : null;
            newIndicator = markers.get(line);
            boolean bl4 = markers.containsKey(line) && Intrinsics.areEqual((Object)oldIndicator, (Object)newIndicator) ? first$iv.add(element$iv) : arrayList.add(element$iv);
        }
        List toRemove = (List)new Pair(first$iv, arrayList).component2();
        Map<Integer, String> $this$filterKeys$iv = markers;
        boolean entry = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry2 : $this$filterKeys$iv.entrySet()) {
            int line = ((Number)entry2.getKey()).intValue();
            bl = false;
            RangeHighlighter rangeHighlighter = (RangeHighlighter)highlighters.get(line);
            oldIndicator = rangeHighlighter != null ? this.getIndicator(rangeHighlighter) : null;
            newIndicator = markers.get(line);
            if (!(!highlighters.containsKey(line) || !Intrinsics.areEqual((Object)oldIndicator, (Object)newIndicator))) continue;
            result$iv.put(entry2.getKey(), entry2.getValue());
        }
        Map toAdd = result$iv;
        Iterator<Object> iterator = toRemove.iterator();
        while (iterator.hasNext()) {
            Object v = ((Map.Entry)iterator.next()).getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"component2(...)");
            RangeHighlighter highlighter = (RangeHighlighter)v;
            this.editor.getMarkupModel().removeHighlighter(highlighter);
        }
        for (Map.Entry entry3 : toAdd.entrySet()) {
            int line = ((Number)entry3.getKey()).intValue();
            String indicator = (String)entry3.getValue();
            this.addAuthorshipHighlighter(this.editor, line, indicator);
        }
    }

    private final Map<Integer, String> computeLineMarkerInfo(Map<Integer, ? extends DocumentChangesKind> authorshipInfo) {
        Map map;
        Map $this$computeLineMarkerInfo_u24lambda_u240 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Document document = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int lineCount = document2.getLineCount();
        for (int line = 0; line < lineCount; ++line) {
            DocumentChangesKind lineChangeKind = authorshipInfo.get(line);
            Object object = lineChangeKind;
            if (object == null || (object = AIAuthorshipDiffHighlightingPassKt.getAuthorshipIndicator(object)) == null) continue;
            Object authorshipIndicator = object;
            $this$computeLineMarkerInfo_u24lambda_u240.put(line, authorshipIndicator);
        }
        return MapsKt.build((Map)map);
    }

    private final DocumentContent getCurrentDiffContent(Editor $this$getCurrentDiffContent) {
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)$this$getCurrentDiffContent.getComponent());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        DataContext context = dataContext;
        Object object = context.getData(DiffDataKeys.DIFF_REQUEST);
        ContentDiffRequest contentDiffRequest = object instanceof ContentDiffRequest ? (ContentDiffRequest)object : null;
        if (contentDiffRequest == null) {
            return null;
        }
        ContentDiffRequest diffRequest = contentDiffRequest;
        List list = diffRequest.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContents(...)");
        Object object2 = CollectionsKt.getOrNull((List)list, (int)0);
        DocumentContent documentContent = object2 instanceof DocumentContent ? (DocumentContent)object2 : null;
        if (documentContent == null) {
            return null;
        }
        DocumentContent leftContent = documentContent;
        List list2 = diffRequest.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getContents(...)");
        Object object3 = CollectionsKt.getOrNull((List)list2, (int)1);
        DocumentContent documentContent2 = object3 instanceof DocumentContent ? (DocumentContent)object3 : null;
        if (documentContent2 == null) {
            return null;
        }
        DocumentContent rightContent = documentContent2;
        object2 = this.editor.getDocument();
        return Intrinsics.areEqual((Object)object2, (Object)leftContent.getDocument()) ? null : (Intrinsics.areEqual((Object)object2, (Object)rightContent.getDocument()) ? rightContent : null);
    }

    private final RangeHighlighter addAuthorshipHighlighter(Editor $this$addAuthorshipHighlighter, int line, String indicator) {
        RangeHighlighter rangeHighlighter;
        int offset = $this$addAuthorshipHighlighter.getDocument().getLineStartOffset(line);
        RangeHighlighter rangeHighlighter2 = $this$addAuthorshipHighlighter.getMarkupModel().addRangeHighlighter(offset, offset, 3000, null, HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighter2, (String)"addRangeHighlighter(...)");
        RangeHighlighter highlighter = rangeHighlighter = rangeHighlighter2;
        boolean bl = false;
        highlighter.setGutterIconRenderer((GutterIconRenderer)new AIAuthorshipGutterIconRenderer(indicator));
        return rangeHighlighter;
    }

    private final String getIndicator(RangeHighlighter $this$getIndicator) {
        GutterIconRenderer gutterIconRenderer = $this$getIndicator.getGutterIconRenderer();
        AIAuthorshipGutterIconRenderer aIAuthorshipGutterIconRenderer = gutterIconRenderer instanceof AIAuthorshipGutterIconRenderer ? (AIAuthorshipGutterIconRenderer)gutterIconRenderer : null;
        return aIAuthorshipGutterIconRenderer != null ? aIAuthorshipGutterIconRenderer.getIndicator() : null;
    }

    public static final /* synthetic */ Map access$findAuthorship(AIAuthorshipDiffHighlightingPass $this) {
        return $this.findAuthorship();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\u0014\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0096\u0002J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0002R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0014"}, d2={"Lcom/intellij/code/provenance/ui/view/diff/AIAuthorshipDiffHighlightingPass$AIAuthorshipGutterIconRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "indicator", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;)V", "getIndicator", "()Ljava/lang/String;", "equals", "", "obj", "", "hashCode", "", "getIcon", "Ljavax/swing/Icon;", "getTooltipText", "createTextIcon", "text", "intellij.code.provenance.ui"})
    private static final class AIAuthorshipGutterIconRenderer
    extends GutterIconRenderer {
        @NotNull
        private final String indicator;

        public AIAuthorshipGutterIconRenderer(@NotNull String indicator) {
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.indicator = indicator;
        }

        @NotNull
        public final String getIndicator() {
            return this.indicator;
        }

        public boolean equals(@Nullable Object obj) {
            return obj instanceof AIAuthorshipGutterIconRenderer && Intrinsics.areEqual((Object)((AIAuthorshipGutterIconRenderer)((Object)obj)).indicator, (Object)this.indicator);
        }

        public int hashCode() {
            return this.indicator.hashCode() * 31;
        }

        @NotNull
        public Icon getIcon() {
            return this.createTextIcon(this.indicator);
        }

        @NotNull
        public String getTooltipText() {
            return this.indicator;
        }

        private final Icon createTextIcon(String text) {
            return new Icon(text){
                final /* synthetic */ String $text;
                {
                    this.$text = $text;
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    block1: {
                        Graphics graphics = g;
                        if (graphics != null) {
                            graphics.setColor((Color)JBColor.GRAY);
                        }
                        Graphics graphics2 = g;
                        if (graphics2 == null) break block1;
                        graphics2.drawString(this.$text, x, y + 10);
                    }
                }

                public int getIconWidth() {
                    return 20;
                }

                public int getIconHeight() {
                    return 16;
                }
            };
        }
    }
}

