/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.vfs;

import com.intellij.kubernetes.view.vfs.KubernetesVirtualFile;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.concurrency.annotations.RequiresWriteLock;
import com.intellij.util.containers.UtilKt;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\n\u0010\t\u001a\u0004\u0018\u00010\u0000H\u0016J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016J\"\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003H\u0007J\u001a\u0010#\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010$\u001a\u00020%H\u0007R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualDirectory;", "Lcom/intellij/testFramework/LightVirtualFileBase;", "name", "", "parent", "<init>", "(Ljava/lang/String;Lcom/intellij/kubernetes/view/vfs/KubernetesVirtualDirectory;)V", "children", "Ljava/util/concurrent/ConcurrentHashMap;", "getParent", "getChildren", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "()[Lcom/intellij/openapi/vfs/VirtualFile;", "equals", "", "other", "", "hashCode", "", "isDirectory", "setWritable", "", "writable", "getOutputStream", "Ljava/io/OutputStream;", "requestor", "newModificationStamp", "", "newTimeStamp", "contentsToByteArray", "", "getInputStream", "Ljava/io/InputStream;", "mkdir", "touch", "fileType", "Lcom/intellij/openapi/fileTypes/LanguageFileType;", "intellij.clouds.kubernetes"})
@ApiStatus.Internal
public final class KubernetesVirtualDirectory
extends LightVirtualFileBase {
    @Nullable
    private final KubernetesVirtualDirectory parent;
    @NotNull
    private final ConcurrentHashMap<String, LightVirtualFileBase> children;

    public KubernetesVirtualDirectory(@NotNull String name, @Nullable KubernetesVirtualDirectory parent) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, UnknownFileType.INSTANCE, LocalTimeCounter.currentTime());
        this.parent = parent;
        this.children = new ConcurrentHashMap(1);
        super.setWritable(false);
    }

    @Nullable
    public KubernetesVirtualDirectory getParent() {
        return this.parent;
    }

    @NotNull
    public VirtualFile[] getChildren() {
        Collection<LightVirtualFileBase> collection = this.children.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Intrinsics.checkNotNullExpressionValue((Object)VirtualFile.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
        return (VirtualFile[])UtilKt.toArray(collection, (Object[])VirtualFile.EMPTY_ARRAY);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof KubernetesVirtualDirectory && Intrinsics.areEqual((Object)this.getName(), (Object)((KubernetesVirtualDirectory)((Object)other)).getName()) && Intrinsics.areEqual((Object)((Object)this.parent), (Object)((Object)((KubernetesVirtualDirectory)((Object)other)).parent));
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getName(), this.parent};
        return Objects.hash(objectArray);
    }

    public boolean isDirectory() {
        return true;
    }

    public void setWritable(boolean writable) {
        if (writable) {
            throw new UnsupportedOperationException();
        }
    }

    @NotNull
    public OutputStream getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public byte[] contentsToByteArray() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public InputStream getInputStream() {
        throw new UnsupportedOperationException();
    }

    @RequiresWriteLock
    @NotNull
    public final KubernetesVirtualDirectory mkdir(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        LightVirtualFileBase lightVirtualFileBase = this.children.computeIfAbsent(name, arg_0 -> KubernetesVirtualDirectory.mkdir$lambda$1(arg_0 -> KubernetesVirtualDirectory.mkdir$lambda$0(this, arg_0), arg_0));
        KubernetesVirtualDirectory kubernetesVirtualDirectory = lightVirtualFileBase instanceof KubernetesVirtualDirectory ? (KubernetesVirtualDirectory)lightVirtualFileBase : null;
        if (kubernetesVirtualDirectory == null) {
            throw new IllegalArgumentException(name + ": File exists");
        }
        return kubernetesVirtualDirectory;
    }

    @RequiresWriteLock
    @NotNull
    public final LightVirtualFileBase touch(@NotNull String name, @NotNull LanguageFileType fileType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)fileType, (String)"fileType");
        LightVirtualFileBase lightVirtualFileBase = this.children.computeIfAbsent(name, arg_0 -> KubernetesVirtualDirectory.touch$lambda$1(arg_0 -> KubernetesVirtualDirectory.touch$lambda$0(this, fileType, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)lightVirtualFileBase, (String)"computeIfAbsent(...)");
        return lightVirtualFileBase;
    }

    public static /* synthetic */ LightVirtualFileBase touch$default(KubernetesVirtualDirectory kubernetesVirtualDirectory, String string, LanguageFileType languageFileType, int n, Object object) {
        if ((n & 2) != 0) {
            YAMLFileType yAMLFileType = YAMLFileType.YML;
            Intrinsics.checkNotNullExpressionValue((Object)yAMLFileType, (String)"YML");
            languageFileType = (LanguageFileType)yAMLFileType;
        }
        return kubernetesVirtualDirectory.touch(string, languageFileType);
    }

    private static final LightVirtualFileBase mkdir$lambda$0(KubernetesVirtualDirectory this$0, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new KubernetesVirtualDirectory(it, this$0);
    }

    private static final LightVirtualFileBase mkdir$lambda$1(Function1 $tmp0, Object p0) {
        return (LightVirtualFileBase)$tmp0.invoke(p0);
    }

    private static final LightVirtualFileBase touch$lambda$0(KubernetesVirtualDirectory this$0, LanguageFileType $fileType, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (LightVirtualFileBase)new KubernetesVirtualFile(this$0, it, (FileType)$fileType);
    }

    private static final LightVirtualFileBase touch$lambda$1(Function1 $tmp0, Object p0) {
        return (LightVirtualFileBase)$tmp0.invoke(p0);
    }
}

