/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.intern.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.intern.datetime.Date;
import org.jetbrains.letsPlot.commons.intern.datetime.Duration;
import org.jetbrains.letsPlot.commons.intern.datetime.Instant;
import org.jetbrains.letsPlot.commons.intern.datetime.Month;
import org.jetbrains.letsPlot.commons.intern.datetime.Time;
import org.jetbrains.letsPlot.commons.intern.datetime.TimeZone;
import org.jetbrains.letsPlot.commons.intern.datetime.WeekDay;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 72\b\u0012\u0004\u0012\u00020\u00000\u0001:\u00017B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010&\u001a\u00020\u00002\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*J\u0011\u0010+\u001a\u00020\r2\u0006\u0010,\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010-\u001a\u00020.2\b\u0010,\u001a\u0004\u0018\u00010/H\u0096\u0002J\b\u00100\u001a\u00020\rH\u0016J\u000e\u00101\u001a\u0002022\u0006\u0010)\u001a\u00020*J\u000e\u00103\u001a\u0002042\u0006\u0010)\u001a\u00020*J\b\u00105\u001a\u000206H\u0016R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0011\u0010\u0016\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000f\u00a8\u00068"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "", "date", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "time", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Time;", "(Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;Lorg/jetbrains/letsPlot/commons/intern/datetime/Time;)V", "kotlinxLocalDateTime", "Lkotlinx/datetime/LocalDateTime;", "(Lkotlinx/datetime/LocalDateTime;)V", "getDate", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/Date;", "day", "", "getDay", "()I", "hours", "getHours", "getKotlinxLocalDateTime$commons", "()Lkotlinx/datetime/LocalDateTime;", "milliseconds", "getMilliseconds", "minutes", "getMinutes", "month", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Month;", "getMonth", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/Month;", "seconds", "getSeconds", "getTime", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/Time;", "weekDay", "Lorg/jetbrains/letsPlot/commons/intern/datetime/WeekDay;", "getWeekDay", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/WeekDay;", "year", "getYear", "add", "duration", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Duration;", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "compareTo", "other", "equals", "", "", "hashCode", "toEpochMilliseconds", "", "toInstant", "Lorg/jetbrains/letsPlot/commons/intern/datetime/Instant;", "toString", "", "Companion", "commons"})
public final class DateTime
implements Comparable<DateTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LocalDateTime kotlinxLocalDateTime;
    @NotNull
    private static final DateTime EPOCH = new DateTime(Date.Companion.getEPOCH(), new Time(0, 0, 0, 0, 8, null));

    public DateTime(@NotNull Date date, @NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        this.kotlinxLocalDateTime = new LocalDateTime(date.getKotlinxLocalDate$commons(), time.getKotlinxLocalTime$commons());
    }

    public /* synthetic */ DateTime(Date date, Time time, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            time = new Time(0, 0, 0, 0, 8, null);
        }
        this(date, time);
    }

    public DateTime(@NotNull LocalDateTime kotlinxLocalDateTime) {
        Intrinsics.checkNotNullParameter((Object)kotlinxLocalDateTime, (String)"kotlinxLocalDateTime");
        this.kotlinxLocalDateTime = kotlinxLocalDateTime;
    }

    @NotNull
    public final LocalDateTime getKotlinxLocalDateTime$commons() {
        return this.kotlinxLocalDateTime;
    }

    public final int getYear() {
        return this.kotlinxLocalDateTime.getYear();
    }

    @NotNull
    public final Month getMonth() {
        return Month.Companion.of(this.kotlinxLocalDateTime.getMonthNumber());
    }

    public final int getDay() {
        return this.kotlinxLocalDateTime.getDayOfMonth();
    }

    public final int getHours() {
        return this.kotlinxLocalDateTime.getHour();
    }

    public final int getMinutes() {
        return this.kotlinxLocalDateTime.getMinute();
    }

    public final int getSeconds() {
        return this.kotlinxLocalDateTime.getSecond();
    }

    public final int getMilliseconds() {
        return this.kotlinxLocalDateTime.getNanosecond() / 1000000;
    }

    @NotNull
    public final Date getDate() {
        return new Date(this.kotlinxLocalDateTime.getDate());
    }

    @NotNull
    public final Time getTime() {
        return new Time(this.kotlinxLocalDateTime.getTime());
    }

    @NotNull
    public final WeekDay getWeekDay() {
        return (WeekDay)((Object)WeekDay.getEntries().get(this.kotlinxLocalDateTime.getDayOfWeek().ordinal()));
    }

    @NotNull
    public final Instant toInstant(@NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        return new Instant(TimeZoneKt.toInstant((LocalDateTime)this.kotlinxLocalDateTime, (kotlinx.datetime.TimeZone)tz.getKotlinxTz$commons()));
    }

    @NotNull
    public final DateTime add(@NotNull Duration duration, @NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)duration, (String)"duration");
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        Instant instant = this.toInstant(tz);
        Instant instant2 = instant.add(duration);
        return instant2.toDateTime(tz);
    }

    @Override
    public int compareTo(@NotNull DateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.kotlinxLocalDateTime.compareTo(other.kotlinxLocalDateTime);
    }

    public int hashCode() {
        return this.kotlinxLocalDateTime.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.kotlinxLocalDateTime, (Object)((DateTime)other).kotlinxLocalDateTime);
    }

    @NotNull
    public String toString() {
        return this.kotlinxLocalDateTime.toString();
    }

    public final long toEpochMilliseconds(@NotNull TimeZone tz) {
        Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
        return this.toInstant(tz).toEpochMilliseconds();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime$Companion;", "", "()V", "EPOCH", "Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "getEPOCH", "()Lorg/jetbrains/letsPlot/commons/intern/datetime/DateTime;", "ofEpochMilliseconds", "epochMs", "", "tz", "Lorg/jetbrains/letsPlot/commons/intern/datetime/TimeZone;", "ofYearStart", "year", "", "parse", "s", "", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTime getEPOCH() {
            return EPOCH;
        }

        @NotNull
        public final DateTime parse(@NotNull String s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            return new DateTime(LocalDateTime.Companion.parse$default((LocalDateTime.Companion)LocalDateTime.Companion, (CharSequence)s, null, (int)2, null));
        }

        @NotNull
        public final DateTime ofYearStart(int year) {
            Date date = new Date(1, Month.JANUARY, year);
            return new DateTime(date, null, 2, null);
        }

        @NotNull
        public final DateTime ofEpochMilliseconds(@NotNull Number epochMs, @NotNull TimeZone tz) {
            Intrinsics.checkNotNullParameter((Object)epochMs, (String)"epochMs");
            Intrinsics.checkNotNullParameter((Object)tz, (String)"tz");
            Instant instant = new Instant(epochMs.longValue());
            return instant.toDateTime(tz);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

