/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.model.DiagnosticReporter;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/TypeMismatchDiagnostic;", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallDiagnostic;", "callArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "expectedType", "Lorg/jetbrains/kotlin/types/KotlinType;", "actualType", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/types/KotlinType;)V", "getCallArgument", "()Lorg/jetbrains/kotlin/resolve/calls/model/KotlinCallArgument;", "getExpectedType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getActualType", "report", "", "reporter", "Lorg/jetbrains/kotlin/resolve/calls/model/DiagnosticReporter;", "frontend"})
public final class TypeMismatchDiagnostic
extends KotlinCallDiagnostic {
    @NotNull
    private final KotlinCallArgument callArgument;
    @NotNull
    private final KotlinType expectedType;
    @NotNull
    private final KotlinType actualType;

    public TypeMismatchDiagnostic(@NotNull KotlinCallArgument callArgument, @NotNull KotlinType expectedType, @NotNull KotlinType actualType) {
        Intrinsics.checkNotNullParameter((Object)callArgument, (String)"callArgument");
        Intrinsics.checkNotNullParameter((Object)expectedType, (String)"expectedType");
        Intrinsics.checkNotNullParameter((Object)actualType, (String)"actualType");
        super(CandidateApplicability.INAPPLICABLE);
        this.callArgument = callArgument;
        this.expectedType = expectedType;
        this.actualType = actualType;
    }

    @NotNull
    public final KotlinCallArgument getCallArgument() {
        return this.callArgument;
    }

    @NotNull
    public final KotlinType getExpectedType() {
        return this.expectedType;
    }

    @NotNull
    public final KotlinType getActualType() {
        return this.actualType;
    }

    @Override
    public void report(@NotNull DiagnosticReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        reporter.onCallArgument(this.callArgument, this);
    }
}

