/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.Direction;
import com.intellij.spring.contexts.model.Model;
import com.intellij.spring.contexts.model.ModelDependencies;
import com.intellij.spring.contexts.model.QueueItem;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0006\u001a*\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u001a*\u0010\b\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u001a2\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a2\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00032\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\"\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\u0011"}, d2={"traverseModelPreventingRecursion", "", "parentModel", "Lcom/intellij/spring/CommonSpringModel;", "visitParentModel", "apply", "Ljava/util/function/Function;", "Lcom/intellij/spring/contexts/model/Direction;", "traverseModel", "visitRelated", "visited", "", "visitModel", "model", "traverse", "traverseModelBreadthFirst", "root", "intellij.spring"})
@JvmName(name="ModelTraverse")
public final class ModelTraverse {
    public static final boolean traverseModelPreventingRecursion(@NotNull CommonSpringModel parentModel, boolean visitParentModel, @NotNull Function<CommonSpringModel, Direction> apply) {
        Boolean aBoolean;
        Intrinsics.checkNotNullParameter((Object)parentModel, (String)"parentModel");
        Intrinsics.checkNotNullParameter(apply, (String)"apply");
        Boolean bl = aBoolean = (Boolean)RecursionManager.doPreventingRecursion((Object)parentModel, (boolean)false, () -> ModelTraverse.traverseModelPreventingRecursion$lambda$0(parentModel, visitParentModel, apply));
        return bl != null ? bl : true;
    }

    public static final boolean traverseModel(@NotNull CommonSpringModel parentModel, boolean visitParentModel, @NotNull Function<CommonSpringModel, Direction> apply) {
        Intrinsics.checkNotNullParameter((Object)parentModel, (String)"parentModel");
        Intrinsics.checkNotNullParameter(apply, (String)"apply");
        HashSet visited = new HashSet();
        if (visitParentModel) {
            Direction direction = ModelTraverse.visitModel(parentModel, visited, apply);
            if (direction == Direction.STOP) {
                return false;
            }
            if (direction == Direction.PROCEED) {
                return true;
            }
        }
        return ModelTraverse.visitRelated(parentModel, visited, apply);
    }

    private static final boolean visitRelated(CommonSpringModel parentModel, Set<CommonSpringModel> visited, Function<CommonSpringModel, Direction> apply) {
        Set<CommonSpringModel> relatedModels = parentModel.getRelatedModels();
        for (CommonSpringModel relatedModel : relatedModels) {
            Intrinsics.checkNotNull((Object)relatedModel);
            Direction direction = ModelTraverse.visitModel(relatedModel, visited, apply);
            if (direction == Direction.PROCEED) continue;
            if (direction == Direction.STOP) {
                return false;
            }
            if (direction != Direction.TRAVERSE || ModelTraverse.visitRelated(relatedModel, visited, apply)) continue;
            return false;
        }
        return true;
    }

    private static final Direction visitModel(CommonSpringModel model, Set<CommonSpringModel> visited, Function<CommonSpringModel, Direction> traverse) {
        if (visited.contains(model)) {
            return Direction.PROCEED;
        }
        ProgressManager.checkCanceled();
        visited.add(model);
        Direction direction = traverse.apply(model);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)direction), (String)"apply(...)");
        return direction;
    }

    public static final boolean traverseModelBreadthFirst(@NotNull CommonSpringModel root, @NotNull Function<CommonSpringModel, Direction> traverse) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter(traverse, (String)"traverse");
        HashSet<CommonSpringModel> visited = new HashSet<CommonSpringModel>();
        ArrayDeque queue = new ArrayDeque();
        queue.add((Object)new Model(root));
        block5: while (!queue.isEmpty()) {
            QueueItem item = (QueueItem)queue.removeFirst();
            if (item instanceof ModelDependencies) {
                for (CommonSpringModel m : ((ModelDependencies)item).getModel().getRelatedModels()) {
                    if (visited.contains(m)) continue;
                    Intrinsics.checkNotNull((Object)m);
                    queue.addFirst((Object)new Model(m));
                }
                continue;
            }
            Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type com.intellij.spring.contexts.model.Model");
            CommonSpringModel currentModel = ((Model)item).getModel();
            if (visited.contains(currentModel)) continue;
            ProgressManager.checkCanceled();
            visited.add(currentModel);
            switch (WhenMappings.$EnumSwitchMapping$0[traverse.apply(currentModel).ordinal()]) {
                case 1: {
                    return false;
                }
                case 2: {
                    continue block5;
                }
                case 3: {
                    queue.add((Object)new ModelDependencies(currentModel));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return true;
    }

    private static final Boolean traverseModelPreventingRecursion$lambda$0(CommonSpringModel $parentModel, boolean $visitParentModel, Function $apply) {
        return ModelTraverse.traverseModel($parentModel, $visitParentModel, $apply);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.STOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.PROCEED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.TRAVERSE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

