/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.codeInsight;

import com.intellij.codeInsight.highlighting.HighlightedReference;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.modulith.SpringModulithUtilsKt;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.ModulithDependency;
import com.intellij.spring.modulith.model.SpringModulithModelService;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\n\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/modulith/codeInsight/SpringModulithDependencyReference;", "Lcom/intellij/psi/PsiReferenceBase;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/codeInsight/highlighting/HighlightedReference;", "psiElement", "range", "Lcom/intellij/openapi/util/TextRange;", "<init>", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/openapi/util/TextRange;)V", "isHighlightedWhenSoft", "", "resolve", "intellij.spring.modulith"})
@VisibleForTesting
public final class SpringModulithDependencyReference
extends PsiReferenceBase<PsiElement>
implements HighlightedReference {
    @NotNull
    private final PsiElement psiElement;

    public SpringModulithDependencyReference(@NotNull PsiElement psiElement, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        super(psiElement, range, true);
        this.psiElement = psiElement;
    }

    public boolean isHighlightedWhenSoft() {
        return true;
    }

    @Nullable
    public PsiElement resolve() {
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)this.psiElement);
        if (module == null) {
            return null;
        }
        Module module2 = module;
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        List<ApplicationModule> model = SpringModulithModelService.Companion.getInstance$intellij_spring_modulith(project).getModel$intellij_spring_modulith(module2);
        String string = this.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getValue(...)");
        ModulithDependency modulithDependency = ModulithDependency.Companion.fromString(string);
        if (modulithDependency == null) {
            return null;
        }
        ModulithDependency dependency = modulithDependency;
        return (PsiElement)SpringModulithUtilsKt.findDependencyPackage(dependency, model, module2);
    }
}

