/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.inlays;

import com.intellij.codeInsight.daemon.impl.InlayHintsPassFactoryInternal;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.InlayHintsUtils;
import com.intellij.codeInsight.hints.InlayPresentationFactory;
import com.intellij.codeInsight.hints.SettingsKey;
import com.intellij.codeInsight.hints.presentation.ChangeOnHoverPresentation;
import com.intellij.codeInsight.hints.presentation.InlayButtonPresentationFactory;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.MouseButton;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.codeInsight.hints.presentation.StaticDelegatePresentation;
import com.intellij.ide.HelpTooltip;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.config.KubernetesIdeSettings;
import com.intellij.kubernetes.config.KubernetesOptions;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.inlays.KubernetesInlayUiUtilsKt;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.LightweightHint;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0080\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a2\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006H\u0002\u001a*\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002\u001a\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001aL\u0010\u0016\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u001c\b\u0002\u0010\u001b\u001a\u0016\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0006H\u0000\u001a\"\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0001H\u0002\u001a)\u0010\u001e\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 \"\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010!\u001a>\u0010\"\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\b\b\u0001\u0010%\u001a\u00020\u00152\u0006\u0010&\u001a\u00020\u00072\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(H\u0000\u001a(\u0010*\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0000\u001aQ\u0010/\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020.2\b\u00103\u001a\u0004\u0018\u00010.2\u0006\u00104\u001a\u00020\u00012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0006H\u0000\u00a2\u0006\u0002\u00105\u00a8\u00066"}, d2={"addRightClickSupport", "Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "factory", "Lcom/intellij/codeInsight/hints/presentation/PresentationFactory;", "content", "onRightClick", "Lkotlin/Function2;", "Ljava/awt/event/MouseEvent;", "Ljava/awt/Point;", "", "createAndShowPopup", "editor", "Lcom/intellij/openapi/editor/Editor;", "project", "Lcom/intellij/openapi/project/Project;", "actionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "e", "iconsOnlyToggleAction", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "restartReasonId", "", "buildHoverInlayButton", "icon", "Ljavax/swing/Icon;", "text", "tooltip", "onClick", "withMovingTooltip", "base", "seqWithSpaces", "items", "", "(Lcom/intellij/openapi/editor/Editor;[Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;)Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;", "showStandardInlayPopup", "providerKey", "Lcom/intellij/codeInsight/hints/SettingsKey;", "providerDisplayName", "event", "substituteActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "showBalloonPopup", "label", "Ljavax/swing/JComponent;", "fadeoutMs", "", "addInlineInlayWithMappingPlacement", "sink", "Lcom/intellij/codeInsight/hints/InlayHintsSink;", "valueEndOffset", "mappingEndOffset", "presentation", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/codeInsight/hints/InlayHintsSink;ILjava/lang/Integer;Lcom/intellij/codeInsight/hints/presentation/InlayPresentation;Lkotlin/jvm/functions/Function2;)V", "intellij.clouds.kubernetes.backend"})
@SourceDebugExtension(value={"SMAP\nKubernetesInlayUiUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesInlayUiUtils.kt\ncom/intellij/kubernetes/inlays/KubernetesInlayUiUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,269:1\n20271#2,7:270\n*S KotlinDebug\n*F\n+ 1 KubernetesInlayUiUtils.kt\ncom/intellij/kubernetes/inlays/KubernetesInlayUiUtilsKt\n*L\n177#1:270,7\n*E\n"})
public final class KubernetesInlayUiUtilsKt {
    private static final InlayPresentation addRightClickSupport(PresentationFactory factory, InlayPresentation content, Function2<? super MouseEvent, ? super Point, Unit> onRightClick) {
        StaticDelegatePresentation delegate2 = new StaticDelegatePresentation(content, onRightClick){
            final /* synthetic */ Function2<MouseEvent, Point, Unit> $onRightClick;
            {
                this.$onRightClick = $onRightClick;
                super($content);
            }

            public void mousePressed(MouseEvent event, Point translated) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
                if (event.getButton() == 3) {
                    this.$onRightClick.invoke((Object)event, (Object)translated);
                } else {
                    super.mousePressed(event, translated);
                }
            }
        };
        return factory.referenceOnHover((InlayPresentation)delegate2, (arg_0, arg_1) -> KubernetesInlayUiUtilsKt.addRightClickSupport$lambda$0(delegate2, arg_0, arg_1));
    }

    private static final void createAndShowPopup(Editor editor, Project project, DefaultActionGroup actionGroup, MouseEvent e) {
        DataContext dataContext = SimpleDataContext.builder().add(CommonDataKeys.EDITOR, (Object)editor).add(CommonDataKeys.PROJECT, (Object)project).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"build(...)");
        DataContext dataContext2 = dataContext;
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext2, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        popup.showInScreenCoordinates((Component)editor.getContentComponent(), e.getLocationOnScreen());
    }

    private static final ToggleAction iconsOnlyToggleAction(Editor editor, String restartReasonId) {
        String string = KubernetesBundle.message((String)"KubernetesInlays.IconsOnlyAction.text", (Object[])new Object[0]);
        return (ToggleAction)new DumbAware(editor, restartReasonId, string){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ String $restartReasonId;
            {
                this.$editor = $editor;
                this.$restartReasonId = $restartReasonId;
                super($super_call_param$1);
            }

            public boolean isSelected(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return ((KubernetesOptions)KubernetesIdeSettings.Companion.getInstance().getState()).getInlaysIconsOnly();
            }

            public void setSelected(AnActionEvent e, boolean state) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    ((KubernetesOptions)KubernetesIdeSettings.Companion.getInstance().getState()).setInlaysIconsOnly(state);
                    KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(e.getProject(), (Object)"toggle-inlays-icons-only");
                    Project project = this.$editor.getProject();
                    if (project == null) break block0;
                    Project project2 = project;
                    String string = this.$restartReasonId;
                    Project it = project2;
                    boolean bl = false;
                    InlayHintsPassFactoryInternal.Companion.restartDaemonUpdatingHints(it, string);
                }
            }

            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = super.getActionUpdateThread();
                Intrinsics.checkNotNullExpressionValue((Object)actionUpdateThread, (String)"getActionUpdateThread(...)");
                return actionUpdateThread;
            }
        };
    }

    @NotNull
    public static final InlayPresentation buildHoverInlayButton(@NotNull Editor editor, @NotNull Icon icon, @Nullable String text, @Nullable String tooltip, @Nullable Function2<? super MouseEvent, ? super Point, Unit> onClick) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        PresentationFactory factory = new PresentationFactory(editor);
        InlayButtonPresentationFactory buttonFactory = new InlayButtonPresentationFactory(editor, factory, null, null, null, 28, null);
        boolean iconsOnly = ((KubernetesOptions)KubernetesIdeSettings.Companion.getInstance().getState()).getInlaysIconsOnly();
        InlayButtonPresentationFactory.InlayButtonPresentationBuilder builderBase = iconsOnly || (charSequence = (CharSequence)text) == null || StringsKt.isBlank((CharSequence)charSequence) ? buttonFactory.icon(icon) : buttonFactory.iconAndText(icon, text);
        InlayPresentation base = builderBase.build(0);
        InlayPresentation hovered = builderBase.buildHovered();
        InlayPresentation clickable = onClick != null ? factory.onClick(hovered, MouseButton.Left, (arg_0, arg_1) -> KubernetesInlayUiUtilsKt.buildHoverInlayButton$lambda$0(onClick, arg_0, arg_1)) : hovered;
        ChangeOnHoverPresentation changed = new ChangeOnHoverPresentation(base, () -> KubernetesInlayUiUtilsKt.buildHoverInlayButton$lambda$1(clickable), null, 4, null);
        CharSequence charSequence2 = tooltip;
        return !(charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) ? KubernetesInlayUiUtilsKt.withMovingTooltip(editor, tooltip, (InlayPresentation)changed) : (InlayPresentation)changed;
    }

    public static /* synthetic */ InlayPresentation buildHoverInlayButton$default(Editor editor, Icon icon, String string, String string2, Function2 function2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            function2 = null;
        }
        return KubernetesInlayUiUtilsKt.buildHoverInlayButton(editor, icon, string, string2, (Function2<? super MouseEvent, ? super Point, Unit>)function2);
    }

    private static final InlayPresentation withMovingTooltip(Editor editor, @NlsSafe String tooltip, InlayPresentation base) {
        if (((CharSequence)tooltip).length() == 0) {
            return base;
        }
        PresentationFactory factory = new PresentationFactory(editor);
        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"com/intellij/kubernetes/inlays/KubernetesInlayUiUtilsKt$withMovingTooltip$InlayHelpTooltip", "Lcom/intellij/ide/HelpTooltip;", "<init>", "()V", "showTooltip", "", "event", "Ljava/awt/event/MouseEvent;", "entered", "", "hideTooltip", "cancelPendingShow", "intellij.clouds.kubernetes.backend"})
        public final class InlayHelpTooltip
        extends HelpTooltip {
            public InlayHelpTooltip() {
                this.createMouseListeners();
            }

            public final void showTooltip(MouseEvent event, boolean entered) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (entered) {
                    this.myMouseListener.mouseEntered(event);
                } else {
                    this.myMouseListener.mouseMoved(event);
                }
            }

            public final void hideTooltip() {
                this.hidePopup(true);
            }

            public final void cancelPendingShow(MouseEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.myMouseListener.mouseExited(event);
            }
        }
        HelpTooltip helpTooltip = new InlayHelpTooltip().setTitle(tooltip);
        Intrinsics.checkNotNull((Object)helpTooltip, (String)"null cannot be cast to non-null type com.intellij.kubernetes.inlays.KubernetesInlayUiUtilsKt.withMovingTooltip.InlayHelpTooltip");
        InlayHelpTooltip helpTooltip2 = (InlayHelpTooltip)helpTooltip;
        Ref.BooleanRef suppressUntilHoverExit = new Ref.BooleanRef();
        Ref.BooleanRef inside = new Ref.BooleanRef();
        Ref.ObjectRef lastEvent = new Ref.ObjectRef();
        StaticDelegatePresentation clickableWrapper2 = new StaticDelegatePresentation(base, (Ref.ObjectRef<MouseEvent>)lastEvent, helpTooltip2, suppressUntilHoverExit){
            final /* synthetic */ Ref.ObjectRef<MouseEvent> $lastEvent;
            final /* synthetic */ InlayHelpTooltip $helpTooltip;
            final /* synthetic */ Ref.BooleanRef $suppressUntilHoverExit;
            {
                this.$lastEvent = $lastEvent;
                this.$helpTooltip = $helpTooltip;
                this.$suppressUntilHoverExit = $suppressUntilHoverExit;
                super($base);
            }

            public void mouseClicked(MouseEvent event, Point translated) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
                MouseEvent mouseEvent = (MouseEvent)this.$lastEvent.element;
                if (mouseEvent != null) {
                    MouseEvent mouseEvent2 = mouseEvent;
                    InlayHelpTooltip inlayHelpTooltip = this.$helpTooltip;
                    MouseEvent it = mouseEvent2;
                    boolean bl = false;
                    inlayHelpTooltip.cancelPendingShow(it);
                }
                this.$helpTooltip.hideTooltip();
                this.$suppressUntilHoverExit.element = true;
                super.mouseClicked(event, translated);
            }
        };
        return factory.onHover((InlayPresentation)clickableWrapper2, new InlayPresentationFactory.HoverListener((Ref.ObjectRef<MouseEvent>)lastEvent, suppressUntilHoverExit, helpTooltip2, inside){
            final /* synthetic */ Ref.ObjectRef<MouseEvent> $lastEvent;
            final /* synthetic */ Ref.BooleanRef $suppressUntilHoverExit;
            final /* synthetic */ InlayHelpTooltip $helpTooltip;
            final /* synthetic */ Ref.BooleanRef $inside;
            {
                this.$lastEvent = $lastEvent;
                this.$suppressUntilHoverExit = $suppressUntilHoverExit;
                this.$helpTooltip = $helpTooltip;
                this.$inside = $inside;
            }

            public void onHover(MouseEvent event, Point translated) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
                this.$lastEvent.element = event;
                if (this.$suppressUntilHoverExit.element) {
                    return;
                }
                this.$helpTooltip.showTooltip(event, !this.$inside.element);
                this.$inside.element = true;
            }

            public void onHoverFinished() {
                MouseEvent mouseEvent = (MouseEvent)this.$lastEvent.element;
                if (mouseEvent != null) {
                    MouseEvent mouseEvent2 = mouseEvent;
                    InlayHelpTooltip inlayHelpTooltip = this.$helpTooltip;
                    MouseEvent it = mouseEvent2;
                    boolean bl = false;
                    inlayHelpTooltip.cancelPendingShow(it);
                }
                this.$helpTooltip.hideTooltip();
                this.$suppressUntilHoverExit.element = false;
                this.$inside.element = false;
                this.$lastEvent.element = null;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final InlayPresentation seqWithSpaces(@NotNull Editor editor, InlayPresentation ... items) {
        InlayPresentation inlayPresentation;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        PresentationFactory factory = new PresentationFactory(editor);
        if (items.length == 0) {
            inlayPresentation = factory.smallText("");
        } else {
            Object[] $this$reduce$iv = items;
            boolean $i$f$reduce = false;
            if ($this$reduce$iv.length == 0) {
                throw new UnsupportedOperationException("Empty array can't be reduced.");
            }
            InlayPresentation accumulator$iv = $this$reduce$iv[0];
            int index$iv = 1;
            int n = ArraysKt.getLastIndex((Object[])$this$reduce$iv);
            if (index$iv <= n) {
                while (true) {
                    void item;
                    Object object = $this$reduce$iv[index$iv];
                    InlayPresentation acc = accumulator$iv;
                    boolean bl = false;
                    InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{acc, factory.smallText(" "), item};
                    accumulator$iv = factory.seq(inlayPresentationArray);
                    if (index$iv == n) break;
                    ++index$iv;
                }
            }
            inlayPresentation = accumulator$iv;
        }
        return inlayPresentation;
    }

    public static final void showStandardInlayPopup(@NotNull Editor editor, @NotNull SettingsKey<?> providerKey, @Nls @NotNull String providerDisplayName, @NotNull MouseEvent event, @NotNull List<? extends AnAction> substituteActions) {
        DefaultActionGroup defaultActionGroup;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(providerKey, (String)"providerKey");
        Intrinsics.checkNotNullParameter((Object)providerDisplayName, (String)"providerDisplayName");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(substituteActions, (String)"substituteActions");
        List popupActions = InlayHintsUtils.INSTANCE.getDefaultInlayHintsProviderPopupActions(providerKey, () -> KubernetesInlayUiUtilsKt.showStandardInlayPopup$lambda$0(providerDisplayName));
        ToggleAction toggleIconsOnly = KubernetesInlayUiUtilsKt.iconsOnlyToggleAction(editor, providerDisplayName + ".iconsOnlySettingToggled");
        DefaultActionGroup $this$showStandardInlayPopup_u24lambda_u241 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        if (!((Collection)substituteActions).isEmpty()) {
            $this$showStandardInlayPopup_u24lambda_u241.addAll((Collection)substituteActions);
        } else {
            $this$showStandardInlayPopup_u24lambda_u241.addAll((Collection)popupActions);
        }
        $this$showStandardInlayPopup_u24lambda_u241.addSeparator();
        $this$showStandardInlayPopup_u24lambda_u241.add((AnAction)toggleIconsOnly);
        DefaultActionGroup group2 = defaultActionGroup;
        KubernetesInlayUiUtilsKt.createAndShowPopup(editor, editor.getProject(), group2, event);
    }

    public static /* synthetic */ void showStandardInlayPopup$default(Editor editor, SettingsKey settingsKey, String string, MouseEvent mouseEvent, List list, int n, Object object) {
        if ((n & 0x10) != 0) {
            list = CollectionsKt.emptyList();
        }
        KubernetesInlayUiUtilsKt.showStandardInlayPopup(editor, settingsKey, string, mouseEvent, list);
    }

    public static final void showBalloonPopup(@NotNull Editor editor, @NotNull MouseEvent e, @NotNull JComponent label, int fadeoutMs) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean bl = false;
        label.setBorder((Border)JBUI.Borders.empty((int)6, (int)6, (int)5, (int)6));
        LightweightHint hint = new LightweightHint(label);
        boolean bl2 = false;
        JComponent jComponent = editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent component = jComponent;
        Point pointOnScreen = component.getLocationOnScreen();
        Point pointOnEditor = new Point(e.getXOnScreen() - pointOnScreen.x, e.getYOnScreen() - pointOnScreen.y);
        Point p = HintManagerImpl.getHintPosition((LightweightHint)hint, (Editor)editor, (VisualPosition)editor.xyToVisualPosition(pointOnEditor), (short)1);
        p.x = e.getXOnScreen() - component.getTopLevelAncestor().getLocationOnScreen().x;
        Point point = p;
        HintManagerImpl.getInstanceImpl().showEditorHint(hint, editor, point, 42, fadeoutMs, false, HintManagerImpl.createHintHint((Editor)editor, (Point)point, (LightweightHint)hint, (short)1).setContentActive(false).setShowImmediately(true));
    }

    public static final void addInlineInlayWithMappingPlacement(@NotNull Editor editor, @NotNull InlayHintsSink sink, int valueEndOffset, @Nullable Integer mappingEndOffset, @NotNull InlayPresentation presentation, @NotNull Function2<? super MouseEvent, ? super Point, Unit> onRightClick) {
        InlayPresentation inlayPresentation;
        boolean collapsed;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter(onRightClick, (String)"onRightClick");
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        Document document2 = document;
        int valueLine = document2.getLineNumber(valueEndOffset);
        Integer n = mappingEndOffset;
        int mappingEnd = n != null ? n : valueEndOffset;
        int mappingEndLine = document2.getLineNumber(mappingEnd - 1);
        boolean inlineOnSameLine = mappingEndLine == valueLine;
        int insertionOffset = inlineOnSameLine ? mappingEnd : valueEndOffset;
        boolean placeAtTheEndOfLine = !inlineOnSameLine;
        boolean bl = collapsed = editor.getFoldingModel().isOffsetCollapsed(insertionOffset) || insertionOffset > 0 && editor.getFoldingModel().isOffsetCollapsed(insertionOffset - 1);
        if (collapsed) {
            return;
        }
        if (inlineOnSameLine) {
            PresentationFactory presentationFactory = new PresentationFactory(editor);
            InlayPresentation[] inlayPresentationArray = new InlayPresentation[]{presentationFactory.textSpacePlaceholder(1, true), presentation};
            inlayPresentation = presentationFactory.seq(inlayPresentationArray);
        } else {
            inlayPresentation = presentation;
        }
        InlayPresentation spacedPresentation = inlayPresentation;
        InlayPresentation rightClickPresentation = KubernetesInlayUiUtilsKt.addRightClickSupport(new PresentationFactory(editor), spacedPresentation, onRightClick);
        sink.addInlineElement(insertionOffset, true, rightClickPresentation, placeAtTheEndOfLine);
    }

    private static final void addRightClickSupport$lambda$0(addRightClickSupport.delegate.1 $delegate, MouseEvent e, Point translated) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)translated, (String)"translated");
        if (e.getButton() != 1) {
            $delegate.mousePressed(e, translated);
        }
    }

    private static final Unit buildHoverInlayButton$lambda$0(Function2 $onClick, MouseEvent e, Point p) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        $onClick.invoke((Object)e, (Object)p);
        return Unit.INSTANCE;
    }

    private static final InlayPresentation buildHoverInlayButton$lambda$1(InlayPresentation $clickable) {
        return $clickable;
    }

    private static final String showStandardInlayPopup$lambda$0(String $providerDisplayName) {
        return $providerDisplayName;
    }
}

