/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.SshConnectionConfigPatch;
import com.intellij.ssh.OpenSshLikeHostKeyVerifier;
import com.intellij.ssh.PromiscuousSshHostKeyVerifier;
import com.intellij.ssh.SshHostKeyVerifier;
import com.intellij.ssh.config.AuthMethod;
import com.intellij.ssh.config.AuthMethods;
import com.intellij.ssh.config.OpenSSHConfigUtil;
import com.intellij.ssh.config.ServerAlive;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigKt;
import com.intellij.ssh.config.SshIdeGlobalProxyGetter;
import com.intellij.ssh.config.SshProxyConfig;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"changeSshConnectionConfig", "Lcom/intellij/ssh/config/SshConnectionConfig;", "Lcom/intellij/remote/RemoteCredentials;", "source", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ssh"})
@JvmName(name="RemoteCredentialsSshConnectionConfig")
@SourceDebugExtension(value={"SMAP\nRemoteCredentialsSshConnectionConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCredentialsSshConnectionConfig.kt\ncom/intellij/ssh/config/RemoteCredentialsSshConnectionConfig\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,103:1\n1#2:104\n1563#3:105\n1634#3,3:106\n13#4:109\n*S KotlinDebug\n*F\n+ 1 RemoteCredentialsSshConnectionConfig.kt\ncom/intellij/ssh/config/RemoteCredentialsSshConnectionConfig\n*L\n63#1:105\n63#1:106,3\n102#1:109\n*E\n"})
public final class RemoteCredentialsSshConnectionConfig {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final SshConnectionConfig changeSshConnectionConfig(@NotNull RemoteCredentials $this$changeSshConnectionConfig, @NotNull SshConnectionConfig source) {
        ServerAlive serverAlive;
        SshHostKeyVerifier sshHostKeyVerifier;
        Credentials credentials;
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        int n;
        Object object4;
        Object object5;
        Object object6;
        block38: {
            block37: {
                Credentials credentials2;
                Object object7;
                block36: {
                    block35: {
                        Intrinsics.checkNotNullParameter((Object)$this$changeSshConnectionConfig, (String)"<this>");
                        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                        object7 = $this$changeSshConnectionConfig.getUserName();
                        if (object7 == null) break block35;
                        object5 = object6 = object7;
                        boolean bl2 = false;
                        object7 = ((CharSequence)object5).length() > 0 ? object6 : null;
                        if (object7 != null) break block36;
                    }
                    object7 = source.getUser();
                }
                object4 = object7;
                n = $this$changeSshConnectionConfig.getPort();
                object3 = $this$changeSshConnectionConfig.getConnectionConfigPatch();
                if (object3 == null || (object3 = object3.getProxyParams()) == null) break block37;
                object2 = object3;
                boolean bl3 = false;
                SshConnectionConfigPatch.ProxyParams.ProxyAuthData proxyAuthData = object2.getAuthData();
                if (proxyAuthData != null) {
                    object = proxyAuthData;
                    bl = false;
                    credentials2 = object.getAuthType() != SshConnectionConfigPatch.ProxyParams.ProxyAuthData.ProxyAuthType.NO_AUTHORIZATION ? new Credentials(object.getUsername(), object.getPassword()) : null;
                } else {
                    credentials2 = null;
                }
                credentials = credentials2;
                SshProxyConfig sshProxyConfig = switch (WhenMappings.$EnumSwitchMapping$0[object2.getProxyType().ordinal()]) {
                    case 1 -> new SshProxyConfig.HTTP(object2.getProxyHost(), object2.getProxyPort(), credentials);
                    case 2 -> new SshProxyConfig.SOCKS(object2.getProxyHost(), object2.getProxyPort(), credentials);
                    case 3 -> source.getProxyConfig();
                    case 4 -> {
                        SshIdeGlobalProxyGetter v5 = SshIdeGlobalProxyGetter.Companion.getInstance();
                        String v6 = $this$changeSshConnectionConfig.getHost();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"getHost(...)");
                        yield v5.getIdeWideProxy(v6, $this$changeSshConnectionConfig.getPort());
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
                object3 = sshProxyConfig;
                if (sshProxyConfig != null) break block38;
            }
            object3 = source.getProxyConfig();
        }
        Object object8 = object3;
        Object object9 = $this$changeSshConnectionConfig;
        boolean bl4 = false;
        Object object10 = switch (WhenMappings.$EnumSwitchMapping$1[object9.getAuthType().ordinal()]) {
            case 1 -> AuthMethod.Password.INSTANCE.plus(AuthMethod.KeyboardInteractive.INSTANCE).plus(new AuthMethod.PublicKey(new Path[0], AuthMethod.PublicKey.Agent.NO));
            case 2 -> {
                Path v9;
                Object var10_13 = object2 = object9.getPrivateKeyFile();
                boolean var13_19 = false;
                Intrinsics.checkNotNull((Object)var10_13);
                Object v8 = ((CharSequence)var10_13).length() > 0 ? object2 : null;
                if (v8 != null) {
                    var10_13 = v8;
                    var13_19 = false;
                    v9 = Paths.get((String)var10_13, new String[0]);
                } else {
                    v9 = null;
                }
                AuthMethod.PublicKey.Agent var27_24 = AuthMethod.PublicKey.Agent.NO;
                List var28_25 = CollectionsKt.listOfNotNull(v9);
                yield new AuthMethod.PublicKey(var28_25, var27_24).toAuthMethods();
            }
            case 3 -> AuthMethods.empty;
            default -> throw new NoWhenBranchMatchedException();
        };
        object6 = ((AuthMethods)object10).plus(source.getAuthMethods());
        RemoteCredentials remoteCredentials = $this$changeSshConnectionConfig;
        boolean bl5 = false;
        PromiscuousSshHostKeyVerifier promiscuousSshHostKeyVerifier = PromiscuousSshHostKeyVerifier.INSTANCE;
        object = promiscuousSshHostKeyVerifier;
        bl = false;
        PromiscuousSshHostKeyVerifier promiscuousSshHostKeyVerifier2 = remoteCredentials.isSkippingHostKeyVerification() ? promiscuousSshHostKeyVerifier : null;
        if (promiscuousSshHostKeyVerifier2 != null) {
            sshHostKeyVerifier = promiscuousSshHostKeyVerifier2;
        } else {
            OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier;
            SshConnectionConfigPatch sshConnectionConfigPatch = remoteCredentials.getConnectionConfigPatch();
            if (sshConnectionConfigPatch != null && (sshConnectionConfigPatch = sshConnectionConfigPatch.getHostKeyVerifier()) != null) {
                boolean bl6;
                Object object11;
                credentials = sshConnectionConfigPatch;
                boolean bl7 = false;
                object10 = source.getHostKeyVerifier();
                OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier2 = object10 instanceof OpenSshLikeHostKeyVerifier ? (OpenSshLikeHostKeyVerifier)object10 : null;
                Object object12 = openSshLikeHostKeyVerifier2;
                if (object12 == null || (object12 = ((OpenSshLikeHostKeyVerifier)object12).getKnownHostsFiles()) == null) {
                    Iterable iterable = OpenSSHConfigUtil.getDefaultKnownHostsFiles();
                    boolean bl8 = false;
                    Iterable iterable2 = iterable;
                    Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                    boolean bl9 = false;
                    for (Object t : iterable2) {
                        Path path2 = (Path)t;
                        Collection collection2 = collection;
                        boolean bl10 = false;
                        collection2.add(path2.toFile());
                    }
                    object12 = (List)collection;
                }
                if ((object11 = credentials.getStrictHostKeyChecking()) == null) {
                    OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier3 = openSshLikeHostKeyVerifier2;
                    object11 = openSshLikeHostKeyVerifier3 != null ? openSshLikeHostKeyVerifier3.getStrictHostKeyChecking() : null;
                    if (object11 == null) {
                        object11 = SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking.ASK;
                    }
                }
                Boolean bl11 = credentials.getHashKnownHosts();
                if (bl11 != null) {
                    bl6 = bl11;
                } else {
                    OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier4 = openSshLikeHostKeyVerifier2;
                    Boolean bl12 = openSshLikeHostKeyVerifier4 != null ? Boolean.valueOf(openSshLikeHostKeyVerifier4.getHashKnownHosts()) : null;
                    bl6 = bl12 != null ? bl12 : false;
                }
                OpenSshLikeHostKeyVerifier openSshLikeHostKeyVerifier5 = openSshLikeHostKeyVerifier2;
                boolean bl13 = openSshLikeHostKeyVerifier5 != null ? openSshLikeHostKeyVerifier5.getAllowDialogs() : true;
                boolean bl14 = bl6;
                SshConnectionConfigPatch.HostKeyVerifier.StrictHostKeyChecking strictHostKeyChecking = object11;
                Object object13 = object12;
                openSshLikeHostKeyVerifier = new OpenSshLikeHostKeyVerifier((List<? extends File>)object13, strictHostKeyChecking, bl14, bl13);
            } else {
                openSshLikeHostKeyVerifier = null;
            }
            sshHostKeyVerifier = openSshLikeHostKeyVerifier != null ? (SshHostKeyVerifier)openSshLikeHostKeyVerifier : source.getHostKeyVerifier();
        }
        object5 = sshHostKeyVerifier;
        RemoteCredentials remoteCredentials2 = $this$changeSshConnectionConfig;
        boolean bl15 = false;
        Object object14 = remoteCredentials2.getConnectionConfigPatch();
        if (object14 != null && (object14 = object14.getServerAliveInterval()) != null) {
            object = object14;
            bl = false;
            serverAlive = new ServerAlive((Duration)object, 3);
        } else {
            serverAlive = source.getServerAlive();
        }
        object9 = serverAlive;
        Object object15 = object4 = SshConnectionConfig.copy$default(source, (AuthMethods)object6, null, false, null, false, null, null, null, (SshHostKeyVerifier)object5, null, null, null, null, null, n, (SshProxyConfig)object8, (ServerAlive)object9, (String)object4, null, 278270, null);
        boolean bl16 = false;
        object6 = CollectionsKt.joinToString$default((Iterable)SshConnectionConfigKt.sshConnectionConfigDiff(source, (SshConnectionConfig)object15), (CharSequence)"\n", null, null, (int)0, null, RemoteCredentialsSshConnectionConfig::A, (int)30, null);
        if (((CharSequence)object6).length() > 0) {
            LOG.debug("Change after applying remote credentials for host " + $this$changeSshConnectionConfig.getHost() + ":\n" + (String)object6);
        } else {
            LOG.debug("No changes after applying remote credentials for host " + $this$changeSshConnectionConfig.getHost() + ".");
        }
        return object4;
    }

    private static final CharSequence A(Triple triple) {
        Intrinsics.checkNotNullParameter((Object)triple, (String)"<destruct>");
        String string = (String)triple.component1();
        Object object = triple.component2();
        Object object2 = triple.component3();
        return "  " + string + ": " + object + "\n" + StringsKt.repeat((CharSequence)" ", (int)(string.length() + 1)) + "-> " + object2;
    }

    static {
        boolean bl = false;
        Logger logger = Logger.getInstance(SshConnectionConfig.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SshConnectionConfigPatch.ProxyParams.Type.values().length];
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.HTTP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.SOCKS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.NO_PROXY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SshConnectionConfigPatch.ProxyParams.Type.IDE_WIDE_PROXY.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[AuthType.values().length];
            try {
                nArray[AuthType.PASSWORD.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthType.KEY_PAIR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[AuthType.OPEN_SSH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

