/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kotlin.jupyter.core.jupyter.kernel.server;

import com.intellij.jupyter.core.jupyter.connections.session.KernelStartupOptions;
import com.intellij.jupyter.core.jupyter.connections.session.SessionStartupOptions;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KernelConfigFactory;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KernelConfigFactoryKt;
import com.intellij.kotlin.jupyter.core.jupyter.kernel.server.KernelStartupOptionsExtKt;
import com.intellij.kotlin.jupyter.core.resources.KotlinNotebookMavenArtifactsDownloader;
import com.intellij.openapi.project.Project;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.jupyter.api.ReplCompilerMode;
import org.jetbrains.kotlinx.jupyter.protocol.startup.KernelJupyterParams;
import org.jetbrains.kotlinx.jupyter.protocol.startup.KernelPorts;
import org.jetbrains.kotlinx.jupyter.protocol.startup.parameters.KernelConfig;
import org.jetbrains.kotlinx.jupyter.protocol.startup.parameters.KernelOwnParams;
import org.jetbrains.kotlinx.jupyter.startup.parameters.KotlinKernelOwnParams;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\b\u0010\u001a\u001a\u00020\u001bH$J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\n\u001a\u00020\u000bH$\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0014H\u0014J\b\u0010 \u001a\u00020\u0014H\u0014J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013H\u0014J\u0012\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\u0006\u001a\u00020\u0007H\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006$"}, d2={"Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/AbstractKotlinKernelConfigFactory;", "Lcom/intellij/kotlin/jupyter/core/jupyter/kernel/server/KernelConfigFactory;", "startupOptions", "Lcom/intellij/jupyter/core/jupyter/connections/session/KernelStartupOptions;", "<init>", "(Lcom/intellij/jupyter/core/jupyter/connections/session/KernelStartupOptions;)V", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "notebookPath", "Ljava/nio/file/Path;", "getNotebookPath", "()Ljava/nio/file/Path;", "replCompilerMode", "Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;", "getReplCompilerMode", "()Lorg/jetbrains/kotlinx/jupyter/api/ReplCompilerMode;", "extraCompilerArguments", "", "", "getExtraCompilerArguments", "()Ljava/util/List;", "create", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/parameters/KernelConfig;", "Lorg/jetbrains/kotlinx/jupyter/startup/parameters/KotlinKernelOwnParams;", "getKernelPorts", "Lorg/jetbrains/kotlinx/jupyter/protocol/startup/KernelPorts;", "getDebugPortOrNull", "", "(Ljava/nio/file/Path;)Ljava/lang/Integer;", "getHost", "getSignature", "getClasspath", "getJvmTargetForSnippets", "Lcom/intellij/util/lang/JavaVersion;", "intellij.kotlin.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nKernelConfigFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelConfigFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/AbstractKotlinKernelConfigFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1563#2:122\n1634#2,3:123\n*S KotlinDebug\n*F\n+ 1 KernelConfigFactory.kt\ncom/intellij/kotlin/jupyter/core/jupyter/kernel/server/AbstractKotlinKernelConfigFactory\n*L\n47#1:122\n47#1:123,3\n*E\n"})
public abstract class AbstractKotlinKernelConfigFactory
implements KernelConfigFactory {
    @NotNull
    private final Project project;
    @NotNull
    private final Path notebookPath;
    @NotNull
    private final ReplCompilerMode replCompilerMode;
    @NotNull
    private final List<String> extraCompilerArguments;

    public AbstractKotlinKernelConfigFactory(@NotNull KernelStartupOptions startupOptions) {
        Intrinsics.checkNotNullParameter((Object)startupOptions, (String)"startupOptions");
        this.project = startupOptions.getProject();
        this.notebookPath = startupOptions.getNotebookPath();
        this.replCompilerMode = KernelStartupOptionsExtKt.getReplCompilerMode((SessionStartupOptions)startupOptions);
        this.extraCompilerArguments = KernelStartupOptionsExtKt.getExtraCompilerArguments((SessionStartupOptions)startupOptions);
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final Path getNotebookPath() {
        return this.notebookPath;
    }

    @NotNull
    protected final ReplCompilerMode getReplCompilerMode() {
        return this.replCompilerMode;
    }

    @NotNull
    protected final List<String> getExtraCompilerArguments() {
        return this.extraCompilerArguments;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public final KernelConfig<KotlinKernelOwnParams> create() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object = this.getHost();
        KernelPorts kernelPorts = this.getKernelPorts();
        String string = this.getSignature();
        KernelJupyterParams kernelJupyterParams = new KernelJupyterParams("HmacSHA256", string, (String)object, kernelPorts, "tcp");
        object = this.getClasspath();
        KernelJupyterParams kernelJupyterParams2 = kernelJupyterParams;
        boolean $i$f$map = false;
        string = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Path path2 = (Path)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toFile());
        }
        JavaVersion javaVersion = this.getJvmTargetForSnippets(this.project);
        List<String> list = this.extraCompilerArguments;
        ReplCompilerMode replCompilerMode2 = this.replCompilerMode;
        String string2 = javaVersion != null ? javaVersion.toFeatureString() : null;
        String string3 = "KOTLIN_NOTEBOOK";
        Integer n = this.getDebugPortOrNull(this.notebookPath);
        File file = null;
        List list2 = (List)destination$iv$iv;
        KernelOwnParams kernelOwnParams = new KotlinKernelOwnParams(list2, file, n, string3, string2, replCompilerMode2, list);
        KernelJupyterParams kernelJupyterParams3 = kernelJupyterParams2;
        return new KernelConfig(kernelJupyterParams3, kernelOwnParams);
    }

    @NotNull
    protected abstract KernelPorts getKernelPorts();

    @Nullable
    protected abstract Integer getDebugPortOrNull(@NotNull Path var1);

    @NotNull
    protected String getHost() {
        return "*";
    }

    @NotNull
    protected String getSignature() {
        return "x-x-x";
    }

    @NotNull
    protected List<Path> getClasspath() {
        return KernelConfigFactoryKt.access$getClasspathArtifacts(KotlinNotebookMavenArtifactsDownloader.Companion.getInstance(this.project), this.project);
    }

    @Nullable
    protected JavaVersion getJvmTargetForSnippets(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        LanguageLevel languageLevel = KernelConfigFactoryKt.chooseJvmTargetForSnippets(project);
        return languageLevel != null ? languageLevel.toJavaVersion() : null;
    }
}

