/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.run;

import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.application.JvmMainMethodRunConfigurationOptions;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.microservices.jvm.gutter.DumbAwareLineMarkerUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiMethodUtil;
import com.intellij.spring.boot.library.SpringBootLibraryUtil;
import com.intellij.spring.boot.run.SpringBootApplicationConfigurationTypeBase;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfiguration;
import com.intellij.spring.boot.run.SpringBootApplicationRunConfigurationProducerKt;
import com.intellij.spring.boot.run.SpringBootMainClassInfoProvider;
import java.util.Collection;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J&\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0014J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\"\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u00162\b\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u001bH\u0002J \u0010 \u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001f\u001a\u00020\u001b2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001b0\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002J\u0010\u0010%\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006&"}, d2={"Lcom/intellij/spring/boot/run/SpringBootApplicationRunConfigurationProducer;", "Lcom/intellij/execution/junit/JavaRunConfigurationProducerBase;", "Lcom/intellij/spring/boot/run/SpringBootApplicationRunConfiguration;", "<init>", "()V", "isDumbAware", "", "getConfigurationFactory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "setupConfigurationFromContext", "configuration", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "isConfigurationFromContext", "shouldReplace", "self", "Lcom/intellij/execution/actions/ConfigurationFromContext;", "other", "findMainClass", "Lkotlin/Pair;", "", "psiElement", "hasSpringBootMainMethod", "mainClass", "Lorg/jetbrains/uast/UClass;", "findSpringBootApplication", "file", "Lorg/jetbrains/uast/UFile;", "uClass", "findNestedClass", "condition", "Ljava/util/function/Predicate;", "mainMethodContainer", "Lorg/jetbrains/uast/UElement;", "isSpringApplication", "intellij.spring.boot.run.shared"})
@SourceDebugExtension(value={"SMAP\nSpringBootApplicationRunConfigurationProducer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringBootApplicationRunConfigurationProducer.kt\ncom/intellij/spring/boot/run/SpringBootApplicationRunConfigurationProducer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 UastContext.kt\norg/jetbrains/uast/UastContextKt\n*L\n1#1,171:1\n1#2:172\n295#3,2:173\n207#4:175\n207#4:176\n171#4:177\n*S KotlinDebug\n*F\n+ 1 SpringBootApplicationRunConfigurationProducer.kt\ncom/intellij/spring/boot/run/SpringBootApplicationRunConfigurationProducer\n*L\n84#1:173,2\n88#1:175\n152#1:176\n152#1:177\n*E\n"})
public final class SpringBootApplicationRunConfigurationProducer
extends JavaRunConfigurationProducerBase<SpringBootApplicationRunConfiguration> {
    public boolean isDumbAware() {
        return true;
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = SpringBootApplicationConfigurationTypeBase.getInstance().getConfigurationFactories()[0];
        Intrinsics.checkNotNullExpressionValue((Object)configurationFactory, (String)"get(...)");
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull SpringBootApplicationRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        try {
            Module module = context.getModule();
            if (!SpringBootLibraryUtil.hasSpringBootLibrary((Module)module)) {
                return false;
            }
            Pair<String, PsiElement> pair = this.findMainClass((PsiElement)sourceElement.get());
            if (pair == null) {
                return false;
            }
            Pair<String, PsiElement> pair2 = pair;
            String mainClassName = (String)pair2.component1();
            PsiElement newSourceElement = (PsiElement)pair2.component2();
            if (newSourceElement != null) {
                sourceElement.set((Object)newSourceElement);
            }
            configuration.setSpringBootMainClass(mainClassName);
            configuration.setGeneratedName();
            this.setupConfigurationModule(context, (ModuleBasedConfiguration)configuration);
            configuration.setDefaultFrameDeactivationUpdatePolicy();
            return true;
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public boolean isConfigurationFromContext(@NotNull SpringBootApplicationRunConfiguration configuration, @NotNull ConfigurationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            Module configurationModule = ((JavaRunConfigurationModule)configuration.getConfigurationModule()).getModule();
            if (!Intrinsics.areEqual((Object)context.getModule(), (Object)configurationModule)) {
                return false;
            }
            Pair<String, PsiElement> pair = this.findMainClass(context.getPsiLocation());
            if (pair == null) {
                return false;
            }
            Pair<String, PsiElement> contextClassWithAnchor = pair;
            String configFqn = configuration.getSpringBootMainClass();
            return Intrinsics.areEqual((Object)configFqn, (Object)contextClassWithAnchor.getFirst());
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    public boolean shouldReplace(@NotNull ConfigurationFromContext self, @NotNull ConfigurationFromContext other) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        ConfigurationFactory factory = other.getConfiguration().getFactory();
        return factory != null && Intrinsics.areEqual((Object)factory.getOptionsClass(), JvmMainMethodRunConfigurationOptions.class);
    }

    private final Pair<String, PsiElement> findMainClass(PsiElement psiElement) {
        PsiElement psiElement2;
        UClass uClass;
        if (psiElement == null) {
            return null;
        }
        UElement container = this.mainMethodContainer(psiElement);
        if (container instanceof UClass) {
            UElement uElement = container;
            UClass it = (UClass)uElement;
            boolean bl = false;
            uClass = (UClass)(PsiMethodUtil.hasMainMethod((PsiClass)it.getJavaPsi()) ? uElement : null);
        } else if (container instanceof UFile) {
            Object v1;
            block11: {
                Iterable $this$firstOrNull$iv = ((UFile)container).getClasses();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    UClass it = (UClass)element$iv;
                    boolean bl = false;
                    if (!PsiMethodUtil.hasMainMethod((PsiClass)it.getJavaPsi())) continue;
                    v1 = element$iv;
                    break block11;
                }
                v1 = null;
            }
            uClass = v1;
        } else {
            uClass = null;
        }
        if (uClass == null) {
            return null;
        }
        UClass mainClass = uClass;
        PsiElement $this$getUastParentOfType_u24default$iv = psiElement;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UFile uFile = (UFile)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UFile.class, (boolean)strict$iv);
        if (uFile == null) {
            return null;
        }
        UFile uFile2 = uFile;
        UClass springApplicationClass = this.findSpringBootApplication(uFile2);
        if (springApplicationClass == null && !this.hasSpringBootMainMethod(mainClass)) {
            return null;
        }
        UClass uClass2 = springApplicationClass;
        if (uClass2 == null) {
            uClass2 = mainClass;
        }
        String string = PsiMethodUtil.getMainClassQualifiedName((PsiClass)uClass2.getJavaPsi());
        if (string == null) {
            return null;
        }
        String mainClassName = string;
        PsiElement it = psiElement2 = mainClass.getSourcePsi();
        boolean bl = false;
        PsiElement sourceElement = !PsiMethodUtil.isMainMethodWithProvider((PsiClass)mainClass.getJavaPsi(), (PsiElement)psiElement) ? psiElement2 : null;
        return TuplesKt.to((Object)mainClassName, (Object)sourceElement);
    }

    private final boolean hasSpringBootMainMethod(UClass mainClass) {
        PsiMethod psiMethod = PsiMethodUtil.findMainMethod((PsiClass)mainClass.getJavaPsi());
        if (psiMethod == null) {
            return false;
        }
        PsiMethod findMainMethod = psiMethod;
        return SpringBootMainClassInfoProvider.Companion.getInstance().hasSpringBootApplicationRun(findMainMethod);
    }

    private final UClass findSpringBootApplication(UFile file) {
        UClass uClass;
        block1: {
            for (UClass uClass2 : (Iterable)file.getClasses()) {
                boolean bl = false;
                UClass uClass3 = this.findSpringBootApplication(uClass2);
                if (uClass3 == null) continue;
                uClass = uClass3;
                break block1;
            }
            uClass = null;
        }
        return uClass;
    }

    private final UClass findSpringBootApplication(UClass uClass) {
        UClass uClass2;
        if (this.isSpringApplication(uClass)) {
            return uClass;
        }
        if (UastUtils.getContainingUClass((UElement)((UElement)uClass)) == null || uClass.isStatic()) {
            UClass uClass3;
            try {
                UClass uClass4;
                block8: {
                    for (UClass it : uClass.getInnerClasses()) {
                        boolean bl = false;
                        uClass4 = this.findSpringBootApplication(it);
                        if (uClass4 == null) {
                            continue;
                        }
                        break block8;
                    }
                    uClass4 = null;
                }
                uClass3 = uClass4;
            }
            catch (IndexNotReadyException indexNotReadyException) {
                uClass3 = null;
            }
            if ((uClass2 = uClass3) == null) {
                uClass2 = this.findNestedClass(uClass, (Predicate)((Condition)arg_0 -> SpringBootApplicationRunConfigurationProducer.findSpringBootApplication$lambda$2(this, arg_0)));
            }
        } else {
            uClass2 = null;
        }
        return uClass2;
    }

    private final UClass findNestedClass(UClass uClass, Predicate<UClass> condition) {
        PsiElement psiElement = uClass.getSourcePsi();
        if (psiElement == null) {
            return null;
        }
        PsiElement sourcePsi = psiElement;
        if (sourcePsi instanceof PsiClass) {
            return null;
        }
        PsiElement[] psiElementArray = sourcePsi.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getChildren(...)");
        for (PsiElement psiElement2 : psiElementArray) {
            PsiElement[] grandChildren;
            Intrinsics.checkNotNull((Object)psiElement2);
            PsiElement child = psiElement2;
            Intrinsics.checkNotNullExpressionValue((Object)child.getChildren(), (String)"getChildren(...)");
            for (PsiElement psiElement3 : grandChildren) {
                UClass nestedClass;
                Intrinsics.checkNotNull((Object)psiElement3);
                PsiElement grandChild = psiElement3;
                if (!(grandChild instanceof PsiNamedElement) || (UClass)UastContextKt.toUElement((PsiElement)grandChild, UClass.class) == null || !condition.test(nestedClass)) continue;
                return nestedClass;
            }
        }
        return null;
    }

    private final UElement mainMethodContainer(PsiElement psiElement) {
        UElement uElement;
        PsiElement $this$getUastParentOfType_u24default$iv = psiElement;
        boolean strict$iv = false;
        boolean $i$f$getUastParentOfType = false;
        UClass uClass = (UClass)UastContextKt.getUastParentOfType((PsiElement)$this$getUastParentOfType_u24default$iv, UClass.class, (boolean)strict$iv);
        if (uClass != null) {
            uElement = (UElement)uClass;
        } else {
            PsiElement $this$toUElementOfType$iv = psiElement;
            boolean $i$f$toUElementOfType = false;
            uElement = UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UFile.class);
        }
        return uElement;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isSpringApplication(UClass mainClass) {
        try {
            psiClass = mainClass.getJavaPsi();
            var4_3 = SpringBootMainClassInfoProvider.Companion.getInstance().isSpringApplication(psiClass);
            it = var4_3;
            $i$a$-takeIf-SpringBootApplicationRunConfigurationProducer$isSpringApplication$smartResult$1 = false;
            if (it) ** GOTO lbl-1000
            v0 = psiClass.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getProject(...)");
            if (!DumbService.Companion.isDumb(v0)) lbl-1000:
            // 2 sources

            {
                v1 = true;
            } else {
                v1 = false;
            }
            var3_2 = v1 != false ? var4_3 : null;
        }
        catch (IndexNotReadyException <unused var>) {
            var3_2 = null;
        }
        v2 = smartResult = var3_2;
        return v2 != null ? v2 : DumbAwareLineMarkerUtilsKt.isAnnotatedInDumbMode((UDeclaration)((UDeclaration)mainClass), (Collection)SpringBootApplicationRunConfigurationProducerKt.access$getAPPLICATION_ANNOTATION_NAMES$p());
    }

    private static final boolean findSpringBootApplication$lambda$2(SpringBootApplicationRunConfigurationProducer this$0, UClass it) {
        Intrinsics.checkNotNull((Object)it);
        return this$0.isSpringApplication(it);
    }
}

