/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.types.impl;

import com.intellij.javascript.types.TSSymbol;
import com.intellij.javascript.types.TSType;
import com.intellij.javascript.types.impl.TSSymbolImpl;
import com.intellij.javascript.types.impl.TSTypeImplUtilsKt;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.typescript.tsc.gen.Symbol;
import com.intellij.lang.typescript.tsc.gen.Type;
import com.intellij.lang.typescript.tsc.gen.TypeScriptServerTypeCheckerContextKt;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/types/impl/TSCompilerType;", "T", "Lcom/intellij/lang/typescript/tsc/gen/Type;", "Lcom/intellij/javascript/types/TSType;", "tscType", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/lang/typescript/tsc/gen/Type;Lcom/intellij/openapi/project/Project;)V", "getTscType", "()Lcom/intellij/lang/typescript/tsc/gen/Type;", "Lcom/intellij/lang/typescript/tsc/gen/Type;", "getProject", "()Lcom/intellij/openapi/project/Project;", "buildJSTypeSource", "Lcom/intellij/lang/javascript/psi/types/JSTypeSource;", "symbol", "Lcom/intellij/javascript/types/TSSymbol;", "getSymbol", "()Lcom/intellij/javascript/types/TSSymbol;", "getProperty", "name", "", "intellij.javascript.backend"})
public abstract class TSCompilerType<T extends Type>
implements TSType {
    @NotNull
    private final T tscType;
    @NotNull
    private final Project project;

    public TSCompilerType(@NotNull T tscType, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(tscType, (String)"tscType");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.tscType = tscType;
        this.project = project;
    }

    @NotNull
    public final T getTscType() {
        return this.tscType;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final JSTypeSource buildJSTypeSource() {
        return TSTypeImplUtilsKt.buildJSTypeSource(this.tscType, this.project);
    }

    @Nullable
    public TSSymbol getSymbol() {
        Symbol symbol2 = this.tscType.getSymbol();
        if (symbol2 == null) {
            return null;
        }
        Symbol symbol3 = symbol2;
        return new TSSymbolImpl(symbol3, this.project);
    }

    @Nullable
    public TSSymbol getProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Symbol symbol2 = TypeScriptServerTypeCheckerContextKt.getIdeTypeCheckerContext(this.tscType).getTypeEvaluationSupport().getTypeProperty((Type)this.tscType, name);
        if (symbol2 == null) {
            return null;
        }
        Symbol symbol3 = symbol2;
        return new TSSymbolImpl(symbol3, this.project);
    }
}

