/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.completion.ml;

import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.ml.ContextFeatures;
import com.intellij.codeInsight.completion.ml.ElementFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSLanguageDialect;
import com.intellij.lang.javascript.completion.JSCompletionKeyword;
import com.intellij.lang.javascript.completion.ml.JSMLCompletionRankingProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLContextFeaturesProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLElementFeaturesProviderKt;
import com.intellij.lang.javascript.completion.ml.JSMLTrackingCompletionProvider;
import com.intellij.lang.javascript.completion.ml.Origin;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.presentable.JSNamedElementKind;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.SoftlyCachedValue;
import com.intellij.lang.javascript.template.postfix.JSPostfixTemplateProvider;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J,\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J$\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/intellij/lang/javascript/completion/ml/JSMLElementFeaturesProvider;", "Lcom/intellij/codeInsight/completion/ml/ElementFeatureProvider;", "<init>", "()V", "getName", "", "calculateFeatures", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "location", "Lcom/intellij/codeInsight/completion/CompletionLocation;", "contextFeatures", "Lcom/intellij/codeInsight/completion/ml/ContextFeatures;", "isAcceptable", "", "getIdentifiersSimilarity", "", "identifierWords", "", "targetWords", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSMLElementFeaturesProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMLElementFeaturesProvider.kt\ncom/intellij/lang/javascript/completion/ml/JSMLElementFeaturesProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1788#2,4:146\n*S KotlinDebug\n*F\n+ 1 JSMLElementFeaturesProvider.kt\ncom/intellij/lang/javascript/completion/ml/JSMLElementFeaturesProvider\n*L\n141#1:146,4\n*E\n"})
public class JSMLElementFeaturesProvider
implements ElementFeatureProvider {
    @NotNull
    public String getName() {
        return "js";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull LookupElement element2, @NotNull CompletionLocation location, @NotNull ContextFeatures contextFeatures) {
        PsiElement parent;
        Class[] classArray;
        PsiElement psiElement;
        JSPostfixTemplateProvider.JSPostfixTemplateKind templateKind;
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)contextFeatures, (String)"contextFeatures");
        if (!this.isAcceptable(location)) {
            return MapsKt.emptyMap();
        }
        Map result2 = new LinkedHashMap();
        JSMLTrackingCompletionProvider.Kind provider = (JSMLTrackingCompletionProvider.Kind)((Object)element2.getUserData(JSMLTrackingCompletionProvider.JS_PROVIDER_KEY));
        if (provider != null) {
            result2.put("provider", MLFeatureValue.Companion.categorical((Enum)provider));
        }
        Object object = element2.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object obj = object;
        if (obj instanceof JSCompletionKeyword) {
            result2.put("keyword", MLFeatureValue.Companion.categorical((Enum)obj));
        }
        if (element2 instanceof PostfixTemplateLookupElement && (templateKind = JSPostfixTemplateProvider.findKindByTemplate(((PostfixTemplateLookupElement)element2).getPostfixTemplate())) != null) {
            result2.put("postfix_template", MLFeatureValue.Companion.categorical((Enum)templateKind));
        }
        if ((psiElement = element2.getPsiElement()) == null) {
            return result2;
        }
        Origin origin = TypeScriptPsiUtil.isAmbientDeclaration((PsiElement)psiElement) ? Origin.DTS : (PsiTreeUtil.getContextOfType((PsiElement)psiElement, (Class[])(classArray = new Class[]{JSEmbeddedContent.class})) != null ? Origin.HTML : (DialectDetector.isTypeScript((PsiElement)psiElement) ? Origin.TS : Origin.JS));
        result2.put("origin", MLFeatureValue.Companion.categorical((Enum)origin));
        PsiFile psiFile = psiElement.getContainingFile();
        VirtualFile elementFile = psiFile != null ? psiFile.getVirtualFile() : null;
        boolean isFromCoreLibrary = elementFile != null && JSCorePredefinedLibrariesProvider.isCoreLibraryFile(elementFile);
        result2.put("is_from_core_library", MLFeatureValue.Companion.binary(isFromCoreLibrary));
        Map map = result2;
        String string = "kind";
        JSNamedElementKind jSNamedElementKind = JSNamedElementKind.kind((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)jSNamedElementKind, (String)"kind(...)");
        MLFeatureValue mLFeatureValue = MLFeatureValue.Companion.categorical((Enum)jSNamedElementKind);
        map.put(string, mLFeatureValue);
        CompletionParameters completionParameters = location.getCompletionParameters();
        if (completionParameters != null && (completionParameters = completionParameters.getPosition()) != null && (completionParameters = completionParameters.getParent()) != null) {
            CompletionParameters it = completionParameters;
            boolean bl = false;
            v4 = CompletionUtil.getOriginalOrSelf((PsiElement)it);
        } else {
            v4 = parent = null;
        }
        if (parent instanceof JSReferenceExpression) {
            PsiElement psiElement2;
            Object object2;
            Object expectedTypeWords;
            Object object3 = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getEXPECTED_TYPE_WORDS_KEY());
            if (object3 == null || (object3 = (List)object3.getUpToDateOrNull()) == null) {
                object3 = expectedTypeWords = CollectionsKt.emptyList();
            }
            if ((object2 = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getINITIALIZED_ELEMENT_WORDS_KEY())) == null || (object2 = (List)object2.getUpToDateOrNull()) == null) {
                object2 = CollectionsKt.emptyList();
            }
            Object initializedElementWords = object2;
            double expectedTypeSimilarity = 0.0;
            double initializedNameSimilarity = 0.0;
            double expectedAndElementTypesSimilarity = 0.0;
            double initializedNameAndElementTypeSimilarity = 0.0;
            if (!((Collection)expectedTypeWords).isEmpty() || !((Collection)initializedElementWords).isEmpty()) {
                PsiElement typeOfElement;
                String string2 = element2.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getLookupString(...)");
                List<String> identifierWords = JSMLContextFeaturesProviderKt.wordsFromQualifiedName(string2);
                expectedTypeSimilarity = this.getIdentifiersSimilarity(identifierWords, (List<String>)expectedTypeWords);
                initializedNameSimilarity = this.getIdentifiersSimilarity(identifierWords, (List<String>)initializedElementWords);
                psiElement2 = psiElement;
                Object object4 = psiElement2 instanceof JSTypeDeclarationOwner ? ((JSTypeDeclarationOwner)psiElement).getTypeElement() : (psiElement2 instanceof JSFunction ? ((JSFunction)psiElement).getReturnTypeElement() : (typeOfElement = psiElement2 instanceof JSClass ? psiElement : null));
                if (typeOfElement != null) {
                    List<String> elementTypeWords = JSMLContextFeaturesProviderKt.identifiersFromTypeDeclaration(typeOfElement);
                    expectedAndElementTypesSimilarity = this.getIdentifiersSimilarity(elementTypeWords, (List<String>)expectedTypeWords);
                    initializedNameAndElementTypeSimilarity = this.getIdentifiersSimilarity(elementTypeWords, (List<String>)initializedElementWords);
                }
            }
            boolean isFromReferencedFile = false;
            boolean isFromReferencedModule = false;
            if (elementFile != null) {
                Object object5 = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getREFERENCED_FILES_KEY());
                if (object5 == null || (object5 = (Set)object5.getUpToDateOrNull()) == null) {
                    object5 = SetsKt.emptySet();
                }
                Object referencedFiles = object5;
                isFromReferencedFile = referencedFiles.contains(elementFile);
                Object object6 = (SoftlyCachedValue)((JSReferenceExpression)parent).getUserData(JSMLElementFeaturesProviderKt.getREFERENCED_MODULES_KEY());
                if (object6 == null || (object6 = (Set)object6.getUpToDateOrNull()) == null) {
                    object6 = SetsKt.emptySet();
                }
                Object referencedModules = object6;
                ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)location.getProject()).getFileIndex();
                Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
                ProjectFileIndex fileIndex = projectFileIndex;
                isFromReferencedModule = CollectionsKt.contains((Iterable)((Iterable)referencedModules), (Object)JSMLContextFeaturesProviderKt.getLibrarySourceRootForFile(fileIndex, elementFile));
            }
            psiElement2 = new PsiElement[]{TuplesKt.to((Object)"expected_type_and_ref_name_similarity", (Object)MLFeatureValue.Companion.float(expectedTypeSimilarity)), TuplesKt.to((Object)"initialized_name_similarity", (Object)MLFeatureValue.Companion.float(initializedNameSimilarity)), TuplesKt.to((Object)"expected_and_element_types_similarity", (Object)MLFeatureValue.Companion.float(expectedAndElementTypesSimilarity)), TuplesKt.to((Object)"initialized_name_and_element_type_similarity", (Object)MLFeatureValue.Companion.float(initializedNameAndElementTypeSimilarity)), TuplesKt.to((Object)"is_from_referenced_file", (Object)MLFeatureValue.Companion.binary(isFromReferencedFile)), TuplesKt.to((Object)"is_from_referenced_module", (Object)MLFeatureValue.Companion.binary(isFromReferencedModule))};
            MapsKt.putAll((Map)result2, (Pair[])psiElement2);
        }
        return result2;
    }

    public boolean isAcceptable(@NotNull CompletionLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        CompletionParameters completionParameters = location.getCompletionParameters();
        if (completionParameters == null || (completionParameters = completionParameters.getPosition()) == null) {
            return false;
        }
        CompletionParameters position = completionParameters;
        Language language = DialectDetector.languageOfElement((PsiElement)position);
        JSLanguageDialect jSLanguageDialect = language instanceof JSLanguageDialect ? (JSLanguageDialect)language : null;
        if (jSLanguageDialect == null) {
            return false;
        }
        JSLanguageDialect language2 = jSLanguageDialect;
        return JSMLCompletionRankingProviderKt.isJSMLSupported(language2);
    }

    private final double getIdentifiersSimilarity(List<String> identifierWords, List<String> targetWords) {
        int n;
        if (identifierWords.isEmpty() || targetWords.isEmpty()) {
            return 0.0;
        }
        Iterable $this$count$iv = identifierWords;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                String p0 = (String)element$iv;
                boolean bl = false;
                if (!targetWords.contains(p0) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        return (double)n / (double)Math.max(identifierWords.size(), targetWords.size());
    }
}

