/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.lang.javascript.service.JSLanguageServiceOutOfMemoryUsagesCollector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u001a\u001a\u00020\u001bH\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/service/JSNodeServiceOutOfMemoryDetector;", "", "project", "Lcom/intellij/openapi/project/Project;", "serviceName", "", "fusClass", "Ljava/lang/Class;", "configuredMemoryLimitMb", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/Class;Ljava/lang/Integer;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getServiceName", "()Ljava/lang/String;", "Ljava/lang/Integer;", "value", "", "oomDetected", "getOomDetected", "()Z", "processListener", "Lcom/intellij/execution/process/ProcessListener;", "getProcessListener", "()Lcom/intellij/execution/process/ProcessListener;", "handleCrashDetected", "", "intellij.javascript.backend"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nJSNodeServiceOutOfMemoryDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSNodeServiceOutOfMemoryDetector.kt\ncom/intellij/lang/javascript/service/JSNodeServiceOutOfMemoryDetector\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n13#2:56\n1#3:57\n*S KotlinDebug\n*F\n+ 1 JSNodeServiceOutOfMemoryDetector.kt\ncom/intellij/lang/javascript/service/JSNodeServiceOutOfMemoryDetector\n*L\n50#1:56\n*E\n"})
public class JSNodeServiceOutOfMemoryDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final String serviceName;
    @NotNull
    private final Class<?> fusClass;
    @Nullable
    private final Integer configuredMemoryLimitMb;
    private volatile boolean oomDetected;
    @NotNull
    private final ProcessListener processListener;

    public JSNodeServiceOutOfMemoryDetector(@NotNull Project project, @NotNull String serviceName, @NotNull Class<?> fusClass, @Nullable Integer configuredMemoryLimitMb) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter(fusClass, (String)"fusClass");
        this.project = project;
        this.serviceName = serviceName;
        this.fusClass = fusClass;
        this.configuredMemoryLimitMb = configuredMemoryLimitMb;
        this.processListener = new ProcessListener(this){
            private volatile boolean crashTextSeen;
            final /* synthetic */ JSNodeServiceOutOfMemoryDetector this$0;
            {
                this.this$0 = $receiver;
            }

            public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                if (this.this$0.getOomDetected()) {
                    return;
                }
                if (!ProcessOutputType.isStderr(outputType)) {
                    return;
                }
                String string = event.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                this.handleErrorText(string);
            }

            private final void handleErrorText(CharSequence message) {
                if (StringsKt.contains$default((CharSequence)message, (CharSequence)"Allocation failed - JavaScript heap out of memory", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)message, (CharSequence)"Allocation failed - process out of memory", (boolean)false, (int)2, null)) {
                    this.crashTextSeen = true;
                }
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (this.crashTextSeen && event.getExitCode() != 0) {
                    JSNodeServiceOutOfMemoryDetector.access$setOomDetected$p(this.this$0, true);
                    this.this$0.handleCrashDetected();
                }
            }
        };
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final String getServiceName() {
        return this.serviceName;
    }

    public final boolean getOomDetected() {
        return this.oomDetected;
    }

    @NotNull
    public final ProcessListener getProcessListener() {
        return this.processListener;
    }

    /*
     * WARNING - void declaration
     */
    protected void handleCrashDetected() {
        Object object;
        String string;
        Logger logger;
        block3: {
            block2: {
                void it;
                boolean $i$f$logger = false;
                Logger logger2 = Logger.getInstance(JSNodeServiceOutOfMemoryDetector.class);
                logger = logger2;
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
                string = this.serviceName;
                object = this.configuredMemoryLimitMb;
                if (object == null) break block2;
                int n = ((Number)object).intValue();
                String string2 = string;
                Logger logger3 = logger;
                boolean bl = false;
                String string3 = " with configured max memory " + (int)it + " MB";
                logger = logger3;
                string = string2;
                String string4 = string3;
                object = string4;
                if (string4 != null) break block3;
            }
            object = "";
        }
        logger.error("OOM crash detected in " + string + " service" + (String)object);
        Integer n = this.configuredMemoryLimitMb;
        JSLanguageServiceOutOfMemoryUsagesCollector.INSTANCE.detectedOom(this.project, this.fusClass, n != null ? n : 0);
    }

    public static final /* synthetic */ void access$setOomDetected$p(JSNodeServiceOutOfMemoryDetector $this, boolean bl) {
        $this.oomDetected = bl;
    }
}

