/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.inspection;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.intentions.ES6ReplaceImportFromClauseFix;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.inspections.JSInspection;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.JSElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6PreferShortImportInspection
extends JSInspection {
    @Override
    @NotNull
    protected PsiElementVisitor createVisitor(final @NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            ES6PreferShortImportInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            ES6PreferShortImportInspection.$$$reportNull$$$0(1);
        }
        return new JSElementVisitor(this){

            public void visitES6ImportDeclaration(@NotNull ES6ImportDeclaration importDeclaration) {
                if (importDeclaration == null) {
                    1.$$$reportNull$$$0(0);
                }
                ES6PreferShortImportInspection.inspectImport(holder, importDeclaration);
                super.visitES6ImportDeclaration(importDeclaration);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "importDeclaration", "com/intellij/lang/typescript/inspection/ES6PreferShortImportInspection$1", "visitES6ImportDeclaration"));
            }
        };
    }

    private static void inspectImport(ProblemsHolder holder, ES6ImportDeclaration importDeclaration) {
        PsiFile currentFile;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!ArrayUtil.isEmpty((Object[])importDeclaration.getImportedBindings())) {
            return;
        }
        Object[] specifiers = importDeclaration.getImportSpecifiers();
        if (ArrayUtil.isEmpty((Object[])specifiers)) {
            return;
        }
        ArrayList<JSQualifiedNamedElement> elements = new ArrayList<JSQualifiedNamedElement>();
        ES6FromClause clause = importDeclaration.getFromClause();
        if (clause == null) {
            return;
        }
        String text = StringUtil.notNullize((String)clause.getReferenceText());
        String unquotedOldText = JSStringUtil.unquoteAndUnescapeStringLiteralValue((String)text);
        if (!ES6PreferShortImportInspection.isInspectionAvailable(clause, unquotedOldText)) {
            return;
        }
        Collection refElements = clause.resolveReferencedElements();
        if (refElements.isEmpty()) {
            return;
        }
        if (!ES6PreferShortImportInspection.fillSpecifierElements((ES6ImportSpecifier[])specifiers, elements) || elements.isEmpty()) {
            return;
        }
        JSQualifiedNamedElement item = (JSQualifiedNamedElement)ContainerUtil.getFirstItem(elements);
        assert (item != null);
        Project project = importDeclaration.getProject();
        JSModuleNameInfo info = ES6CreateImportUtil.getExternalFileModuleName((PsiElement)item, (PsiElement)importDeclaration, false);
        ProgressIndicatorProvider.checkCanceled();
        if (info == null) {
            return;
        }
        String unquotedNewName = info.getModuleName();
        String extension = JSFileReferencesUtil.findImplicitExtension((String)unquotedOldText);
        String fixedOld = StringUtil.trimEnd((String)unquotedOldText, (String)"/");
        if (extension != null) {
            fixedOld = StringUtil.trimEnd((String)unquotedOldText, (String)extension);
        }
        if (unquotedNewName.length() >= fixedOld.length()) {
            return;
        }
        if (unquotedNewName.equals("./") || unquotedNewName.equals("../")) {
            return;
        }
        List sublist = elements.subList(1, elements.size());
        VirtualFile module = info.getResolvedFile();
        if (module.equals((currentFile = importDeclaration.getContainingFile()).getVirtualFile())) {
            return;
        }
        for (JSQualifiedNamedElement elementToImport : sublist) {
            if (ES6CreateImportUtil.checkSymbolInFile(project, module, (PsiElement)elementToImport, (PsiElement)currentFile)) continue;
            return;
        }
        ASTNode node = clause.getNode();
        ASTNode literalNode = node.findChildByType(JSTokenTypes.STRING_LITERALS);
        if (literalNode == null) {
            return;
        }
        holder.registerProblem(literalNode.getPsi(), JavaScriptBundle.message((String)"es6.prefer.short.import.name", (Object[])new Object[0]), new LocalQuickFix[]{new ES6ReplaceImportFromClauseFix((ES6ImportExportDeclaration)importDeclaration, unquotedNewName)});
    }

    public static boolean isInspectionAvailable(@NotNull ES6FromClause clause, @Nullable String importText) {
        if (clause == null) {
            ES6PreferShortImportInspection.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)importText)) {
            return false;
        }
        boolean withDot = importText.startsWith(".");
        boolean withIndex = importText.endsWith("index");
        if (importText.contains("!") || importText.contains("?")) {
            return false;
        }
        if (DialectDetector.isJavaScript((PsiElement)clause) && withDot && withIndex) {
            return false;
        }
        return withDot || withIndex;
    }

    private static boolean fillSpecifierElements(ES6ImportSpecifier @NotNull [] specifiers, @NotNull List<JSQualifiedNamedElement> elements) {
        if (elements == null) {
            ES6PreferShortImportInspection.$$$reportNull$$$0(3);
        }
        if (specifiers == null) {
            ES6PreferShortImportInspection.$$$reportNull$$$0(4);
        }
        for (ES6ImportSpecifier specifier : specifiers) {
            String name = specifier.getName();
            ResolveResult[] results = specifier.resolveOverAliases();
            List candidates = JSResolveResult.toElements((ResolveResult[])results);
            for (PsiElement candidate : candidates) {
                if (!(candidate instanceof JSQualifiedNamedElement)) {
                    return false;
                }
                String candidateName = ((JSQualifiedNamedElement)candidate).getName();
                if (!StringUtil.equals((CharSequence)name, (CharSequence)candidateName)) {
                    return false;
                }
                elements.add((JSQualifiedNamedElement)candidate);
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clause";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifiers";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/inspection/ES6PreferShortImportInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createVisitor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isInspectionAvailable";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "fillSpecifierElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

