/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.environment;

import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookEditorCreatedCallback;
import com.intellij.jupyter.core.executor.JupyterExecutionListener;
import com.intellij.jupyter.core.executor.cell.JupyterCellTask;
import com.intellij.jupyter.core.executor.task.JupyterExecutionTask;
import com.intellij.jupyter.core.jupyter.connections.execution.JupyterTaskExecutorResult;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterNotebookSession;
import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.py.debugger.JupyterDebugCellTask;
import com.intellij.jupyter.py.environment.PythonNotebookEnvironmentStateManager;
import com.intellij.jupyter.py.environment.stores.PythonEnvironmentStateManagersStore;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/intellij/jupyter/py/environment/PythonJupyterExecutionEventDispatcher;", "Lcom/intellij/jupyter/core/executor/JupyterExecutionListener;", "Lcom/intellij/jupyter/core/editor/NotebookEditorCreatedCallback;", "<init>", "()V", "sessionDeleted", "", "session", "Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;", "(Lcom/intellij/jupyter/core/jupyter/connections/execution/core/JupyterNotebookSession;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "taskStopped", "task", "Lcom/intellij/jupyter/core/executor/task/JupyterExecutionTask;", "executorResult", "Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;", "(Lcom/intellij/jupyter/core/executor/task/JupyterExecutionTask;Lcom/intellij/jupyter/core/jupyter/connections/execution/JupyterTaskExecutorResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "taskStarted", "(Lcom/intellij/jupyter/core/executor/task/JupyterExecutionTask;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "editorCreated", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.jupyter.py"})
public final class PythonJupyterExecutionEventDispatcher
implements JupyterExecutionListener,
NotebookEditorCreatedCallback {
    @Nullable
    public Object sessionDeleted(@NotNull JupyterNotebookSession session, @NotNull Continuation<? super Unit> $completion) {
        Project project = session.getProject();
        BackedNotebookVirtualFile backedNotebookVirtualFile = session.getVirtualFile();
        PythonNotebookEnvironmentStateManager pythonNotebookEnvironmentStateManager = PythonEnvironmentStateManagersStore.Companion.getInstance(project).getEnvironmentStateManager(backedNotebookVirtualFile);
        if (pythonNotebookEnvironmentStateManager != null) {
            pythonNotebookEnvironmentStateManager.sessionDeleted();
        }
        PythonEnvironmentStateManagersStore.Companion.getInstance(project).removeEnvironmentStateManager(backedNotebookVirtualFile);
        return Unit.INSTANCE;
    }

    @Nullable
    public Object taskStopped(@NotNull JupyterExecutionTask task, @NotNull JupyterTaskExecutorResult executorResult, @NotNull Continuation<? super Unit> $completion) {
        Project project = task.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = task.getNotebookVirtualFile();
        if (!(task instanceof JupyterCellTask)) {
            return Unit.INSTANCE;
        }
        PythonNotebookEnvironmentStateManager environmentStateManager = PythonEnvironmentStateManagersStore.Companion.getInstance(project2).getEnvironmentStateManager(backedNotebookVirtualFile);
        if (task instanceof JupyterDebugCellTask) {
            PythonNotebookEnvironmentStateManager pythonNotebookEnvironmentStateManager = environmentStateManager;
            if (pythonNotebookEnvironmentStateManager != null) {
                pythonNotebookEnvironmentStateManager.debugEnd();
            }
        }
        if (environmentStateManager != null) {
            environmentStateManager.taskStopped(executorResult);
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object taskStarted(@NotNull JupyterExecutionTask task, @NotNull Continuation<? super Unit> $completion) {
        Project project = task.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = task.getNotebookVirtualFile();
        if (!(task instanceof JupyterDebugCellTask)) {
            return Unit.INSTANCE;
        }
        PythonNotebookEnvironmentStateManager pythonNotebookEnvironmentStateManager = PythonEnvironmentStateManagersStore.Companion.getInstance(project2).getEnvironmentStateManager(backedNotebookVirtualFile);
        if (pythonNotebookEnvironmentStateManager != null) {
            pythonNotebookEnvironmentStateManager.debugStart();
        }
        return Unit.INSTANCE;
    }

    public void editorCreated(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Project project = editor.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        BackedNotebookVirtualFile backedNotebookVirtualFile = JupyterEditorExtensionsKt.getNotebookFileOrNull((Editor)editor);
        if (backedNotebookVirtualFile == null) {
            return;
        }
        BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
        PythonNotebookEnvironmentStateManager pythonNotebookEnvironmentStateManager = PythonEnvironmentStateManagersStore.Companion.getInstance(project2).getEnvironmentStateManager(backedNotebookVirtualFile2);
        if (pythonNotebookEnvironmentStateManager != null) {
            pythonNotebookEnvironmentStateManager.updateRuntimeInlineValues();
        }
    }
}

