/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole;

import com.intellij.jupyter.core.console.JupyterConsoleUtil;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.editor.NotebookFileRenameListener;
import com.intellij.jupyter.core.editor.NotebookFileRenamedEvent;
import com.intellij.jupyter.core.jupyter.editor.JupyterFileEditor;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileExtensionsKt;
import com.intellij.jupyter.core.jupyter.server.ui.JupyterServerToolWindowKt;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsolePanel;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0005J\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0011\u001a\u00020\u0005J\u001a\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u0006J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0013H\u0002J\u001c\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u00060\u0005j\u0002`\u0006H\u0002J\u0012\u0010\u001d\u001a\u00020\u000e2\n\u0010\u001e\u001a\u00060\u0005j\u0002`\u0006J\u0012\u0010\u001f\u001a\u00020\u000e2\n\u0010\u001e\u001a\u00060\u0005j\u0002`\u0006R\"\u0010\u0004\u001a\n\u0018\u00010\u0005j\u0004\u0018\u0001`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService;", "Lcom/intellij/openapi/Disposable$Default;", "<init>", "()V", "activeNotebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "Lcom/intellij/jupyter/core/console/OriginalNotebookFile;", "getActiveNotebookFile", "()Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "setActiveNotebookFile", "(Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;)V", "isToolWindowListenersInit", "", "removeConsoleView", "", "project", "Lcom/intellij/openapi/project/Project;", "notebookVirtualFile", "getConsoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "showOrCreateConsole", "showAndFocusConsoleView", "consoleView", "handleConsoleRename", "event", "Lcom/intellij/jupyter/core/editor/NotebookFileRenamedEvent;", "addToolWindowListeners", "createContent", "createConsoleView", "onDebugStart", "originalNotebookFile", "onDebugEnd", "Companion", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterConsoleService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConsoleService.kt\ncom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,158:1\n1#2:159\n*E\n"})
public final class JupyterConsoleService
implements Disposable.Default {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BackedNotebookVirtualFile activeNotebookFile;
    private boolean isToolWindowListenersInit;
    @NotNull
    private static final Key<JupyterConsoleView> CONSOLE_VIEW_KEY;

    public JupyterConsoleService() {
        MessageBus messageBus = ApplicationManager.getApplication().getMessageBus();
        Intrinsics.checkNotNullExpressionValue((Object)messageBus, (String)"getMessageBus(...)");
        MessageBus messageBus2 = messageBus;
        messageBus2.connect((Disposable)this).subscribe(NotebookFileRenameListener.Companion.getNOTEBOOK_FILE_RENAMED_TOPIC(), arg_0 -> JupyterConsoleService._init_$lambda$0(this, arg_0));
    }

    @Nullable
    public final BackedNotebookVirtualFile getActiveNotebookFile() {
        return this.activeNotebookFile;
    }

    public final void setActiveNotebookFile(@Nullable BackedNotebookVirtualFile backedNotebookVirtualFile) {
        this.activeNotebookFile = backedNotebookVirtualFile;
    }

    public final void removeConsoleView(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Object object;
        ContentManager contentManager;
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
            ContentManager contentManager2 = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project).getContentManager();
            Intrinsics.checkNotNullExpressionValue((Object)contentManager2, (String)"getContentManager(...)");
            contentManager = contentManager2;
            BackedNotebookVirtualFile original = JupyterConsoleUtil.INSTANCE.getOriginal(notebookVirtualFile);
            Content[] contentArray = contentManager.getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"getContents(...)");
            for (Object object2 : (Object[])contentArray) {
                Content it = (Content)object2;
                boolean bl = false;
                JComponent jComponent = it.getComponent();
                JupyterConsolePanel jupyterConsolePanel = jComponent instanceof JupyterConsolePanel ? (JupyterConsolePanel)((Object)jComponent) : null;
                if (!Intrinsics.areEqual((Object)(jupyterConsolePanel != null ? jupyterConsolePanel.getNotebookFile() : null), (Object)original)) continue;
                object = object2;
                break block2;
            }
            object = null;
        }
        Content content = (Content)object;
        if (content == null) {
            return;
        }
        Content content2 = content;
        contentManager.removeContent(content2, true);
    }

    @Nullable
    public final JupyterConsoleView getConsoleView(@NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        BackedNotebookVirtualFile original = JupyterConsoleUtil.INSTANCE.getOriginal(notebookVirtualFile);
        return (JupyterConsoleView)((Object)original.getUserData(CONSOLE_VIEW_KEY));
    }

    @NotNull
    public final JupyterConsoleView showOrCreateConsole(@NotNull Project project, @NotNull BackedNotebookVirtualFile notebookVirtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookVirtualFile, (String)"notebookVirtualFile");
        JupyterConsoleView existsConsoleView = this.getConsoleView(notebookVirtualFile);
        if (existsConsoleView != null) {
            this.showAndFocusConsoleView(project, existsConsoleView);
            return existsConsoleView;
        }
        JupyterConsoleView consoleView = this.createConsoleView(project, notebookVirtualFile);
        this.createContent(project, consoleView);
        this.showAndFocusConsoleView(project, consoleView);
        return consoleView;
    }

    private final void showAndFocusConsoleView(Project project, JupyterConsoleView consoleView) {
        ToolWindow jupyterToolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        jupyterToolWindow.show(() -> JupyterConsoleService.showAndFocusConsoleView$lambda$0(jupyterToolWindow, consoleView));
    }

    private final void handleConsoleRename(NotebookFileRenamedEvent event) {
        block1: {
            String string = event.getNewRelativePath();
            if (string == null) {
                string = event.getNewName();
            }
            String displayPath = string;
            JupyterConsoleView jupyterConsoleView = this.getConsoleView(event.getNotebookVirtualFile());
            if (jupyterConsoleView == null) break block1;
            jupyterConsoleView.renameConsoleTab(displayPath);
        }
    }

    private final void addToolWindowListeners(Project project) {
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        busConnection.subscribe(topic, (Object)new FileEditorManagerListener(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
            }

            public void selectionChanged(FileEditorManagerEvent e) {
                block2: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    FileEditor fileEditor = e.getNewEditor();
                    JupyterFileEditor jupyterFileEditor = fileEditor instanceof JupyterFileEditor ? (JupyterFileEditor)fileEditor : null;
                    if (jupyterFileEditor == null) {
                        return;
                    }
                    JupyterFileEditor editor = jupyterFileEditor;
                    BackedNotebookVirtualFile backedNotebookVirtualFile = BackedNotebookVirtualFile.Companion.takeIfBacked(editor.getFile());
                    if (backedNotebookVirtualFile == null) {
                        return;
                    }
                    BackedNotebookVirtualFile backedNotebookVirtualFile2 = backedNotebookVirtualFile;
                    ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)this.$project);
                    JupyterConsoleView jupyterConsoleView = (JupyterConsoleView)((Object)backedNotebookVirtualFile2.getUserData(JupyterConsoleService.Companion.getCONSOLE_VIEW_KEY()));
                    if (jupyterConsoleView == null) break block2;
                    JupyterConsoleView view = jupyterConsoleView;
                    boolean bl = false;
                    Content it = view.getContent();
                    boolean bl2 = false;
                    toolWindow.getContentManager().setSelectedContent(it);
                }
            }
        });
        this.isToolWindowListenersInit = true;
        JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project).getContentManager().addContentManagerListener(new ContentManagerListener(project, this){
            final /* synthetic */ Project $project;
            final /* synthetic */ JupyterConsoleService this$0;
            {
                this.$project = $project;
                this.this$0 = $receiver;
            }

            public void contentRemoved(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)this.$project);
                if (toolWindow.getContentManager().getContentCount() == 0) {
                    toolWindow.remove();
                    JupyterConsoleService.access$setToolWindowListenersInit$p(this.this$0, false);
                }
            }
        });
    }

    private final void createContent(Project project, JupyterConsoleView consoleView) {
        if (!this.isToolWindowListenersInit) {
            this.addToolWindowListeners(project);
        }
        Content content = consoleView.showPanel();
        ToolWindow toolWindow = JupyterServerToolWindowKt.getOrCreateJupyterToolWindow((Project)project);
        toolWindow.getContentManager().addContent(content);
    }

    private final JupyterConsoleView createConsoleView(Project project, BackedNotebookVirtualFile notebookVirtualFile) {
        this.activeNotebookFile = notebookVirtualFile;
        Object object = JupyterFileExtensionsKt.getRelativePathFromProjectRoot((VirtualFile)notebookVirtualFile.getFile(), (Project)project);
        if (object == null || (object = object.toString()) == null) {
            String string = notebookVirtualFile.getFile().getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        Object relativePath = object;
        JupyterConsoleView jupyterConsoleView = new JupyterConsoleView(project, (String)relativePath, notebookVirtualFile);
        BackedNotebookVirtualFile consoleHistoryFile = jupyterConsoleView.getConsoleNotebookFile();
        VirtualFile consoleInputFile = jupyterConsoleView.getFile().getVirtualFile();
        JupyterConsoleUtil.INSTANCE.setOriginalFile(consoleHistoryFile.getFile(), notebookVirtualFile);
        Intrinsics.checkNotNull((Object)consoleInputFile);
        JupyterConsoleUtil.INSTANCE.setOriginalFile(consoleInputFile, notebookVirtualFile);
        JupyterConsoleUtil.INSTANCE.setConsoleFile(notebookVirtualFile, consoleHistoryFile);
        notebookVirtualFile.putUserData(CONSOLE_VIEW_KEY, (Object)jupyterConsoleView);
        Disposer.register((Disposable)((Disposable)jupyterConsoleView), () -> JupyterConsoleService.createConsoleView$lambda$0(notebookVirtualFile));
        return jupyterConsoleView;
    }

    public final void onDebugStart(@NotNull BackedNotebookVirtualFile originalNotebookFile) {
        Intrinsics.checkNotNullParameter((Object)originalNotebookFile, (String)"originalNotebookFile");
        JupyterConsoleView jupyterConsoleView = this.getConsoleView(originalNotebookFile);
        if (jupyterConsoleView == null) {
            return;
        }
        JupyterConsoleView consoleView = jupyterConsoleView;
        consoleView.onDebugStart();
    }

    public final void onDebugEnd(@NotNull BackedNotebookVirtualFile originalNotebookFile) {
        Intrinsics.checkNotNullParameter((Object)originalNotebookFile, (String)"originalNotebookFile");
        JupyterConsoleView jupyterConsoleView = this.getConsoleView(originalNotebookFile);
        if (jupyterConsoleView == null) {
            return;
        }
        JupyterConsoleView consoleView = jupyterConsoleView;
        consoleView.onDebugEnd();
    }

    private static final void _init_$lambda$0(JupyterConsoleService this$0, NotebookFileRenamedEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.handleConsoleRename(it);
    }

    private static final void showAndFocusConsoleView$lambda$0(ToolWindow $jupyterToolWindow, JupyterConsoleView $consoleView) {
        $jupyterToolWindow.getContentManager().setSelectedContent($consoleView.getContent());
        IdeFocusManager.getGlobalInstance().requestFocus((Component)$consoleView.getConsoleEditor().getContentComponent(), true);
    }

    private static final void createConsoleView$lambda$0(BackedNotebookVirtualFile $notebookVirtualFile) {
        JupyterConsoleUtil.INSTANCE.setConsoleFile($notebookVirtualFile, null);
        $notebookVirtualFile.putUserData(CONSOLE_VIEW_KEY, null);
    }

    public static final /* synthetic */ void access$setToolWindowListenersInit$p(JupyterConsoleService $this, boolean bl) {
        $this.isToolWindowListenersInit = bl;
    }

    static {
        Key key = Key.create((String)"CONSOLE_VIEW_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CONSOLE_VIEW_KEY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleService$Companion;", "", "<init>", "()V", "CONSOLE_VIEW_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "getCONSOLE_VIEW_KEY", "()Lcom/intellij/openapi/util/Key;", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<JupyterConsoleView> getCONSOLE_VIEW_KEY() {
            return CONSOLE_VIEW_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

