/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.chrome.wip.EventLoopGroupProviderKt;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.PageConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnection;
import com.jetbrains.debugger.wip.WipRemoteVmConnectionKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.util.NetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.RemoteVmConnectionKt;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.io.NettyUtil;
import org.jetbrains.io.SimpleChannelInboundHandlerAdapter;
import org.jetbrains.io.webSocket.WebSocketProtocolHandler;
import org.jetbrains.io.webSocket.WebSocketProtocolHandshakeHandler;
import org.jetbrains.jsonProtocol.EventType;
import org.jetbrains.wip.BrowserWipVm;
import org.jetbrains.wip.LoggingKt;
import org.jetbrains.wip.MessagingLogger;
import org.jetbrains.wip.NodeWipVm;
import org.jetbrains.wip.StandaloneWipVm;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.inspector.DetachedEventData;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001:B\u001f\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0004J&\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0004J\u0018\u0010 \u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0014J.\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J\u0018\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020&H\u0002J#\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b/J6\u00100\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u00101\u001a\u0004\u0018\u00010*2\f\u00102\u001a\b\u0012\u0004\u0012\u00020.032\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0014J\"\u00104\u001a\u0002052\u0006\u00106\u001a\u00020.2\u0006\u00107\u001a\u0002082\b\u00101\u001a\u0004\u0018\u00010*H\u0014J0\u00109\u001a\u00020\u001a2\u0006\u00106\u001a\u00020.2\u0006\u0010\u001e\u001a\u00020\u001f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020\u00162\b\u00101\u001a\u0004\u0018\u00010*H\u0014R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\f\"\u0004\b\u000f\u0010\u0010\u00a8\u0006;"}, d2={"Lcom/jetbrains/debugger/wip/WipRemoteVmConnection;", "Lorg/jetbrains/debugger/connection/RemoteVmConnection;", "Lorg/jetbrains/wip/WipVm;", "url", "Lcom/intellij/util/Url;", "debugLogSuffix", "", "<init>", "(Lcom/intellij/util/Url;Ljava/lang/String;)V", "getUrl", "()Lcom/intellij/util/Url;", "getDebugLogSuffix", "()Ljava/lang/String;", "currentPageTitle", "getCurrentPageTitle", "setCurrentPageTitle", "(Ljava/lang/String;)V", "createBootstrap", "Lio/netty/bootstrap/Bootstrap;", "address", "Ljava/net/InetSocketAddress;", "vmResult", "Lorg/jetbrains/concurrency/AsyncPromise;", "createChannelHandler", "Lio/netty/channel/ChannelHandler;", "handleExceptionOnGettingWebSockets", "", "e", "", "sendGetJson", "context", "Lio/netty/channel/ChannelHandlerContext;", "connectedAddressToPresentation", "vm", "Lorg/jetbrains/debugger/Vm;", "connectToPage", "", "connectionsJson", "Lio/netty/buffer/ByteBuf;", "result", "logAvailableTargets", "logger", "Lorg/jetbrains/wip/MessagingLogger;", "byteBuf", "readPageConnections", "Lcom/intellij/util/SmartList;", "Lcom/jetbrains/debugger/wip/PageConnection;", "readPageConnections$intellij_javascript_debugger_backend", "processPageConnections", "debugMessageQueue", "pageConnections", "", "createVm", "Lorg/jetbrains/wip/StandaloneWipVm;", "page", "channel", "Lio/netty/channel/Channel;", "connectDebugger", "Companion", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nWipRemoteVmConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WipRemoteVmConnection.kt\ncom/jetbrains/debugger/wip/WipRemoteVmConnection\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,281:1\n39#2,6:282\n66#2,2:288\n66#2,2:291\n1#3:290\n*S KotlinDebug\n*F\n+ 1 WipRemoteVmConnection.kt\ncom/jetbrains/debugger/wip/WipRemoteVmConnection\n*L\n57#1:282,6\n108#1:288,2\n271#1:291,2\n*E\n"})
public class WipRemoteVmConnection
extends RemoteVmConnection<WipVm> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Url url;
    @Nullable
    private final String debugLogSuffix;
    @Nullable
    private String currentPageTitle;
    @NotNull
    private static final Lazy<EventLoopGroup> eventGroup$delegate = LazyKt.lazy(WipRemoteVmConnection::eventGroup_delegate$lambda$0);

    public WipRemoteVmConnection(@Nullable Url url, @Nullable String debugLogSuffix) {
        this.url = url;
        this.debugLogSuffix = debugLogSuffix;
    }

    public /* synthetic */ WipRemoteVmConnection(Url url, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            url = null;
        }
        if ((n & 2) != 0) {
            string = null;
        }
        this(url, string);
    }

    @Nullable
    public final Url getUrl() {
        return this.url;
    }

    @Nullable
    public String getDebugLogSuffix() {
        return this.debugLogSuffix;
    }

    @Nullable
    protected final String getCurrentPageTitle() {
        return this.currentPageTitle;
    }

    protected final void setCurrentPageTitle(@Nullable String string) {
        this.currentPageTitle = string;
    }

    @NotNull
    protected Bootstrap createBootstrap() {
        Bootstrap bootstrap2;
        BuiltInServerManager it = BuiltInServerManager.Companion.getInstance();
        boolean bl = false;
        if (it.getServerDisposable() != null) {
            bootstrap2 = it.createClientBootstrap();
        } else {
            Bootstrap bootstrap3 = NettyUtil.nioClientBootstrap((EventLoopGroup)WipRemoteVmConnection.Companion.getEventGroup());
            bootstrap2 = bootstrap3;
            Intrinsics.checkNotNullExpressionValue((Object)bootstrap3, (String)"nioClientBootstrap(...)");
        }
        return bootstrap2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Bootstrap createBootstrap(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        Bootstrap $this$handler$iv = this.createBootstrap();
        boolean $i$f$handler = false;
        $this$handler$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, address, vmResult){
            final /* synthetic */ WipRemoteVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address$inlined;
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.this$0 = wipRemoteVmConnection;
                this.$address$inlined = inetSocketAddress;
                this.$vmResult$inlined = asyncPromise;
            }

            protected void initChannel(Channel channel) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Channel it = channel;
                boolean bl = false;
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(0xA00000), this.this$0.createChannelHandler(this.$address$inlined, (AsyncPromise<WipVm>)this.$vmResult$inlined)};
                it.pipeline().addLast(channelHandlerArray);
            }
        });
        return var3_3;
    }

    @NotNull
    protected ChannelHandler createChannelHandler(@NotNull InetSocketAddress address, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        return (ChannelHandler)new SimpleChannelInboundHandlerAdapter<FullHttpResponse>(this, address, vmResult){
            final /* synthetic */ WipRemoteVmConnection this$0;
            final /* synthetic */ InetSocketAddress $address;
            final /* synthetic */ AsyncPromise<WipVm> $vmResult;
            {
                this.this$0 = $receiver;
                this.$address = $address;
                this.$vmResult = $vmResult;
            }

            public void channelActive(ChannelHandlerContext context) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                super.channelActive(context);
                this.this$0.sendGetJson(this.$address, context, this.$vmResult);
            }

            protected void messageReceived(ChannelHandlerContext context, FullHttpResponse message) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                try {
                    context.pipeline().remove((ChannelHandler)this);
                    ByteBuf byteBuf = message.content();
                    Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"content(...)");
                    this.this$0.connectToPage(context, this.$address, byteBuf, this.$vmResult);
                }
                catch (Throwable e) {
                    this.this$0.handleExceptionOnGettingWebSockets(e, this.$vmResult);
                }
            }

            public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.$vmResult.setError(cause);
                context.close();
            }
        };
    }

    protected final void handleExceptionOnGettingWebSockets(@NotNull Throwable e, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        if (e instanceof MalformedJsonException) {
            String host;
            String string = JSDebuggerBundle.message("error.websocket.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object message = string;
            InetSocketAddress inetSocketAddress = this.getAddress();
            HttpInetSocketAddress httpInetSocketAddress = inetSocketAddress instanceof HttpInetSocketAddress ? (HttpInetSocketAddress)inetSocketAddress : null;
            String string2 = host = httpInetSocketAddress != null ? httpInetSocketAddress.getOriginalHostName() : null;
            if (!(host == null || NetUtil.isValidIpV4Address((String)host) || NetUtil.isValidIpV6Address((String)host) || Intrinsics.areEqual((Object)host, (Object)"localhost") || Intrinsics.areEqual((Object)host, (Object)"localhost6"))) {
                message = (String)message + "\n\n" + JSDebuggerBundle.message("error.websocket.nodejs.message", new Object[0]);
            }
            v3 = vmResult.setError((String)message);
        } else {
            v3 = vmResult.setError(e);
        }
    }

    protected final void sendGetJson(@NotNull InetSocketAddress address, @NotNull ChannelHandlerContext context, @NotNull AsyncPromise<WipVm> vmResult) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(vmResult, (String)"vmResult");
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/json");
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)WipRemoteVmConnectionKt.toHttpHeaderHostField(address));
        request.headers().set((CharSequence)HttpHeaderNames.ACCEPT, (Object)"*/*");
        ChannelFuture channelFuture = context.channel().writeAndFlush((Object)request);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"writeAndFlush(...)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(vmResult){
            final /* synthetic */ AsyncPromise $vmResult$inlined;
            {
                this.$vmResult$inlined = asyncPromise;
            }

            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                ChannelFuture it2 = it;
                boolean bl = false;
                if (!it2.isSuccess()) {
                    Throwable throwable = it2.cause();
                    Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"cause(...)");
                    this.$vmResult$inlined.setError(throwable);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected String connectedAddressToPresentation(@NotNull InetSocketAddress address, @NotNull Vm vm) {
        Object object;
        String string;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)address, (String)"address");
                Intrinsics.checkNotNullParameter((Object)vm, (String)"vm");
                string = super.connectedAddressToPresentation(address, vm);
                object = this.currentPageTitle;
                if (object == null) break block2;
                String string2 = object;
                String string3 = string;
                boolean bl = false;
                String string4 = " \u2013 " + (String)it;
                string = string3;
                object = string4;
                if (string4 != null) break block3;
            }
            object = "";
        }
        return string + (String)object;
    }

    protected boolean connectToPage(@NotNull ChannelHandlerContext context, @NotNull InetSocketAddress address, @NotNull ByteBuf connectionsJson, @NotNull AsyncPromise<WipVm> result) {
        MessagingLogger debugMessageQueue;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)connectionsJson, (String)"connectionsJson");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        String string = this.getDebugLogSuffix();
        if (string == null) {
            string = "";
        }
        MessagingLogger messagingLogger = debugMessageQueue = LoggingKt.createDebugLogger((String)"js.debugger.wip.log", (String)string);
        if (messagingLogger != null) {
            MessagingLogger logger = messagingLogger;
            boolean bl = false;
            this.logAvailableTargets(logger, connectionsJson);
            result.onError(arg_0 -> WipRemoteVmConnection.connectToPage$lambda$0$1(arg_0 -> WipRemoteVmConnection.connectToPage$lambda$0$0(logger, arg_0), arg_0));
        }
        if (!connectionsJson.isReadable()) {
            String string2 = JSDebuggerBundle.message("error.websocket.malformed.message", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            result.setError(string2);
            return true;
        }
        SmartList<PageConnection> pageConnections = this.readPageConnections$intellij_javascript_debugger_backend(connectionsJson, address);
        return !this.processPageConnections(context, debugMessageQueue, (List)pageConnections, result);
    }

    private final void logAvailableTargets(MessagingLogger logger, ByteBuf byteBuf) {
        CharSequence charSequence = byteBuf.getCharSequence(byteBuf.readerIndex(), byteBuf.readableBytes(), Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharSequence(...)");
        CharSequence charSequence2 = charSequence;
        Regex regex = new Regex("[\n\r]");
        String string = "";
        String jsonWithoutLineBreaks = regex.replace(charSequence2, string);
        logger.add((CharSequence)("{\"method\":\"TargetsList\", \"params\": " + jsonWithoutLineBreaks + "}"), "IN");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public final SmartList<PageConnection> readPageConnections$intellij_javascript_debugger_backend(@NotNull ByteBuf connectionsJson, @NotNull InetSocketAddress address) {
        Intrinsics.checkNotNullParameter((Object)connectionsJson, (String)"connectionsJson");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        pageConnections = new SmartList();
        var4_4 /* !! */  = (InputStream)new ByteBufInputStream(connectionsJson);
        var5_5 = Charsets.UTF_8;
        var4_4 /* !! */  = (Closeable)new JsonReader((Reader)new InputStreamReader(var4_4 /* !! */ , (Charset)var5_5));
        var5_5 = null;
        try {
            reader = (JsonReader)var4_4 /* !! */ ;
            $i$a$-use-WipRemoteVmConnection$readPageConnections$1 = false;
            if (reader.peek() == JsonToken.BEGIN_ARRAY) {
                reader.beginArray();
            }
            while (reader.hasNext() && reader.peek() != JsonToken.END_DOCUMENT) {
                reader.beginObject();
                pageUrl = null;
                webSocketDebuggerUrl = null;
                title = null;
                type = null;
                id = null;
                block13: while (reader.hasNext()) {
                    block19: {
                        block20: {
                            block22: {
                                block21: {
                                    var13_15 = reader.nextName();
                                    if (var13_15 == null) break block19;
                                    switch (var13_15.hashCode()) {
                                        case 3355: {
                                            if (!var13_15.equals("id")) {
                                                ** break;
                                            }
                                            break block20;
                                        }
                                        case 110371416: {
                                            if (var13_15.equals("title")) break;
                                            ** break;
                                        }
                                        case 3575610: {
                                            if (!var13_15.equals("type")) {
                                                ** break;
                                            }
                                            break block21;
                                        }
                                        case -346402009: {
                                            if (!var13_15.equals("webSocketDebuggerUrl")) {
                                                ** break;
                                            }
                                            break block22;
                                        }
                                        case 116079: {
                                            if (!var13_15.equals("url")) ** break;
                                            pageUrl = reader.nextString();
                                            continue block13;
                                        }
                                    }
                                    title = reader.nextString();
                                    continue;
                                }
                                type = reader.nextString();
                                continue;
                            }
                            webSocketDebuggerUrl = reader.nextString();
                            continue;
                        }
                        id = reader.nextString();
                        continue;
                    }
                    reader.skipValue();
                }
                reader.endObject();
                pageConnections.add((Object)new PageConnection(pageUrl, title, type, webSocketDebuggerUrl, id, address));
            }
            var6_6 = Unit.INSTANCE;
        }
        catch (Throwable var7_8) {
            var5_5 = var7_8;
            throw var7_8;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_4 /* !! */ , (Throwable)var5_5);
        }
        return pageConnections;
    }

    protected boolean processPageConnections(@NotNull ChannelHandlerContext context, @Nullable MessagingLogger debugMessageQueue, @NotNull List<PageConnection> pageConnections, @NotNull AsyncPromise<WipVm> result) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(pageConnections, (String)"pageConnections");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        SmartList debuggablePages = new SmartList();
        for (PageConnection p : pageConnections) {
            if (this.url == null) {
                debuggablePages.add((Object)p);
                continue;
            }
            String string = p.getUrl();
            Intrinsics.checkNotNull((Object)string);
            if (!Urls.INSTANCE.equals(this.url, Urls.newFromEncoded((String)string), SystemInfo.isFileSystemCaseSensitive, true)) continue;
            this.connectDebugger(p, context, result, debugMessageQueue);
            return true;
        }
        if (this.url == null) {
            Promise promise = RemoteVmConnectionKt.chooseDebuggee((Collection)((Collection)debuggablePages), (int)-1, WipRemoteVmConnection::processPageConnections$lambda$0).onSuccess(arg_0 -> WipRemoteVmConnection.processPageConnections$lambda$2(arg_0 -> WipRemoteVmConnection.processPageConnections$lambda$1(result, this, context, debugMessageQueue, arg_0), arg_0)).onError(arg_0 -> WipRemoteVmConnection.processPageConnections$lambda$4(arg_0 -> WipRemoteVmConnection.processPageConnections$lambda$3(result, arg_0), arg_0));
            Intrinsics.checkNotNull((Object)promise);
        } else {
            Object[] objectArray = new Object[]{this.url};
            String string = JSDebuggerBundle.message("error.connection.no.page", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            result.setError(string);
        }
        return true;
    }

    @NotNull
    protected StandaloneWipVm createVm(@NotNull PageConnection page, @NotNull Channel channel, @Nullable MessagingLogger debugMessageQueue) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        return Intrinsics.areEqual((Object)page.getType(), (Object)"node") ? (StandaloneWipVm)new NodeWipVm(this.getDebugEventListener(), page.getUrl(), channel, debugMessageQueue) : (StandaloneWipVm)new BrowserWipVm(this.getDebugEventListener(), page.getUrl(), channel, debugMessageQueue);
    }

    protected void connectDebugger(@NotNull PageConnection page, @NotNull ChannelHandlerContext context, @NotNull AsyncPromise<WipVm> result, @Nullable MessagingLogger debugMessageQueue) {
        Intrinsics.checkNotNullParameter((Object)page, (String)"page");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(result, (String)"result");
        String string = page.getWebSocketDebuggerUrl();
        Intrinsics.checkNotNull((Object)string);
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)URI.create(string), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, null, (int)NettyUtil.MAX_CONTENT_LENGTH, (boolean)true, (boolean)false, (long)-1L, (boolean)false, (boolean)false);
        Channel channel = context.channel();
        Intrinsics.checkNotNull((Object)channel);
        StandaloneWipVm vm = this.createVm(page, channel, debugMessageQueue);
        vm.setTitle(page.getTitle());
        vm.getCommandProcessor().getEventMap().add((EventType)DetachedEventData.TYPE, arg_0 -> WipRemoteVmConnection.connectDebugger$lambda$0(this, arg_0));
        ChannelHandler[] channelHandlerArray = new ChannelHandler[]{new WebSocketProtocolHandshakeHandler(handshaker, vm, result){
            final /* synthetic */ StandaloneWipVm $vm;
            final /* synthetic */ AsyncPromise<WipVm> $result;
            {
                this.$vm = $vm;
                this.$result = $result;
                Intrinsics.checkNotNull((Object)$handshaker);
                super($handshaker);
            }

            protected void completed() {
                this.$vm.initDomains().then(arg_0 -> connectDebugger.2.completed$lambda$1(arg_0 -> connectDebugger.2.completed$lambda$0(this.$result, this.$vm, arg_0), arg_0));
            }

            public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.$result.setError(cause);
                context.fireExceptionCaught(cause);
            }

            private static final Promise completed$lambda$0(AsyncPromise $result, StandaloneWipVm $vm, Object it) {
                $result.setResult((Object)$vm);
                return $vm.ready();
            }

            private static final Promise completed$lambda$1(Function1 $tmp0, Object p0) {
                return (Promise)$tmp0.invoke(p0);
            }
        }, new WebSocketFrameAggregator(NettyUtil.MAX_CONTENT_LENGTH), new WebSocketProtocolHandler(vm){
            final /* synthetic */ StandaloneWipVm $vm;
            {
                this.$vm = $vm;
            }

            protected void textFrameReceived(Channel channel, TextWebSocketFrame message) {
                Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                this.$vm.textFrameReceived(message);
            }
        }};
        channel.pipeline().addLast(channelHandlerArray);
        ChannelFuture channelFuture = handshaker.handshake(channel);
        Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"handshake(...)");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener(new GenericFutureListener(context){
            final /* synthetic */ ChannelHandlerContext $context$inlined;
            {
                this.$context$inlined = channelHandlerContext;
            }

            public final void operationComplete(ChannelFuture it) {
                Intrinsics.checkNotNull((Object)it);
                ChannelFuture it2 = it;
                boolean bl = false;
                if (!it2.isSuccess()) {
                    this.$context$inlined.fireExceptionCaught(it2.cause());
                }
            }
        });
    }

    private static final Unit connectToPage$lambda$0$0(MessagingLogger $logger, Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $logger.add((CharSequence)("\"" + it + "\""), "Error");
        $logger.close();
        return Unit.INSTANCE;
    }

    private static final void connectToPage$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit processPageConnections$lambda$0(PageConnection item, ColoredListCellRenderer renderer) {
        String itemUrl;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        String string = itemUrl = item.getUrl();
        Object tail = string != null ? "(" + string + ")" : "";
        renderer.append(item.getTitle() + " " + (String)tail, item.getWebSocketDebuggerUrl() == null ? SimpleTextAttributes.GRAYED_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        return Unit.INSTANCE;
    }

    private static final Unit processPageConnections$lambda$1(AsyncPromise $result, WipRemoteVmConnection this$0, ChannelHandlerContext $context, MessagingLogger $debugMessageQueue, PageConnection it) {
        String webSocketDebuggerUrl = it.getWebSocketDebuggerUrl();
        if (webSocketDebuggerUrl == null) {
            String string = JSDebuggerBundle.message("js.debug.another.debugger.attached", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            $result.setError(string);
            return Unit.INSTANCE;
        }
        this$0.currentPageTitle = it.getTitle();
        Intrinsics.checkNotNull((Object)it);
        this$0.connectDebugger(it, $context, (AsyncPromise<WipVm>)$result, $debugMessageQueue);
        return Unit.INSTANCE;
    }

    private static final void processPageConnections$lambda$2(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit processPageConnections$lambda$3(AsyncPromise $result, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        $result.setError(it);
        return Unit.INSTANCE;
    }

    private static final void processPageConnections$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit connectDebugger$lambda$0(WipRemoteVmConnection this$0, DetachedEventData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it.reason(), (Object)"targetCrashed")) {
            this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab crashed)", ConnectionStatus.DISCONNECTED);
        } else {
            this$0.close(ConnectionStatus.DISCONNECTED.getStatusText() + " (tab was closed or Web Inspector was opened)", ConnectionStatus.DETACHED);
        }
        return Unit.INSTANCE;
    }

    private static final EventLoopGroup eventGroup_delegate$lambda$0() {
        return EventLoopGroupProviderKt.createEventLoopGroup("WipRemoteVmConnection");
    }

    public WipRemoteVmConnection() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/jetbrains/debugger/wip/WipRemoteVmConnection$Companion;", "", "<init>", "()V", "eventGroup", "Lio/netty/channel/EventLoopGroup;", "getEventGroup", "()Lio/netty/channel/EventLoopGroup;", "eventGroup$delegate", "Lkotlin/Lazy;", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        private final EventLoopGroup getEventGroup() {
            Lazy lazy = eventGroup$delegate;
            return (EventLoopGroup)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

