/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.plan;

import com.google.common.collect.ImmutableSet;
import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.postgres.plan.PgRawPlanData;
import com.intellij.database.dialects.postgresbase.plan.PgBasePlanModelBuilder;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgPlanModelBuilder
extends AbstractPlanModelBuilder<PgRawPlanData, JSONObject> {
    private static final Map<String, PlanModel.NodeType> MODIFICATION_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final Set<String> HANDLED_KEYS = ImmutableSet.of((Object)"Plans", (Object)"Startup Cost", (Object)"Total Cost", (Object)"Plan Rows", (Object)"Relation Name", (Object)"CTE Name", (Object[])new String[]{"Index Name", "Node Type", "Actual Startup Time", "Actual Total Time", "Actual Rows", "Plan"});

    public PgPlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @NotNull
    public PgRawPlanData createData() {
        return new PgRawPlanData();
    }

    protected void parseData() {
        this.parseRoot(((PgRawPlanData)this.myData).json);
    }

    private void parseRoot(@NotNull String json) throws PlanRetrievalException {
        JSONArray data;
        if (json == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(0);
        }
        try {
            data = new JSONArray(json);
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned invalid JSON", (Throwable)e);
        }
        if (data.length() == 0) {
            throw new PlanRetrievalException("Database returned empty plan");
        }
        if (data.length() > 1) {
            throw new PlanRetrievalException("Database returned multiple plans");
        }
        try {
            this.openNode(null);
            this.parseStatement(data.getJSONObject(0));
            this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
        }
        catch (JSONException e) {
            throw new PlanRetrievalException("Database returned plan in unknown format", (Throwable)e);
        }
    }

    @NotNull
    protected String parseRawDescription(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(1);
        }
        StringBuilder desc = new StringBuilder();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String str;
            String key = (String)it.next();
            if (HANDLED_KEYS.contains(key) || (str = object.optString(key, null)) == null) continue;
            desc.append(key).append(" = ").append(str).append(";\n");
        }
        String string = desc.toString();
        if (string == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    protected String parseAccessRelation(@NotNull JSONObject object) {
        String rel;
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(3);
        }
        if ((rel = object.optString("Relation Name", null)) == null) {
            rel = object.optString("CTE Name", null);
        }
        return rel;
    }

    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(4);
        }
        return PgPlanModelBuilder.optBig((JSONObject)object, (String)"Plan Rows", null);
    }

    @Nullable
    protected BigDecimal parseActualNumRows(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(5);
        }
        return PgPlanModelBuilder.optBig((JSONObject)object, (String)"Actual Rows", null);
    }

    @Nullable
    protected String parseAccessIndex(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(6);
        }
        return object.optString("Index Name", null);
    }

    private static int getNumSubPlans(@Nullable JSONObject object) {
        JSONArray plans = PgPlanModelBuilder.getSubPlans(object);
        return plans == null ? 0 : plans.length();
    }

    @Nullable
    private static JSONArray getSubPlans(@Nullable JSONObject object) {
        return object == null ? null : object.optJSONArray("Plans");
    }

    @Nullable
    private static String getNodeType(@Nullable JSONObject object) {
        return object == null ? null : object.optString("Node Type");
    }

    protected void parseSubPlans(@NotNull JSONObject object) {
        JSONArray plans;
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(7);
        }
        if ((plans = PgPlanModelBuilder.getSubPlans(object)) != null) {
            JSONObject subPlan;
            if (plans.length() == 1 && "Append".equals(PgPlanModelBuilder.getNodeType(subPlan = plans.optJSONObject(0)))) {
                this.parseSubPlans(subPlan);
                return;
            }
            for (int i = 0; i < plans.length(); ++i) {
                JSONObject subPlan2 = plans.optJSONObject(i);
                if (subPlan2 == null) {
                    this.unsupportedFormat();
                }
                this.parsePlan(subPlan2);
            }
        }
    }

    protected void parseStatement(@NotNull JSONObject root) {
        if (root == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(8);
        }
        this.openNode(null);
        JSONObject object = root.optJSONObject("Plan");
        if (object == null) {
            this.unsupportedFormat("No root plan");
        }
        this.myActual = root.optString("Execution Time", null) != null || root.optString("Total Runtime", null) != null;
        String nodeType = object.optString("Node Type");
        PlanModel.NodeType type = PlanModel.NodeType.SELECT;
        if (nodeType.equals("ModifyTable")) {
            type = MODIFICATION_MAPPING.get(object.optString("Operation"));
            if (type == null) {
                type = PlanModel.NodeType.STATEMENT;
            }
            this.parseSubPlans(object);
        } else {
            this.parsePlan(object);
        }
        this.closeNode(this.createNode(root, type, type == PlanModel.NodeType.STATEMENT ? nodeType : null));
    }

    @Nullable
    protected Double parseTotalCost(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(9);
        }
        return PgPlanModelBuilder.optDouble((JSONObject)object, (String)"Total Cost", null);
    }

    @Nullable
    protected Double parseActualTotalTime(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(10);
        }
        return PgPlanModelBuilder.optDouble((JSONObject)object, (String)"Actual Total Time", null);
    }

    @Nullable
    protected Double parseStartupCost(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(11);
        }
        return PgPlanModelBuilder.optDouble((JSONObject)object, (String)"Startup Cost", null);
    }

    @Nullable
    protected Double parseActualStartupTime(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(12);
        }
        return PgPlanModelBuilder.optDouble((JSONObject)object, (String)"Actual Startup Time", null);
    }

    protected boolean parseSubqueryCorrelated(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(13);
        }
        return false;
    }

    protected boolean parseSubqueryScalar(@NotNull JSONObject object) {
        if (object == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(14);
        }
        return false;
    }

    protected void parsePlan(@NotNull JSONObject state) {
        if (state == null) {
            PgPlanModelBuilder.$$$reportNull$$$0(15);
        }
        if (PgPlanModelBuilder.getNumSubPlans(state) == 1 && "Result".equals(PgPlanModelBuilder.getNodeType(state))) {
            this.parseSubPlans(state);
            return;
        }
        this.openNode(null);
        this.parseSubPlans(state);
        String nodeType = state.optString("Node Type");
        PlanModel.NodeType type = (PlanModel.NodeType)PgBasePlanModelBuilder.TYPE_MAPPING.get(nodeType);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        if (type == PlanModel.NodeType.SET_OP) {
            String com = state.optString("Command");
            if ("Intersect".equals(com)) {
                type = PlanModel.NodeType.INTERSECT;
            } else if ("Except".equals(com)) {
                type = PlanModel.NodeType.EXCEPT;
            }
        }
        PlanModel.GenericNode node = this.createNode(state, type, nodeType);
        this.closeNode(node);
    }

    static {
        MODIFICATION_MAPPING.put("Insert", PlanModel.NodeType.INSERT);
        MODIFICATION_MAPPING.put("Update", PlanModel.NodeType.UPDATE);
        MODIFICATION_MAPPING.put("Delete", PlanModel.NodeType.DELETE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgres/plan/PgPlanModelBuilder";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgres/plan/PgPlanModelBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "parseRawDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRoot";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseActualNumRows";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseActualTotalTime";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseActualStartupTime";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

