/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.engine;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.engine.JpaConsoleRunContext;
import com.intellij.jpa.jpb.model.core.notifydialog.HNotificationManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistencePackagePointer;
import com.intellij.platform.eel.EelDescriptor;
import com.intellij.platform.eel.provider.EelProviderUtil;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a8\u0006\b"}, d2={"getTempDirectory", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "canRunPersistenceConsole", "", "unit", "Lcom/intellij/persistence/model/PersistencePackagePointer;", "intellij.javaee.jpa.impl"})
public final class EelJpaHelperKt {
    @NotNull
    public static final Path getTempDirectory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EelDescriptor descriptor = EelProviderUtil.getEelDescriptor((Project)project);
        Path path = (descriptor instanceof LocalEelDescriptor ? ProjectUtil.getProjectCachePath$default((Project)project, (String)"compiler", (boolean)false, null, (int)6, null) : EelPathUtils.getSystemFolder((Project)project).resolve("compiler")).resolve(ProjectUtil.getProjectCacheFileName$default((Project)project, (boolean)false, null, (String)"", (int)2, null)).resolve(".generated").resolve("Jpa_Console");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return path;
    }

    public static final boolean canRunPersistenceConsole(@NotNull Project project, @NotNull PersistencePackagePointer unit) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        PersistencePackage persistencePackage = unit.findElement();
        if (persistencePackage == null) {
            return false;
        }
        PersistencePackage foundUnit = persistencePackage;
        LocalDataSource ds = JpaConsoleRunContext.getDataSource(foundUnit, unit.getPersistenceFacet(), project);
        if (!(EelProviderUtil.getEelDescriptor((Project)project) instanceof LocalEelDescriptor)) {
            boolean bl;
            DatabaseArtifactContext context;
            DatabaseArtifactContext databaseArtifactContext = context = ds == null ? (DatabaseArtifactContext)project.getService(DatabaseArtifactContext.class) : DatabaseArtifactContext.Companion.getInstance(project, ds);
            if (!context.useEel()) {
                HNotificationManager.showNotification_((String)JpaMessages.message("jpa.datasource.error", new Object[0]), (NotificationType)NotificationType.ERROR);
                bl = false;
            } else {
                bl = true;
            }
            return bl;
        }
        return true;
    }
}

