/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.dom.converters;

import com.intellij.spring.messaging.dom.jms.Listener;
import com.intellij.spring.model.converters.SpringBeanResolveConverterForDefiniteClasses;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JmsListenerResolveConverter
extends SpringBeanResolveConverterForDefiniteClasses {
    @NonNls
    public static final String JAVAX_MESSAGE_LISTENER = "javax.jms.MessageListener";
    @NonNls
    public static final String JAKARTA_MESSAGE_LISTENER = "jakarta.jms.MessageListener";
    @NonNls
    public static final String SESSION_AWARE_LISTENER = "org.springframework.jms.listener.SessionAwareMessageListener";

    protected String @NotNull [] getClassNames(ConvertContext context) {
        Listener listener = (Listener)DomUtil.getParentOfType((DomElement)context.getInvocationElement(), Listener.class, (boolean)false);
        if (listener != null && DomUtil.hasXml(listener.getMethod())) {
            String[] stringArray = new String[]{"java.lang.Object"};
            if (stringArray == null) {
                JmsListenerResolveConverter.$$$reportNull$$$0(0);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{JAVAX_MESSAGE_LISTENER, JAKARTA_MESSAGE_LISTENER, SESSION_AWARE_LISTENER};
        if (stringArray == null) {
            JmsListenerResolveConverter.$$$reportNull$$$0(1);
        }
        return stringArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/messaging/dom/converters/JmsListenerResolveConverter", "getClassNames"));
    }
}

