/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.postcss.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.inspections.fixes.CssAddPrefixQuickFix;
import org.intellij.plugins.postcss.PostCssBundle;
import org.intellij.plugins.postcss.inspections.PostCssBaseInspection;
import org.intellij.plugins.postcss.psi.PostCssCustomMedia;
import org.intellij.plugins.postcss.psi.PostCssCustomMediaAtRule;
import org.intellij.plugins.postcss.psi.impl.PostCssCustomMediaAtRuleImpl;
import org.intellij.plugins.postcss.psi.impl.PostCssElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PostCssCustomMediaInspection
extends PostCssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PostCssCustomMediaInspection.$$$reportNull$$$0(0);
        }
        return new PostCssElementVisitor(this){

            @Override
            public void visitPostCssCustomMediaAtRule(PostCssCustomMediaAtRuleImpl postCssCustomMediaAtRule) {
                PostCssCustomMedia customMedia = postCssCustomMediaAtRule.getCustomMedia();
                if (customMedia == null) {
                    return;
                }
                String text = customMedia.getText();
                if (text.equals("--")) {
                    holder.registerProblem((PsiElement)customMedia, PostCssBundle.message("annotator.custom.media.name.should.not.be.empty", new Object[0]), new LocalQuickFix[0]);
                } else if (!StringUtil.startsWith((CharSequence)text, (CharSequence)"--")) {
                    String description = PostCssBundle.message("annotator.custom.media.name.should.start.with", new Object[0]);
                    TextRange textRange = TextRange.from((int)customMedia.getStartOffsetInParent(), (int)customMedia.getTextLength());
                    CssAddPrefixQuickFix quickFix = new CssAddPrefixQuickFix("--", PostCssCustomMediaAtRule.class, PostCssBundle.message("annotator.add.prefix.to.custom.media.quickfix.name", new Object[0]));
                    ProblemDescriptor problemDescriptor = holder.getManager().createProblemDescriptor((PsiElement)postCssCustomMediaAtRule, textRange, description, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, true, new LocalQuickFix[]{quickFix});
                    holder.registerProblem(problemDescriptor);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/plugins/postcss/inspections/PostCssCustomMediaInspection", "buildVisitor"));
    }
}

