/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.diff;

import java.util.Optional;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;

public class MissingTableChangeGenerator
extends liquibase.diff.output.changelog.core.MissingTableChangeGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (Table.class.isAssignableFrom(objectType)) {
            return 50;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        MissingTableChangeGenerator.checkColumnType(missingObject);
        if (missingObject instanceof Table) {
            Table table = (Table)missingObject;
            if (referenceDatabase instanceof IntellijDatabase && Optional.ofNullable(table.getSchema()).map(Schema::getName).map(it -> it.equalsIgnoreCase(comparisonDatabase.getDefaultSchemaName())).orElse(false).booleanValue()) {
                table.setSchema(new Schema(referenceDatabase.getDefaultCatalogName(), null).setDefault(Boolean.valueOf(true)));
            }
        }
        return super.fixMissing(missingObject, control, referenceDatabase, comparisonDatabase, chain);
    }

    private static void checkColumnType(DatabaseObject object) {
        if (!(object instanceof Table)) {
            return;
        }
        Table table = (Table)object;
        if (table.getSnapshotId() == null) {
            return;
        }
        for (Column column : table.getColumns()) {
            if (column.getType() != null) continue;
            throw new IllegalStateException("The column type is undefined. Table - " + table.getName() + "; Column - " + column.getName());
        }
    }
}

