/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.micronaut.el.highlighting;

import com.intellij.javaee.el.psi.ELVariable;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.micronaut.el.highlighting.MnELHighlighter;
import com.intellij.micronaut.el.psi.MnELParameterList;
import com.intellij.micronaut.el.psi.MnELPropertyReference;
import com.intellij.micronaut.el.psi.MnELQualifiedType;
import com.intellij.micronaut.el.psi.MnELSelectExpression;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

final class MnELHighlightingAnnotator
implements Annotator {
    private final boolean DEBUG_MODE = ApplicationManager.getApplication().isUnitTestMode();

    MnELHighlightingAnnotator() {
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            MnELHighlightingAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            MnELHighlightingAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof MnELQualifiedType) {
            this.doAnnotate(holder, element, MnELHighlighter.MN_EL_QUALIFIED_TYPE);
        }
        if (element instanceof MnELPropertyReference) {
            this.doAnnotate(holder, element, MnELHighlighter.MN_EL_PROPERTY_KEY);
        }
        if (element instanceof MnELSelectExpression) {
            MnELSelectExpression selectExpression = (MnELSelectExpression)element;
            ELVariable variable = selectExpression.getField();
            if (variable == null) {
                return;
            }
            PsiReference reference = variable.getReference();
            if (reference == null) {
                return;
            }
            if (element.getNextSibling() instanceof MnELParameterList) {
                this.doAnnotate(holder, (PsiElement)variable, MnELHighlighter.MN_EL_METHOD_CALL);
                return;
            }
            String name = variable.getName();
            if (StringUtil.containsAlphaCharacters((String)name) && name.toUpperCase(Locale.ROOT).equals(name)) {
                this.doAnnotate(holder, (PsiElement)variable, MnELHighlighter.MN_EL_STATIC_FIELD);
            }
        }
    }

    private void doAnnotate(AnnotationHolder holder, PsiElement element, TextAttributesKey key) {
        (this.DEBUG_MODE ? holder.newAnnotation(HighlightSeverity.INFORMATION, key.getExternalName()) : holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(element).textAttributes(key).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/intellij/micronaut/el/highlighting/MnELHighlightingAnnotator";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

