/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.util.pngj.pixels;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.util.pngj.ArrayUtilsKt;
import org.jetbrains.letsPlot.util.pngj.FilterType;
import org.jetbrains.letsPlot.util.pngj.ImageInfo;
import org.jetbrains.letsPlot.util.pngj.PngjOutputException;
import org.jetbrains.letsPlot.util.pngj.pixels.FiltersPerformance;
import org.jetbrains.letsPlot.util.pngj.pixels.PixelsWriter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0016\u001a\u00020\u0010H\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0014J\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\tJ\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/letsPlot/util/pngj/pixels/PixelsWriterDefault;", "Lorg/jetbrains/letsPlot/util/pngj/pixels/PixelsWriter;", "imgInfo", "Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;", "(Lorg/jetbrains/letsPlot/util/pngj/ImageInfo;)V", "adaptMaxSkip", "", "adaptNextRow", "adaptSkipIncreaseFactor", "", "adaptSkipIncreaseSinceRow", "curfilterType", "Lorg/jetbrains/letsPlot/util/pngj/FilterType;", "filtersPerformance", "Lorg/jetbrains/letsPlot/util/pngj/pixels/FiltersPerformance;", "rowb", "", "rowbfilter", "rowbprev", "decideCurFilterType", "", "filterAndWrite", "getCurentRowb", "initParams", "setFilterWeights", "weights", "", "setPreferenceForNone", "preferenceForNone", "tuneMemory", "m", "plot-api"})
@SourceDebugExtension(value={"SMAP\nPixelsWriterDefault.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PixelsWriterDefault.kt\norg/jetbrains/letsPlot/util/pngj/pixels/PixelsWriterDefault\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,160:1\n1#2:161\n*E\n"})
public final class PixelsWriterDefault
extends PixelsWriter {
    @NotNull
    private byte[] rowb;
    @Nullable
    private byte[] rowbprev;
    @Nullable
    private byte[] rowbfilter;
    @NotNull
    private FiltersPerformance filtersPerformance;
    @Nullable
    private FilterType curfilterType;
    private int adaptMaxSkip;
    private int adaptSkipIncreaseSinceRow;
    private double adaptSkipIncreaseFactor;
    private int adaptNextRow;

    public PixelsWriterDefault(@NotNull ImageInfo imgInfo) {
        Intrinsics.checkNotNullParameter((Object)imgInfo, (String)"imgInfo");
        super(imgInfo);
        this.rowb = ArraysKt.toByteArray((Byte[])new Byte[0]);
        this.filtersPerformance = new FiltersPerformance(imgInfo);
    }

    @Override
    @NotNull
    public byte[] getCurentRowb() {
        if (!this.getInitdone()) {
            this.init();
        }
        return this.rowb;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void initParams() {
        block17: {
            block16: {
                super.initParams();
                if (this.rowb.length < this.getBuflen()) {
                    this.rowb = new byte[this.getBuflen()];
                }
                if (this.rowbfilter == null) break block16;
                Intrinsics.checkNotNull((Object)this.rowbfilter);
                if (this.rowbfilter.length >= this.getBuflen()) break block17;
            }
            this.rowbfilter = new byte[this.getBuflen()];
        }
        if (this.rowbprev == null) ** GOTO lbl-1000
        Intrinsics.checkNotNull((Object)this.rowbprev);
        if (this.rowbprev.length < this.getBuflen()) lbl-1000:
        // 2 sources

        {
            this.rowbprev = new byte[this.getBuflen()];
        } else {
            Intrinsics.checkNotNull((Object)this.rowbprev);
            ArrayUtilsKt.fill(this.rowbprev, (byte)0);
        }
        if (this.getImgInfo().getCols() < 3 && !FilterType.Companion.isValidStandard(this.getFilterType())) {
            this.setFilterType(FilterType.FILTER_DEFAULT);
        }
        if (this.getImgInfo().getRows() < 3 && !FilterType.Companion.isValidStandard(this.getFilterType())) {
            this.setFilterType(FilterType.FILTER_DEFAULT);
        }
        if (this.getImgInfo().getTotalPixels() <= 1024L && !FilterType.Companion.isValidStandard(this.getFilterType())) {
            this.setFilterType(this.getDefaultFilter());
        }
        if (FilterType.Companion.isAdaptive(this.getFilterType())) {
            this.adaptNextRow = 0;
            if (this.getFilterType() == FilterType.FILTER_ADAPTIVE_FAST) {
                this.adaptMaxSkip = 200;
                this.adaptSkipIncreaseSinceRow = 3;
                this.adaptSkipIncreaseFactor = 0.25;
            } else if (this.getFilterType() == FilterType.FILTER_ADAPTIVE_MEDIUM) {
                this.adaptMaxSkip = 8;
                this.adaptSkipIncreaseSinceRow = 32;
                this.adaptSkipIncreaseFactor = 0.0125;
            } else if (this.getFilterType() == FilterType.FILTER_ADAPTIVE_FULL) {
                this.adaptMaxSkip = 0;
                this.adaptSkipIncreaseSinceRow = 128;
                this.adaptSkipIncreaseFactor = 0.008333333333333333;
            } else {
                throw new PngjOutputException("bad filter " + (Object)this.getFilterType());
            }
        }
    }

    @Override
    protected void filterAndWrite(@NotNull byte[] rowb) {
        Intrinsics.checkNotNullParameter((Object)rowb, (String)"rowb");
        if (!Arrays.equals(rowb, this.rowb)) {
            boolean $i$a$-require-PixelsWriterDefault$filterAndWrite$22 = false;
            String $i$a$-require-PixelsWriterDefault$filterAndWrite$22 = "??";
            throw new IllegalArgumentException($i$a$-require-PixelsWriterDefault$filterAndWrite$22.toString());
        }
        this.decideCurFilterType();
        FilterType filterType = this.curfilterType;
        Intrinsics.checkNotNull((Object)((Object)filterType));
        Intrinsics.checkNotNull((Object)this.rowbprev);
        Intrinsics.checkNotNull((Object)this.rowbfilter);
        byte[] filtered = this.filterRowWithFilterType(filterType, rowb, this.rowbprev, this.rowbfilter);
        this.sendToCompressedStream(filtered);
        byte[] aux = this.rowb;
        Intrinsics.checkNotNull((Object)this.rowbprev);
        this.rowb = this.rowbprev;
        this.rowbprev = aux;
    }

    private final void decideCurFilterType() {
        if (FilterType.Companion.isValidStandard(this.getFilterType())) {
            this.curfilterType = this.getFilterType();
        } else if (this.getFilterType() == FilterType.FILTER_PRESERVE) {
            this.curfilterType = FilterType.Companion.getByVal(this.rowb[0]);
        } else if (this.getFilterType() == FilterType.FILTER_CYCLIC) {
            this.curfilterType = FilterType.Companion.getByVal(this.getCurrentRow() % 5);
        } else if (this.getFilterType() == FilterType.FILTER_DEFAULT) {
            this.setFilterType(this.getDefaultFilter());
            this.curfilterType = this.getFilterType();
        } else if (FilterType.Companion.isAdaptive(this.getFilterType())) {
            if (this.getCurrentRow() == this.adaptNextRow) {
                int skip;
                for (FilterType ftype : FilterType.Companion.getAllStandard()) {
                    this.filtersPerformance.updateFromRaw(ftype, this.rowb, this.rowbprev, this.getCurrentRow());
                }
                this.curfilterType = this.filtersPerformance.getPreferred();
                int n = skip = this.getCurrentRow() >= this.adaptSkipIncreaseSinceRow ? (int)Math.rint((double)(this.getCurrentRow() - this.adaptSkipIncreaseSinceRow) * this.adaptSkipIncreaseFactor) : 0;
                if (skip > this.adaptMaxSkip) {
                    skip = this.adaptMaxSkip;
                }
                if (this.getCurrentRow() == 0) {
                    skip = 0;
                }
                this.adaptNextRow = this.getCurrentRow() + 1 + skip;
            }
        } else {
            throw new PngjOutputException("not implemented filter: " + (Object)((Object)this.getFilterType()));
        }
        if (this.getCurrentRow() == 0 && this.curfilterType != FilterType.FILTER_NONE && this.curfilterType != FilterType.FILTER_SUB) {
            this.curfilterType = FilterType.FILTER_SUB;
        }
    }

    public final void setPreferenceForNone(double preferenceForNone) {
        this.filtersPerformance.setPreferenceForNone(preferenceForNone);
    }

    public final void tuneMemory(double m) {
        this.filtersPerformance.tuneMemory(m);
    }

    public final void setFilterWeights(@NotNull double[] weights) {
        Intrinsics.checkNotNullParameter((Object)weights, (String)"weights");
        this.filtersPerformance.setFilterWeights(weights);
    }
}

