/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.ftps;

import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.apache.commons.net.util.TrustManagerUtils;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;
import org.apache.commons.vfs2.provider.ftps.ServerSocketFactoryWrapper;
import org.apache.commons.vfs2.provider.ftps.SocketFactoryWrapper;

public final class FtpsFileSystemConfigBuilder
extends FtpFileSystemConfigBuilder {
    private static final String PREFIX = FtpsFileSystemConfigBuilder.class.getName();
    private static final FtpsFileSystemConfigBuilder BUILDER = new FtpsFileSystemConfigBuilder();
    private static final String FTPS_MODE = PREFIX + ".FTPS_MODE";
    private static final String PROT = PREFIX + ".PROT";
    private static final String KEY_MANAGER = PREFIX + ".KEY_MANAGER";
    private static final String TRUST_MANAGER = PREFIX + ".TRUST_MANAGER";
    private static final String SOCKET_FACTORY_WRAPPER = PREFIX + ".SOCKET_FACTORY_WRAPPER";
    private static final String SERVER_SOCKET_FACTORY_WRAPPER = PREFIX + ".SERVER_SOCKET_FACTORY_WRAPPER";
    private static final String SHARE_SSL_CONTEXT = PREFIX + ".SHARE_SSL_CONTEXT";
    private static final String PROTOCOLS = PREFIX + ".PROTOCOLS";

    private FtpsFileSystemConfigBuilder() {
        super("ftps.");
    }

    public static FtpsFileSystemConfigBuilder getInstance() {
        return BUILDER;
    }

    public void setFtpsMode(FileSystemOptions opts, FtpsMode ftpsMode) {
        this.setParam(opts, FTPS_MODE, (Object)ftpsMode);
    }

    public FtpsMode getFtpsMode(FileSystemOptions opts) {
        return this.getEnum(FtpsMode.class, opts, FTPS_MODE, FtpsMode.EXPLICIT);
    }

    @Deprecated
    public void setFtpsType(FileSystemOptions opts, String ftpsType) {
        FtpsMode mode;
        if (ftpsType != null) {
            mode = FtpsMode.valueOf(ftpsType.toUpperCase());
            if (mode == null) {
                throw new IllegalArgumentException("Not a proper FTPS mode: " + ftpsType);
            }
        } else {
            mode = null;
        }
        this.setFtpsMode(opts, mode);
    }

    @Deprecated
    public String getFtpsType(FileSystemOptions opts) {
        return this.getFtpsMode(opts).name().toLowerCase();
    }

    public FtpsDataChannelProtectionLevel getDataChannelProtectionLevel(FileSystemOptions opts) {
        return this.getEnum(FtpsDataChannelProtectionLevel.class, opts, PROT);
    }

    public void setDataChannelProtectionLevel(FileSystemOptions opts, FtpsDataChannelProtectionLevel prot) {
        this.setParam(opts, PROT, (Object)prot);
    }

    public KeyManager getKeyManager(FileSystemOptions opts) {
        return (KeyManager)this.getParam(opts, KEY_MANAGER);
    }

    public void setKeyManager(FileSystemOptions opts, KeyManager keyManager) {
        this.setParam(opts, KEY_MANAGER, keyManager);
    }

    public TrustManager getTrustManager(FileSystemOptions opts) {
        TrustManager trustManager = this.hasParam(opts, TRUST_MANAGER) ? (TrustManager)this.getParam(opts, TRUST_MANAGER) : TrustManagerUtils.getValidateServerCertificateTrustManager();
        return trustManager;
    }

    public void setTrustManager(FileSystemOptions opts, TrustManager trustManager) {
        this.setParam(opts, TRUST_MANAGER, trustManager);
    }

    public SocketFactoryWrapper getSocketFactoryWrapper(FileSystemOptions opts) {
        return (SocketFactoryWrapper)this.getParam(opts, SOCKET_FACTORY_WRAPPER);
    }

    public void setSocketFactoryWrapper(FileSystemOptions opts, SocketFactoryWrapper value) {
        this.setParam(opts, SOCKET_FACTORY_WRAPPER, value);
    }

    public ServerSocketFactoryWrapper getServerSocketFactoryWrapper(FileSystemOptions opts) {
        return (ServerSocketFactoryWrapper)this.getParam(opts, SERVER_SOCKET_FACTORY_WRAPPER);
    }

    public void setServerSocketFactoryWrapper(FileSystemOptions opts, ServerSocketFactoryWrapper value) {
        this.setParam(opts, SERVER_SOCKET_FACTORY_WRAPPER, value);
    }

    public void setShareSslContext(FileSystemOptions opts, boolean value) {
        this.setParam(opts, SHARE_SSL_CONTEXT, value);
    }

    public boolean getShareSslContext(FileSystemOptions opts) {
        return this.getBoolean(opts, SHARE_SSL_CONTEXT, false);
    }

    public void setEnabledProtocols(FileSystemOptions opts, String value) {
        this.setParam(opts, PROTOCOLS, value);
    }

    public String getEnabledProtocols(FileSystemOptions opts) {
        return this.getString(opts, PROTOCOLS);
    }
}

