/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.freemarker.FreeMarkerBundle;
import com.intellij.freemarker.inspections.FtlSuppressableInspection;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlBuiltIn;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FtlCallsInspection
extends FtlSuppressableInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            FtlCallsInspection.$$$reportNull$$$0(0);
        }
        return new PsiElementVisitor(this){

            public void visitElement(@NotNull PsiElement element) {
                FtlMethodCallExpression call;
                FtlExpression expression;
                FtlCallableType type;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof FtlMacro) {
                    FtlMacro macro = (FtlMacro)element;
                    FtlCallsInspection.checkCall(macro.getMacroType(), holder, macro.getArgumentList(), macro.getStartTagNameElement());
                } else if (element instanceof FtlMethodCallExpression && (type = FtlPsiUtil.asInstanceOf((expression = (call = (FtlMethodCallExpression)element).getMethodExpression()).getType(), FtlCallableType.class)) != null && !type.isMacro() && !(type instanceof FtlMethodType) && !(expression instanceof FtlBuiltIn) && type != FtlCallableType.TEMPLATE_METHOD_TYPE) {
                    FtlCallsInspection.checkCall(type, holder, call.getArgumentList(), expression);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/freemarker/inspections/FtlCallsInspection$1", "visitElement"));
            }
        };
    }

    private static void checkCall(@Nullable FtlCallableType type, ProblemsHolder holder, FtlArgumentList argumentList, PsiElement callElement) {
        if (type == null) {
            return;
        }
        Map paramTypes = Arrays.stream(type.getParameters()).collect(Collectors.toMap(p -> p.getName(), Function.identity(), (p1, p2) -> p1));
        FtlExpression[] positionalArguments = argumentList.getPositionalArguments();
        List mandatoryParameters = ContainerUtil.findAll((Object[])type.getParameters(), ftlParameter -> ftlParameter.isMandatory());
        int posArgCount = positionalArguments.length;
        if (argumentList.isPositional() && posArgCount > 0) {
            if (posArgCount < mandatoryParameters.size()) {
                StringBuilder sb = new StringBuilder();
                for (int i = posArgCount; i < mandatoryParameters.size(); ++i) {
                    if (i != posArgCount) {
                        sb.append(", ");
                    }
                    sb.append(((FtlParameter)mandatoryParameters.get(i)).getName());
                }
                holder.registerProblem(callElement, FreeMarkerBundle.message("undefined.mandatory.parameters", sb.toString()), new LocalQuickFix[0]);
                return;
            }
            FtlParameter[] formalParams = type.getParameters();
            if (!(posArgCount <= formalParams.length || formalParams.length != 0 && formalParams[formalParams.length - 1].isVararg())) {
                holder.registerProblem(callElement, FreeMarkerBundle.message("too.many.parameters", new Object[0]), new LocalQuickFix[0]);
                return;
            }
            for (int i = 0; !(i >= Math.min(formalParams.length, posArgCount) || formalParams[i] instanceof FtlParameterDeclaration && formalParams[i].isVararg()); ++i) {
                FtlCallsInspection.checkTypes(holder, formalParams[i].getType(), positionalArguments[i]);
            }
            return;
        }
        HashSet mandatoryParams = new HashSet();
        for (FtlVariable variable : mandatoryParameters) {
            ContainerUtil.addIfNotNull(mandatoryParams, (Object)variable.getName());
        }
        for (FtlNameValuePair argument : argumentList.getNamedArguments()) {
            String s = argument.getName();
            if (s == null) continue;
            mandatoryParams.remove(s);
            FtlParameter parameter = (FtlParameter)paramTypes.get(s);
            PsiElement value = argument.getValueElement();
            if (parameter == null || !(value instanceof FtlExpression)) continue;
            FtlCallsInspection.checkTypes(holder, parameter.getType(), (FtlExpression)value);
        }
        if (!mandatoryParams.isEmpty()) {
            holder.registerProblem(callElement, FreeMarkerBundle.message("undefined.mandatory.parameters", StringUtil.join(mandatoryParams, (String)", ")), new LocalQuickFix[0]);
        }
    }

    private static void checkTypes(ProblemsHolder holder, FtlType expected, @NotNull FtlExpression arg) {
        if (arg == null) {
            FtlCallsInspection.$$$reportNull$$$0(1);
        }
        FtlPsiType formalType = FtlPsiUtil.asInstanceOf(expected, FtlPsiType.class);
        FtlPsiType actualType = FtlPsiUtil.asInstanceOf(arg.getType(), FtlPsiType.class);
        if (formalType != null && actualType != null && !formalType.getPsiType().isAssignableFrom(actualType.getPsiType())) {
            holder.registerProblem((PsiElement)arg, FreeMarkerBundle.message("type.mismatch", formalType.getPresentableText(), actualType.getPresentableText()), new LocalQuickFix[0]);
        }
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = FreeMarkerBundle.message("freemarker.inspections.group", new Object[0]);
        if (string == null) {
            FtlCallsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.ERROR;
        if (highlightDisplayLevel == null) {
            FtlCallsInspection.$$$reportNull$$$0(3);
        }
        return highlightDisplayLevel;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        return "FtlCallsInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arg";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/inspections/FtlCallsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/inspections/FtlCallsInspection";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkTypes";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }
}

