/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.psi.JSCallItem;
import com.intellij.lang.javascript.psi.JSCallLikeExpression;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.resolve.JSGenericMappings;
import com.intellij.lang.javascript.psi.types.JSGenericParameterType;
import com.intellij.lang.javascript.psi.types.JSGenericTypeEvaluationFunction;
import com.intellij.lang.javascript.psi.types.JSTypeGenericId;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JSGenericTypesEvaluator {
    public static final Key<JSGenericMappings> ourGenericArgumentsMapKey = Key.create((String)"generic.arguments");
    public static final Key<Boolean> ourHadContravariantGenerics = Key.create((String)"generic.had.contravariant");
    public static final Key<Pair<JSTypeGenericId, Integer>> impliedArity = Key.create((String)"generic.implied.arity");
    public static final Key<Set<JSTypeGenericId>> nonWideningLiterals = Key.create((String)"generic.non.widening.literals");
    public static final Key<Supplier<List<JSType>>> genericParametersProvider = Key.create((String)"generic.parameters.provider");
    public static final GenericEvaluationContext DEFAULT_CONTEXT = new GenericEvaluationContext();
    public static final JSGenericTypesEvaluator NO_OP = new JSGenericTypesEvaluator(){

        @Override
        public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            return type;
        }

        @Override
        @NotNull
        public JSType evaluateGenericsFromQualifier(@NotNull JSType type, @NotNull JSExpression qualifier, @NotNull JSExpression methodExpression) {
            if (type == null) {
                1.$$$reportNull$$$0(1);
            }
            if (qualifier == null) {
                1.$$$reportNull$$$0(2);
            }
            if (methodExpression == null) {
                1.$$$reportNull$$$0(3);
            }
            JSType jSType = type;
            if (jSType == null) {
                1.$$$reportNull$$$0(4);
            }
            return jSType;
        }

        @Override
        @NotNull
        public JSGenericTypeEvaluationFunction getEvaluationFunction(@NotNull JSCallLikeExpression callLikeExpression, @NotNull PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
            if (callLikeExpression == null) {
                1.$$$reportNull$$$0(5);
            }
            if (resolvedFunction == null) {
                1.$$$reportNull$$$0(6);
            }
            if (context == null) {
                1.$$$reportNull$$$0(7);
            }
            JSGenericTypeEvaluationFunction jSGenericTypeEvaluationFunction = JSGenericTypeEvaluationFunction.SELF;
            if (jSGenericTypeEvaluationFunction == null) {
                1.$$$reportNull$$$0(8);
            }
            return jSGenericTypeEvaluationFunction;
        }

        @Override
        public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSCallItem callItem, @Nullable PsiElement resolvedFunction, @NotNull GenericEvaluationContext context) {
            if (context == null) {
                1.$$$reportNull$$$0(9);
            }
            return type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 8 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "qualifier";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "methodExpression";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callLikeExpression";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolvedFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$1";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "evaluateGenericsFromQualifier";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEvaluationFunction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateGenerics";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "evaluateGenericsFromQualifier";
                    break;
                }
                case 4: 
                case 8: {
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "getEvaluationFunction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 8 -> new IllegalStateException(string);
            };
        }
    };

    @Contract(value="null -> false")
    public static boolean isGenericProcessingInProgress(@Nullable ProcessingContext context) {
        return JSGenericTypesEvaluator.getGenericMappings(context) != null;
    }

    @Nullable
    public static JSGenericMappings getGenericMappings(@Nullable ProcessingContext context) {
        return context != null ? (JSGenericMappings)context.get(ourGenericArgumentsMapKey) : null;
    }

    @NotNull
    public static JSGenericTypesEvaluator getEvaluator(@Nullable PsiElement context) {
        JSGenericTypesEvaluator jSGenericTypesEvaluator = JSDialectSpecificHandlersFactory.forElement(context).getGenericTypeEvaluator();
        if (jSGenericTypesEvaluator == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(0);
        }
        return jSGenericTypesEvaluator;
    }

    public static int getImpliedArity(@NotNull JSType type, @NotNull ProcessingContext context) {
        if (type == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(1);
        }
        if (context == null) {
            JSGenericTypesEvaluator.$$$reportNull$$$0(2);
        }
        if (!(type instanceof JSGenericParameterType)) {
            return -1;
        }
        Pair pair = (Pair)context.get(impliedArity);
        if (pair == null) {
            return -1;
        }
        return ((JSTypeGenericId)pair.first).equals(((JSGenericParameterType)type).getGenericId()) ? (Integer)pair.second : -1;
    }

    @Contract(value="!null,_,_->!null")
    default public JSType evaluateGenerics(@Nullable JSType type, @Nullable JSExpression methodExpression, @Nullable PsiElement resolvedFunction) {
        return this.evaluateGenerics(type, methodExpression, resolvedFunction, DEFAULT_CONTEXT);
    }

    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType var1, @Nullable JSExpression var2, @Nullable PsiElement var3, @NotNull GenericEvaluationContext var4);

    @Contract(value="!null, _, _, _ -> !null")
    public JSType evaluateGenerics(@Nullable JSType var1, @NotNull JSCallItem var2, @Nullable PsiElement var3, @NotNull GenericEvaluationContext var4);

    @NotNull
    public JSType evaluateGenericsFromQualifier(@NotNull JSType var1, @NotNull JSExpression var2, @NotNull JSExpression var3);

    @NotNull
    public JSGenericTypeEvaluationFunction getEvaluationFunction(@NotNull JSCallLikeExpression var1, @NotNull PsiElement var2, @NotNull GenericEvaluationContext var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getImpliedArity";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static final class GenericEvaluationContext {
        public final int paramToSkip;
        public final JSExpectedTypeKind expectedTypeKind;
        public final Pair<JSTypeGenericId, Integer> impliedArity;
        @NotNull
        public final Predicate<? super JSType> acceptableGenericArguments;
        @Nullable
        public final Supplier<List<JSType>> genericParametersProvider;
        @Nullable
        public final GenericErrorReporter reporter;

        public GenericEvaluationContext(@Nullable GenericErrorReporter reporter) {
            this(reporter, -1, JSExpectedTypeKind.EXPECTED);
        }

        public GenericEvaluationContext() {
            this(null, -1, JSExpectedTypeKind.EXPECTED);
        }

        public GenericEvaluationContext(@Nullable GenericErrorReporter reporter, int paramToSkip, JSExpectedTypeKind expectedTypeKind) {
            this.paramToSkip = paramToSkip;
            this.reporter = reporter;
            this.expectedTypeKind = expectedTypeKind;
            this.acceptableGenericArguments = el -> true;
            this.impliedArity = null;
            this.genericParametersProvider = null;
        }

        public GenericEvaluationContext(@NotNull GenericEvaluationContext prev, @NotNull Predicate<? super JSType> acceptableGenericArguments) {
            if (prev == null) {
                GenericEvaluationContext.$$$reportNull$$$0(0);
            }
            if (acceptableGenericArguments == null) {
                GenericEvaluationContext.$$$reportNull$$$0(1);
            }
            this(prev, acceptableGenericArguments, null);
        }

        public GenericEvaluationContext(@NotNull GenericEvaluationContext prev, @NotNull Predicate<? super JSType> acceptableGenericArguments, @Nullable Supplier<List<JSType>> genericParametersProvider) {
            if (prev == null) {
                GenericEvaluationContext.$$$reportNull$$$0(2);
            }
            if (acceptableGenericArguments == null) {
                GenericEvaluationContext.$$$reportNull$$$0(3);
            }
            this.paramToSkip = prev.paramToSkip;
            this.expectedTypeKind = prev.expectedTypeKind;
            this.reporter = prev.reporter;
            this.impliedArity = prev.impliedArity;
            this.acceptableGenericArguments = acceptableGenericArguments;
            this.genericParametersProvider = genericParametersProvider;
        }

        public GenericEvaluationContext(@NotNull GenericEvaluationContext prev, @Nullable Pair<JSTypeGenericId, Integer> arity) {
            if (prev == null) {
                GenericEvaluationContext.$$$reportNull$$$0(4);
            }
            this.paramToSkip = prev.paramToSkip;
            this.expectedTypeKind = prev.expectedTypeKind;
            this.reporter = prev.reporter;
            this.acceptableGenericArguments = prev.acceptableGenericArguments;
            this.genericParametersProvider = prev.genericParametersProvider;
            this.impliedArity = arity;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prev";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "acceptableGenericArguments";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSGenericTypesEvaluator$GenericEvaluationContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface GenericErrorReporter {
        public void error(@NotNull @InspectionMessage String var1);
    }
}

