/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMap;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMapKt;
import com.jetbrains.rd.platform.codeWithMe.blockmap.IndexManagerKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bJ\u000e\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0003H\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rd/platform/codeWithMe/blockmap/IndexManager;", "", "storagePath", "", "<init>", "(Ljava/lang/String;)V", "register", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMap;", "dir", "", "dirs", "", "get", "getAllIndexes", "isBlockMapExists", "", "getPathToIndex", "Ljava/nio/file/Path;", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nIndexManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IndexManager.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/IndexManager\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,106:1\n186#2:107\n196#2:115\n1285#3,2:108\n1299#3,4:110\n1#4:114\n11561#5:116\n11896#5,3:117\n1255#6,2:120\n*S KotlinDebug\n*F\n+ 1 IndexManager.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/IndexManager\n*L\n45#1:107\n67#1:115\n60#1:108,2\n60#1:110,4\n73#1:116\n73#1:117,3\n83#1:120,2\n*E\n"})
public final class IndexManager {
    @NotNull
    private final String storagePath;

    public IndexManager(@NotNull String storagePath) {
        Intrinsics.checkNotNullParameter((Object)storagePath, (String)"storagePath");
        this.storagePath = storagePath;
        Path path = Paths.get(this.storagePath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path storage = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(storage, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(storage, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final DirBlockMap register(@NotNull String dir) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (this.isBlockMapExists(dir)) {
            return this.get(dir);
        }
        Path path = Paths.get(dir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new RuntimeException("Dir '" + dir + "' not exists");
        }
        DirBlockMap dirBlockMap = DirBlockMapKt.createDirBlockMap$default(dir, null, 2, null);
        Path index = this.getPathToIndex(dir);
        Path path2 = index.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
        Object object2 = path2;
        Object[] objectArray = new LinkOption[]{};
        if (!Files.exists((Path)object2, Arrays.copyOf(objectArray, objectArray.length))) {
            Path path3 = index.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"getParent(...)");
            object2 = path3;
            objectArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)object2, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"createDirectories(...)");
        }
        LinkOption[] linkOptionArray2 = new LinkOption[]{};
        if (Files.notExists(index, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(index, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(index, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        object2 = outputStream;
        int n = 8192;
        object2 = object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n);
        Object object3 = null;
        try {
            void $this$encodeToByteArray$iv;
            BufferedOutputStream it = (BufferedOutputStream)object2;
            boolean bl = false;
            BinaryFormat binaryFormat = (BinaryFormat)ProtoBuf.Default;
            DirBlockMap value$iv = dirBlockMap;
            boolean $i$f$encodeToByteArray = false;
            $this$encodeToByteArray$iv.getSerializersModule();
            it.write($this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)DirBlockMap.Companion.serializer(), (Object)value$iv));
            object = Unit.INSTANCE;
        }
        catch (Throwable bl) {
            object3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        Path pathToContent = index.getParent().resolve("PATH_TO_CONTENT.txt");
        Intrinsics.checkNotNull((Object)pathToContent);
        LinkOption[] linkOptionArray3 = new LinkOption[]{};
        if (Files.notExists(pathToContent, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(pathToContent, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        }
        OpenOption[] openOptionArray2 = new OpenOption[]{};
        OutputStream outputStream2 = Files.newOutputStream(pathToContent, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
        object3 = outputStream2;
        object = null;
        try {
            OutputStream it = (OutputStream)object3;
            boolean bl = false;
            byte[] byArray = dir.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            it.write(byArray);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object3, (Throwable)object);
        }
        return dirBlockMap;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, DirBlockMap> register(@NotNull List<String> dirs) {
        void $this$associateWithTo$iv$iv;
        Intrinsics.checkNotNullParameter(dirs, (String)"dirs");
        Iterable $this$associateWith$iv = dirs;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable iterable = $this$associateWith$iv;
        Map destination$iv$iv = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            String string = (String)element$iv$iv;
            Object t = element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            DirBlockMap dirBlockMap = this.register((String)it);
            map.put(t, dirBlockMap);
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final DirBlockMap get(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (this.isBlockMapExists(dir)) {
            void $this$decodeFromByteArray$iv;
            Object it;
            Path index = this.getPathToIndex(dir);
            File file = index.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            Object object = file;
            object = new FileInputStream((File)object);
            Throwable throwable = null;
            try {
                it = (FileInputStream)object;
                boolean bl = false;
                it = ((FileInputStream)it).readAllBytes();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            Object bytes = it;
            object = (BinaryFormat)ProtoBuf.Default;
            Intrinsics.checkNotNull((Object)bytes);
            Object bytes$iv = bytes;
            boolean $i$f$decodeFromByteArray = false;
            $this$decodeFromByteArray$iv.getSerializersModule();
            return (DirBlockMap)$this$decodeFromByteArray$iv.decodeFromByteArray((DeserializationStrategy)DirBlockMap.Companion.serializer(), (byte[])bytes$iv);
        }
        throw new RuntimeException("Trying to get index for not registered dir: '" + dir + "'");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, DirBlockMap> getAllIndexes() {
        List list;
        String[] stringArray = new File(this.storagePath).list();
        if (stringArray != null) {
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = stringArray;
            boolean $i$f$map = false;
            String[] stringArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                byte[] byArray;
                void dir;
                void item$iv$iv;
                void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Object object = new FileInputStream(new File((String)dir));
                Throwable throwable = null;
                try {
                    FileInputStream it = (FileInputStream)object;
                    boolean bl2 = false;
                    byArray = it.readAllBytes();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"use(...)");
                byte[] byArray2 = byArray;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                object = charset;
                String pathToContent = new String(byArray2, (Charset)object);
                collection.add(TuplesKt.to((Object)pathToContent, (Object)this.get(pathToContent)));
            }
            list = (List)destination$iv$iv;
        } else {
            list = null;
        }
        Intrinsics.checkNotNull(list);
        return MapsKt.toMap((Iterable)list);
    }

    private final boolean isBlockMapExists(String dir) {
        boolean bl;
        Path index = this.getPathToIndex(dir);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.exists(index, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            boolean shouldRebuild;
            block4: {
                boolean bl2;
                LinkOption[] linkOptionArray2 = new LinkOption[]{};
                FileTime fileTime = Files.getLastModifiedTime(index, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length));
                Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                FileTime indexLastModTime = fileTime;
                Sequence $this$any$iv = (Sequence)FilesKt.walkTopDown((File)new File(dir));
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    Path path;
                    File it = (File)element$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it.toPath(), (String)"toPath(...)");
                    LinkOption[] linkOptionArray3 = new LinkOption[]{};
                    FileTime fileTime2 = Files.getLastModifiedTime(path, Arrays.copyOf(linkOptionArray3, linkOptionArray3.length));
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime2, (String)"getLastModifiedTime(...)");
                    if (!(fileTime2.compareTo(indexLastModTime) > 0)) continue;
                    bl2 = true;
                    break block4;
                }
                bl2 = shouldRebuild = false;
            }
            if (shouldRebuild) {
                Files.delete(index);
            }
            bl = !shouldRebuild;
        } else {
            bl = false;
        }
        return bl;
    }

    private final Path getPathToIndex(String dir) {
        String pathHash = IndexManagerKt.access$getPathHash(dir);
        String string = this.storagePath;
        String[] stringArray = new String[]{pathHash};
        Path path = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path pathToIndexDir = path;
        Path path2 = pathToIndexDir.resolve("BLOCK_MAP_INDEX");
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }
}

