/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.predicate;

import java.util.List;
import org.locationtech.jts.algorithm.RectangleLineIntersector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geom.util.ShortCircuitedGeometryVisitor;

class RectangleIntersectsSegmentVisitor
extends ShortCircuitedGeometryVisitor {
    private Envelope rectEnv;
    private RectangleLineIntersector rectIntersector;
    private boolean hasIntersection = false;

    public RectangleIntersectsSegmentVisitor(Polygon rectangle) {
        this.rectEnv = rectangle.getEnvelopeInternal();
        this.rectIntersector = new RectangleLineIntersector(this.rectEnv);
    }

    public boolean intersects() {
        return this.hasIntersection;
    }

    @Override
    protected void visit(Geometry geom) {
        Envelope elementEnv = geom.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        List lines2 = LinearComponentExtracter.getLines(geom);
        this.checkIntersectionWithLineStrings(lines2);
    }

    private void checkIntersectionWithLineStrings(List lines2) {
        for (LineString testLine : lines2) {
            this.checkIntersectionWithSegments(testLine);
            if (!this.hasIntersection) continue;
            return;
        }
    }

    private void checkIntersectionWithSegments(LineString testLine) {
        CoordinateSequence seq1 = testLine.getCoordinateSequence();
        Coordinate p0 = seq1.createCoordinate();
        Coordinate p1 = seq1.createCoordinate();
        for (int j = 1; j < seq1.size(); ++j) {
            seq1.getCoordinate(j - 1, p0);
            seq1.getCoordinate(j, p1);
            if (!this.rectIntersector.intersects(p0, p1)) continue;
            this.hasIntersection = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.hasIntersection;
    }
}

