/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.model;

import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import com.intellij.spring.mvc.services.SpringMvcService;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.text.DateFormatUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DumpSpringMVCModelAction
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpSpringMVCModelAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null && SpringCommonUtils.isSpringConfigured((Project)project));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            DumpSpringMVCModelAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            DumpSpringMVCModelAction.$$$reportNull$$$0(2);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        ThrowableComputable computable = () -> (String)ReadAction.compute(() -> DumpSpringMVCModelAction.getMvcModelDump(project));
        String dump = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(computable, SpringMvcBundle.message("DumpSpringMVCModelAction.gathering.spring.mvc.models", new Object[0]), true, project);
        String fileName = String.format("SpringMVCModel-%s.txt", DateFormatUtil.formatDateTime((long)System.currentTimeMillis()));
        LightVirtualFile file = new LightVirtualFile(fileName, (CharSequence)dump);
        OpenFileDescriptor descriptor = new OpenFileDescriptor(project, (VirtualFile)file);
        FileEditorManager.getInstance((Project)project).openEditor(descriptor, true);
    }

    private static String getMvcModelDump(Project project) {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        pi.setIndeterminate(false);
        pi.setText(SpringMvcBundle.message("DumpSpringMVCModelAction.scanning.spring.mvc.models", new Object[0]));
        Module[] modules = ModuleManager.getInstance((Project)project).getSortedModules();
        StringBuilder dump = new StringBuilder();
        int processedModules = 0;
        for (Module module : modules) {
            pi.checkCanceled();
            String name = module.getName();
            dump.append(name).append(" ").append(StringUtil.repeatSymbol((char)'=', (int)Math.max(1, 119 - name.length()))).append("\n");
            SpringFacet springFacet = SpringFacet.getInstance((Module)module);
            if (springFacet == null) {
                dump.append("no Spring facet");
            } else {
                Collection webFacets = WebFacet.getInstances((Module)module);
                if (webFacets.isEmpty()) {
                    dump.append("no Web facets");
                } else {
                    DumpSpringMVCModelAction.dumpModule(dump, springFacet, webFacets);
                }
            }
            dump.append("\n\n");
            pi.setFraction((double)(++processedModules) / (double)modules.length);
        }
        return dump.toString();
    }

    private static void dumpModule(StringBuilder dump, SpringFacet springFacet, Collection<WebFacet> webFacets) {
        dump.append("Servlet models:\n");
        Set<SpringModel> servletModels = SpringMvcService.getServletModels(springFacet.getModule());
        for (SpringModel servletModel : servletModels) {
            SpringFileSet fileSet = servletModel.getFileSet();
            assert (fileSet != null) : servletModel;
            dump.append(" ").append(fileSet.getId());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/mvc/model/DumpSpringMVCModelAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/mvc/model/DumpSpringMVCModelAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

