/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.openapi.project.DumbModeBlockedFunctionality;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class SpringDumbModeLineMarkers {
    public static final List<String> COMPONENT_ANNOTATION_SHORTNAMES = ContainerUtil.map(List.of("org.springframework.stereotype.Component", "org.springframework.stereotype.Service", "org.springframework.stereotype.Repository", "org.springframework.stereotype.Controller", "org.springframework.context.annotation.ComponentScan", "org.springframework.context.annotation.Configuration", "org.springframework.web.bind.annotation.RestController", "org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.autoconfigure.AutoConfiguration", "org.springframework.boot.context.properties.ConfigurationProperties", "org.springframework.boot.test.context.SpringBootTest"), StringUtil::getShortName);
    static final List<String> ANNOTATION_TARGET_SHORTNAMES = ContainerUtil.map(List.of("org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.test.context.SpringBootTest"), StringUtil::getShortName);
    static final String BEAN_ANNOTATION_SHORTNAME = StringUtil.getShortName((String)"org.springframework.context.annotation.Bean");
    static final List<String> BEAN_ANNOTATION_SHORTNAMES = List.of(BEAN_ANNOTATION_SHORTNAME);
    public static final List<String> EVENT_LISTENER_ANNOTATION_SHORTNAMES = ContainerUtil.map(List.of("org.springframework.context.event.EventListener", "org.springframework.transaction.event.TransactionalEventListener"), StringUtil::getShortName);
    static final List<String> AUTOWIRING_ANNOTATION_SHORTNAMES = Stream.of("org.springframework.beans.factory.annotation.Autowired", "javax.inject.Inject").map(StringUtil::getShortName).collect(Collectors.toList());
    static final List<String> LOMBOK_REQUIRED_ARGS_ANNOTATION_SHORTNAMES = ContainerUtil.map(List.of("lombok.RequiredArgsConstructor"), StringUtil::getShortName);

    private SpringDumbModeLineMarkers() {
    }

    @NotNull
    public static GutterIconNavigationHandler<PsiElement> getDumbNavigationHandler(DumbModeBlockedFunctionality functionality) {
        GutterIconNavigationHandler gutterIconNavigationHandler = (e, element) -> DumbService.getInstance((Project)element.getProject()).showDumbModeNotificationForFunctionality(CodeInsightBundle.message((String)"message.navigation.is.not.available.here.during.index.update", (Object[])new Object[0]), functionality);
        if (gutterIconNavigationHandler == null) {
            SpringDumbModeLineMarkers.$$$reportNull$$$0(0);
        }
        return gutterIconNavigationHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringDumbModeLineMarkers", "getDumbNavigationHandler"));
    }
}

