/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.spellcheck;

import ai.grazie.detector.heuristics.rule.RuleFilter;
import ai.grazie.nlp.langs.Language;
import ai.grazie.utils.CollectionsKt;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.GraziePlugin;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.ide.msg.GrazieStateLifecycleKt;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.LangTool;
import com.intellij.grazie.remote.HunspellDescriptor;
import com.intellij.grazie.utils.TextStyleDomain;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.ClassLoaderUtil;
import com.intellij.platform.util.coroutines.CoroutineScopeKt;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.util.io.ProcessKt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.languagetool.JLanguageTool;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.spelling.SpellingCheckRule;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001(B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0016J\u0014\u0010!\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0#J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00150\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010'\u001a\u00020\u001dH\u0007R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u001a\u00a8\u0006)"}, d2={"Lcom/intellij/grazie/spellcheck/GrazieCheckers;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "filter", "Lai/grazie/detector/heuristics/rule/RuleFilter;", "getFilter", "()Lai/grazie/detector/heuristics/rule/RuleFilter;", "filter$delegate", "Lkotlin/Lazy;", "isHunspellAvailable", "", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "enabledLanguages", "", "filterCheckers", "Lcom/intellij/grazie/spellcheck/GrazieCheckers$SpellerTool;", "word", "", "checkers", "", "configurationScope", "getConfigurationScope$annotations", "()V", "heavyInit", "update", "", "prevState", "Lcom/intellij/grazie/GrazieConfig$State;", "newState", "hasSpellerTool", "langs", "", "lookup", "Lcom/intellij/spellchecker/dictionary/Dictionary$LookupStatus;", "getSuggestions", "awaitConfiguration", "SpellerTool", "intellij.grazie.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGrazieSpellchecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieCheckers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n1#2:184\n1761#3,3:185\n1761#3,3:188\n*S KotlinDebug\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieCheckers\n*L\n139#1:185,3\n64#1:188,3\n*E\n"})
public final class GrazieCheckers
implements GrazieStateLifecycle {
    @NotNull
    private final Lazy filter$delegate;
    @NotNull
    private volatile Collection<SpellerTool> checkers;
    @NotNull
    private final CoroutineScope configurationScope;

    public GrazieCheckers(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.filter$delegate = LazyKt.lazy(GrazieCheckers::filter_delegate$lambda$0);
        this.checkers = this.heavyInit();
        this.configurationScope = CoroutineScopeKt.childScope$default((CoroutineScope)coroutineScope, (String)"ConfigurationChanged", (CoroutineContext)((CoroutineContext)CoroutineDispatcher.limitedParallelism$default((CoroutineDispatcher)Dispatchers.getDefault(), (int)1, null, (int)2, null)), (boolean)false, (int)4, null);
        Application application = ApplicationManager.getApplication();
        SimpleMessageBusConnection connection = application.getMessageBus().connect(coroutineScope);
        connection.subscribe(GrazieStateLifecycleKt.getCONFIG_STATE_TOPIC(), (Object)this);
    }

    private final RuleFilter getFilter() {
        Lazy lazy = this.filter$delegate;
        return (RuleFilter)lazy.getValue();
    }

    private final boolean isHunspellAvailable(Lang lang, Set<? extends Lang> enabledLanguages) {
        HunspellDescriptor hunspellDescriptor = lang.getHunspellRemote();
        if (hunspellDescriptor == null) {
            return false;
        }
        HunspellDescriptor hunspell = hunspellDescriptor;
        return enabledLanguages.contains((Object)lang) && Files.exists(GrazieDynamic.INSTANCE.getDynamicFolder().resolve(hunspell.getFile()), new LinkOption[0]);
    }

    private final Set<SpellerTool> filterCheckers(String word) {
        Collection<SpellerTool> checkers = this.checkers;
        if (checkers.isEmpty()) {
            return SetsKt.emptySet();
        }
        Set preferred = this.getFilter().filter(kotlin.collections.CollectionsKt.listOf((Object)word)).getPreferred();
        Set<Lang> enabledLanguages = GrazieConfig.Companion.get().getEnabledLanguages();
        return SequencesKt.toSet((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.filter((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)checkers), arg_0 -> GrazieCheckers.filterCheckers$lambda$0(preferred, arg_0)), arg_0 -> GrazieCheckers.filterCheckers$lambda$1(this, enabledLanguages, arg_0)));
    }

    private static /* synthetic */ void getConfigurationScope$annotations() {
    }

    private final Collection<SpellerTool> heavyInit() {
        LinkedHashSet<SpellerTool> set = new LinkedHashSet<SpellerTool>();
        for (Lang lang : GrazieConfig.Companion.get().getAvailableLanguages()) {
            if (lang.isEnglish()) continue;
            JLanguageTool tool2 = (JLanguageTool)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JLanguageTool>, Object>(lang, null){
                int label;
                final /* synthetic */ Lang $lang;
                {
                    this.$lang = $lang;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = ProcessKt.computeDetached$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super JLanguageTool>, Object>(this.$lang, null){
                                int label;
                                final /* synthetic */ Lang $lang;
                                {
                                    this.$lang = $lang;
                                    super(2, $completion);
                                }

                                public final Object invokeSuspend(Object $result) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            return LangTool.INSTANCE.getTool(this.$lang, TextStyleDomain.Other);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super JLanguageTool> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this), (int)1, null);
                            if (object2 != object) return object2;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return object2;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super JLanguageTool> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
            List list = tool2.getAllSpellingCheckRules();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSpellingCheckRules(...)");
            SpellingCheckRule spellingCheckRule = (SpellingCheckRule)kotlin.collections.CollectionsKt.firstOrNull((List)list);
            if (spellingCheckRule == null) continue;
            SpellingCheckRule it = spellingCheckRule;
            boolean bl = false;
            set.add(new SpellerTool(tool2, lang, it));
        }
        return set;
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        BuildersKt.launch$default((CoroutineScope)this.configurationScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ GrazieCheckers this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        GrazieCheckers.access$setCheckers$p(this.this$0, GrazieCheckers.access$heavyInit(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final boolean hasSpellerTool(@NotNull List<? extends Lang> langs) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter(langs, (String)"langs");
            Iterable $this$any$iv = langs;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    block6: {
                        Lang lang = (Lang)((Object)element$iv);
                        boolean bl3 = false;
                        Iterable $this$any$iv2 = this.checkers;
                        boolean $i$f$any2 = false;
                        if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv2 : $this$any$iv2) {
                                SpellerTool it = (SpellerTool)element$iv2;
                                boolean bl4 = false;
                                if (!(it.getLang() == lang)) continue;
                                bl2 = true;
                                break block6;
                            }
                            bl2 = false;
                        }
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Dictionary.LookupStatus lookup(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Set<SpellerTool> myCheckers = this.filterCheckers(word);
        boolean isAlien = true;
        for (SpellerTool speller : myCheckers) {
            Boolean bl = speller.check(word);
            if (Intrinsics.areEqual((Object)bl, (Object)true)) {
                return Dictionary.LookupStatus.Present;
            }
            if (!Intrinsics.areEqual((Object)bl, (Object)false)) continue;
            isAlien = false;
        }
        return isAlien ? Dictionary.LookupStatus.Alien : Dictionary.LookupStatus.Absent;
    }

    @NotNull
    public final Collection<String> getSuggestions(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Set<SpellerTool> filtered = this.filterCheckers(word);
        if (filtered.isEmpty()) {
            return kotlin.collections.CollectionsKt.emptyList();
        }
        ProgressIndicator progressIndicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getGlobalProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"notNullize(...)");
        ProgressIndicator indicator = progressIndicator;
        Object object = ApplicationUtil.runWithCheckCanceled(() -> GrazieCheckers.getSuggestions$lambda$0(filtered, indicator, word), (ProgressIndicator)indicator);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runWithCheckCanceled(...)");
        return (Collection)object;
    }

    @TestOnly
    public final void awaitConfiguration() {
        CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            int label;
            final /* synthetic */ GrazieCheckers this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        List jobs = SequencesKt.toList((Sequence)JobKt.getJob((CoroutineContext)GrazieCheckers.access$getConfigurationScope$p(this.this$0).getCoroutineContext()).getChildren());
                        Collection $this$toTypedArray$iv = jobs;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        Job[] jobArray = thisCollection$iv.toArray(new Job[0]);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)jobs);
                        this.label = 1;
                        Object object2 = AwaitKt.joinAll((Job[])Arrays.copyOf(jobArray, jobArray.length), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        List jobs = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final RuleFilter filter_delegate$lambda$0() {
        return RuleFilter.Companion.withAllBuiltIn();
    }

    private static final boolean filterCheckers$lambda$0(Set $preferred, SpellerTool checker) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)checker, (String)"checker");
            Iterable $this$any$iv = $preferred;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Language it = (Language)element$iv;
                    boolean bl2 = false;
                    if (!checker.getLang().equalsTo(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean filterCheckers$lambda$1(GrazieCheckers this$0, Set $enabledLanguages, SpellerTool it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.isHunspellAvailable(it.getLang(), $enabledLanguages);
    }

    private static final LinkedHashSet getSuggestions$lambda$0(Set $filtered, ProgressIndicator $indicator, String $word) {
        return CollectionsKt.toLinkedSet((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)$filtered), arg_0 -> GrazieCheckers.getSuggestions$lambda$0$0($indicator, $word, arg_0))));
    }

    private static final Set getSuggestions$lambda$0$0(ProgressIndicator $indicator, String $word, SpellerTool speller) {
        Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
        $indicator.checkCanceled();
        return speller.suggest($word);
    }

    public static final /* synthetic */ void access$setCheckers$p(GrazieCheckers $this, Collection collection) {
        $this.checkers = collection;
    }

    public static final /* synthetic */ Collection access$heavyInit(GrazieCheckers $this) {
        return $this.heavyInit();
    }

    public static final /* synthetic */ CoroutineScope access$getConfigurationScope$p(GrazieCheckers $this) {
        return $this.configurationScope;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0006\u0010\u0017\u001a\u00020\u0013J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00112\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006!"}, d2={"Lcom/intellij/grazie/spellcheck/GrazieCheckers$SpellerTool;", "", "tool", "Lorg/languagetool/JLanguageTool;", "lang", "Lcom/intellij/grazie/jlanguage/Lang;", "speller", "Lorg/languagetool/rules/spelling/SpellingCheckRule;", "<init>", "(Lorg/languagetool/JLanguageTool;Lcom/intellij/grazie/jlanguage/Lang;Lorg/languagetool/rules/spelling/SpellingCheckRule;)V", "getTool", "()Lorg/languagetool/JLanguageTool;", "getLang", "()Lcom/intellij/grazie/jlanguage/Lang;", "getSpeller", "()Lorg/languagetool/rules/spelling/SpellingCheckRule;", "check", "", "word", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "suggest", "", "text", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "", "toString", "intellij.grazie.core"})
    @SourceDebugExtension(value={"SMAP\nGrazieSpellchecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieCheckers$SpellerTool\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,183:1\n10468#2:184\n10890#2,2:185\n10892#2,3:191\n1563#3:187\n1634#3,3:188\n*S KotlinDebug\n*F\n+ 1 GrazieSpellchecker.kt\ncom/intellij/grazie/spellcheck/GrazieCheckers$SpellerTool\n*L\n92#1:184\n92#1:185,2\n92#1:191,3\n93#1:187\n93#1:188,3\n*E\n"})
    public static final class SpellerTool {
        @NotNull
        private final JLanguageTool tool;
        @NotNull
        private final Lang lang;
        @NotNull
        private final SpellingCheckRule speller;

        public SpellerTool(@NotNull JLanguageTool tool2, @NotNull Lang lang, @NotNull SpellingCheckRule speller) {
            Intrinsics.checkNotNullParameter((Object)tool2, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            this.tool = tool2;
            this.lang = lang;
            this.speller = speller;
        }

        @NotNull
        public final JLanguageTool getTool() {
            return this.tool;
        }

        @NotNull
        public final Lang getLang() {
            return this.lang;
        }

        @NotNull
        public final SpellingCheckRule getSpeller() {
            return this.speller;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final Boolean check(@NotNull String word) {
            Boolean bl;
            Intrinsics.checkNotNullParameter((Object)word, (String)"word");
            SpellingCheckRule spellingCheckRule = this.speller;
            synchronized (spellingCheckRule) {
                block4: {
                    boolean bl2 = false;
                    if (!StringsKt.isBlank((CharSequence)word)) break block4;
                    Boolean bl3 = true;
                    return bl3;
                }
                bl = (Boolean)ClassLoaderUtil.computeWithClassLoader((ClassLoader)GraziePlugin.INSTANCE.getClassLoader(), () -> SpellerTool.check$lambda$0$0(this, word));
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Set<String> suggest(@NotNull String text) {
            Set set;
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            SpellingCheckRule spellingCheckRule = this.speller;
            synchronized (spellingCheckRule) {
                boolean bl = false;
                Set set2 = (Set)ClassLoaderUtil.computeWithClassLoader((ClassLoader)GraziePlugin.INSTANCE.getClassLoader(), () -> SpellerTool.suggest$lambda$0$0(this, text));
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl9 : MonitorExitStatement: MONITOREXIT : var2_2
                set = set2;
            }
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"synchronized(...)");
            return set;
        }

        @NotNull
        public final JLanguageTool component1() {
            return this.tool;
        }

        @NotNull
        public final Lang component2() {
            return this.lang;
        }

        @NotNull
        public final SpellingCheckRule component3() {
            return this.speller;
        }

        @NotNull
        public final SpellerTool copy(@NotNull JLanguageTool tool2, @NotNull Lang lang, @NotNull SpellingCheckRule speller) {
            Intrinsics.checkNotNullParameter((Object)tool2, (String)"tool");
            Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
            Intrinsics.checkNotNullParameter((Object)speller, (String)"speller");
            return new SpellerTool(tool2, lang, speller);
        }

        public static /* synthetic */ SpellerTool copy$default(SpellerTool spellerTool, JLanguageTool jLanguageTool, Lang lang, SpellingCheckRule spellingCheckRule, int n, Object object) {
            if ((n & 1) != 0) {
                jLanguageTool = spellerTool.tool;
            }
            if ((n & 2) != 0) {
                lang = spellerTool.lang;
            }
            if ((n & 4) != 0) {
                spellingCheckRule = spellerTool.speller;
            }
            return spellerTool.copy(jLanguageTool, lang, spellingCheckRule);
        }

        @NotNull
        public String toString() {
            return "SpellerTool(tool=" + this.tool + ", lang=" + this.lang + ", speller=" + this.speller + ")";
        }

        public int hashCode() {
            int result = this.tool.hashCode();
            result = result * 31 + this.lang.hashCode();
            result = result * 31 + this.speller.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpellerTool)) {
                return false;
            }
            SpellerTool spellerTool = (SpellerTool)other;
            if (!Intrinsics.areEqual((Object)this.tool, (Object)spellerTool.tool)) {
                return false;
            }
            if (this.lang != spellerTool.lang) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.speller, (Object)spellerTool.speller);
        }

        private static final Boolean check$lambda$0$0(SpellerTool this$0, String $word) {
            Boolean bl;
            RuleMatch[] ruleMatchArray = this$0.speller.match(this$0.tool.getRawAnalyzedSentence($word));
            Intrinsics.checkNotNullExpressionValue((Object)ruleMatchArray, (String)"match(...)");
            if (((Object[])ruleMatchArray).length == 0) {
                if (!this$0.speller.isMisspelled($word)) {
                    bl = true;
                } else {
                    String mutated = $word + StringsKt.last((CharSequence)$word) + StringsKt.last((CharSequence)$word);
                    RuleMatch[] ruleMatchArray2 = this$0.speller.match(this$0.tool.getRawAnalyzedSentence(mutated));
                    Intrinsics.checkNotNullExpressionValue((Object)ruleMatchArray2, (String)"match(...)");
                    bl = ((Object[])ruleMatchArray2).length == 0 ? null : Boolean.valueOf(true);
                }
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        private static final Set suggest$lambda$0$0(SpellerTool this$0, String $text) {
            void $this$flatMapTo$iv$iv;
            RuleMatch[] ruleMatchArray = this$0.speller.match(this$0.tool.getRawAnalyzedSentence($text));
            Intrinsics.checkNotNullExpressionValue((Object)ruleMatchArray, (String)"match(...)");
            Object[] $this$flatMap$iv = ruleMatchArray;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                RuleMatch match = (RuleMatch)element$iv$iv;
                boolean bl = false;
                List list = match.getSuggestedReplacements();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSuggestedReplacements(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    String string2 = $text;
                    int n = match.getFromPos();
                    int n2 = match.getToPos();
                    Intrinsics.checkNotNull((Object)it);
                    CharSequence charSequence = (CharSequence)it;
                    collection.add(((Object)StringsKt.replaceRange((CharSequence)string2, (int)n, (int)n2, (CharSequence)charSequence)).toString());
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
    }
}

