/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.snapshots;

import com.intellij.openapi.project.Project;
import com.intellij.profiler.ProfilerManager;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.profiler.ultimate.UltimateProfilerBundleKt;
import com.intellij.profiler.ultimate.snapshots.SnapshotFolder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\b\t\nB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\u000b"}, d2={"Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator;", "", "<init>", "()V", "validate", "Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationResult;", "path", "Ljava/nio/file/Path;", "ValidationResult", "ValidationSuccess", "ValidationFailure", "intellij.profiler.ultimate"})
public final class SnapshotFolderValidator {
    @NotNull
    public final ValidationResult validate(@NotNull Path path) {
        ValidationResult validationResult;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            validationResult = new ValidationFailure(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.folder.noFolder.text", new Object[0]), ProfilerUsageTriggerCollector.BadSnapshotFolderState.NOT_EXIST, ((Object)path.toAbsolutePath()).toString());
        } else {
            LinkOption[] linkOptionArray2 = new LinkOption[]{};
            validationResult = !Files.isDirectory(path, Arrays.copyOf(linkOptionArray2, linkOptionArray2.length)) ? (ValidationResult)new ValidationFailure(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.folder.notDirectory.text", new Object[0]), ProfilerUsageTriggerCollector.BadSnapshotFolderState.NOT_A_DIRECTORY, ((Object)path.toAbsolutePath()).toString()) : (!Files.isWritable(path) ? (ValidationResult)new ValidationFailure(UltimateProfilerBundleKt.profilerMessage("ui.profiler.welcome.screen.snapshots.folder.write.protected", new Object[0]), ProfilerUsageTriggerCollector.BadSnapshotFolderState.NOT_WRITABLE, ((Object)path.toAbsolutePath()).toString()) : (ValidationResult)ValidationSuccess.INSTANCE);
        }
        return validationResult;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u00070\u0003\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationFailure;", "Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationResult;", "message", "", "Lorg/jetbrains/annotations/Nls;", "folderState", "Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$BadSnapshotFolderState;", "folder", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Ljava/lang/String;Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$BadSnapshotFolderState;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getFolderState", "()Lcom/intellij/profiler/statistics/ProfilerUsageTriggerCollector$BadSnapshotFolderState;", "notifyCreateInTempDirectory", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.profiler.ultimate"})
    public static final class ValidationFailure
    extends ValidationResult {
        @NotNull
        private final String message;
        @NotNull
        private final ProfilerUsageTriggerCollector.BadSnapshotFolderState folderState;
        @NotNull
        private final String folder;

        public ValidationFailure(@NotNull String message, @NotNull ProfilerUsageTriggerCollector.BadSnapshotFolderState folderState, @NotNull String folder) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)folderState, (String)"folderState");
            Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
            super(null);
            this.message = message;
            this.folderState = folderState;
            this.folder = folder;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final ProfilerUsageTriggerCollector.BadSnapshotFolderState getFolderState() {
            return this.folderState;
        }

        public final void notifyCreateInTempDirectory(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object[] objectArray = new Object[]{this.folder, this.message};
            String message = UltimateProfilerBundleKt.profilerMessage("ui.profiler.snapshots.folder.is.bad", objectArray);
            ProfilerManager.INSTANCE.showStickyWarning(message, project, SnapshotFolder.createChooseFolderAction$default(SnapshotFolder.INSTANCE, null, 1, null));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationResult;", "", "<init>", "()V", "Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationFailure;", "Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationSuccess;", "intellij.profiler.ultimate"})
    public static abstract sealed class ValidationResult
    permits ValidationFailure, ValidationSuccess {
        private ValidationResult() {
        }

        public /* synthetic */ ValidationResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationSuccess;", "Lcom/intellij/profiler/ultimate/snapshots/SnapshotFolderValidator$ValidationResult;", "<init>", "()V", "intellij.profiler.ultimate"})
    public static final class ValidationSuccess
    extends ValidationResult {
        @NotNull
        public static final ValidationSuccess INSTANCE = new ValidationSuccess();

        private ValidationSuccess() {
            super(null);
        }
    }
}

