/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ultimate.widget;

import com.intellij.ui.charts.Coordinates;
import com.intellij.ui.charts.Dataset;
import com.intellij.ui.charts.LineChart;
import com.intellij.ui.charts.Overlay;
import com.intellij.util.ui.UIUtil;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u0001\u0012\u0002\b\u00030\u00040\u0003B+\u0012\u0018\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u0012\b\b\u0001\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00028\u00000\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ultimate/widget/ValueDisplay;", "T", "", "Lcom/intellij/ui/charts/Overlay;", "Lcom/intellij/ui/charts/LineChart;", "", "data", "Lcom/intellij/ui/charts/Dataset;", "Lcom/intellij/ui/charts/Coordinates;", "prefix", "", "<init>", "(Lcom/intellij/ui/charts/Dataset;Ljava/lang/String;)V", "getData", "()Lcom/intellij/ui/charts/Dataset;", "getPrefix", "()Ljava/lang/String;", "paintComponent", "", "g", "Ljava/awt/Graphics2D;", "intellij.profiler.ultimate"})
final class ValueDisplay<T extends Number>
extends Overlay<LineChart<Long, T, ?>> {
    @NotNull
    private final Dataset<Coordinates<Long, T>> data;
    @NotNull
    private final String prefix;

    public ValueDisplay(@NotNull Dataset<Coordinates<Long, T>> data2, @Nls @NotNull String prefix) {
        Intrinsics.checkNotNullParameter(data2, (String)"data");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.data = data2;
        this.prefix = prefix;
    }

    @NotNull
    public final Dataset<Coordinates<Long, T>> getData() {
        return this.data;
    }

    @NotNull
    public final String getPrefix() {
        return this.prefix;
    }

    public void paintComponent(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Coordinates current = (Coordinates)CollectionsKt.lastOrNull((Iterable)this.data.getData());
        if (current != null && ((LineChart)this.getChart()).getRanges().getYMaxInitialized()) {
            g.setColor(UIUtil.getLabelDisabledForeground());
            g.drawString(this.prefix, ((LineChart)this.getChart()).getMargins().left, ((LineChart)this.getChart()).getHeight() - 5);
        }
    }
}

