/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.utils;

import com.intellij.jupyter.core.jupyter.helper.ModuleExtensionsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.SystemProperties;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u001e\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u0007H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/jupyter/core/jupyter/utils/JupyterPathUtils;", "", "<init>", "()V", "getFileUserPresentableString", "", "file", "Ljava/nio/file/Path;", "project", "Lcom/intellij/openapi/project/Project;", "getFileNotebookRelativizedString", "notebookPath", "doGetFileNotebookRelativizedString", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterPathUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterPathUtils.kt\ncom/intellij/jupyter/core/jupyter/utils/JupyterPathUtils\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,90:1\n183#2,2:91\n183#2,2:93\n*S KotlinDebug\n*F\n+ 1 JupyterPathUtils.kt\ncom/intellij/jupyter/core/jupyter/utils/JupyterPathUtils\n*L\n24#1:91,2\n71#1:93,2\n*E\n"})
public final class JupyterPathUtils {
    @NotNull
    public static final JupyterPathUtils INSTANCE = new JupyterPathUtils();

    private JupyterPathUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getFileUserPresentableString(@NotNull Path file, @NotNull Project project) {
        Object v0;
        block4: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Sequence sequence = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])ProjectUtil.getModules((Project)project)), JupyterPathUtils::getFileUserPresentableString$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!file.startsWith(it)) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        String modulePath = v0;
        if (modulePath != null) {
            return StringsKt.replace$default((String)((Object)Path.of(modulePath, new String[0]).relativize(file)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        String projectBasePath = project.getBasePath();
        if (projectBasePath != null && file.startsWith(projectBasePath)) {
            Path projectPath = Path.of(projectBasePath, new String[0]);
            return StringsKt.replace$default((String)((Object)projectPath.relativize(file)).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        Path homePath = Path.of(SystemProperties.getUserHome(), new String[0]);
        if (file.startsWith(homePath)) {
            String string = FileUtil.getLocationRelativeToUserHome((String)((Object)file.toAbsolutePath()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
            return string;
        }
        return StringsKt.replace$default((String)((Object)file.toAbsolutePath()).toString(), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    @NotNull
    public final String getFileNotebookRelativizedString(@NotNull Path file, @NotNull Project project, @NotNull Path notebookPath) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)notebookPath, (String)"notebookPath");
        return StringsKt.replace$default((String)this.doGetFileNotebookRelativizedString(file, project, notebookPath), (char)'\\', (char)'/', (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final String doGetFileNotebookRelativizedString(Path file, Project project, Path notebookPath) {
        Object v0;
        block4: {
            void $this$firstOrNull$iv;
            Sequence sequence = SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])ProjectUtil.getModules((Project)project)), JupyterPathUtils::doGetFileNotebookRelativizedString$lambda$0);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                if (!(file.startsWith(it) && notebookPath.startsWith(it))) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        String modulePath = v0;
        Path notebookParent = notebookPath.getParent();
        if (modulePath != null && notebookParent != null) {
            return ((Object)notebookParent.relativize(file)).toString();
        }
        String projectBasePath = project.getBasePath();
        if (projectBasePath != null && file.startsWith(projectBasePath) && notebookPath.startsWith(projectBasePath) && notebookParent != null) {
            return ((Object)notebookParent.relativize(file)).toString();
        }
        Path homePath = Path.of(SystemProperties.getUserHome(), new String[0]);
        if (file.startsWith(homePath)) {
            String string = FileUtil.getLocationRelativeToUserHome((String)((Object)file.toAbsolutePath()).toString());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocationRelativeToUserHome(...)");
            return string;
        }
        return ((Object)file.toAbsolutePath()).toString();
    }

    private static final String getFileUserPresentableString$lambda$0(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ModuleExtensionsKt.getBasePath(it);
    }

    private static final String doGetFileNotebookRelativizedString$lambda$0(Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ModuleExtensionsKt.getBasePath(it);
    }
}

