/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.debugger.agent;

import com.intellij.rt.debugger.agent.CaptureAgent;
import com.intellij.rt.debugger.agent.ClassTransformer;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import org.jetbrains.capture.org.objectweb.asm.ClassVisitor;
import org.jetbrains.capture.org.objectweb.asm.MethodVisitor;

class StateFlowTransformer
implements ClassFileTransformer {
    StateFlowTransformer() {
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) {
        boolean shouldTransform;
        if (!"kotlinx/coroutines/flow/StateFlowImpl".equals(className)) {
            return classfileBuffer;
        }
        ClassTransformer transformer = new ClassTransformer(className, classfileBuffer, 0, loader);
        final boolean[] isIjFork = new boolean[]{false};
        final boolean[] isLatestStableIjFork = new boolean[]{true};
        byte[] bytes = transformer.accept(new ClassVisitor(589824, transformer.writer){

            @Override
            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor mv = super.visitMethod(access, name, descriptor, signature, exceptions);
                switch (name) {
                    case "<init>": {
                        return new WrappingTransformer(mv, 1);
                    }
                    case "updateInner": {
                        isIjFork[0] = true;
                        return new WrappingTransformer(mv, 1);
                    }
                    case "emitInner": {
                        isLatestStableIjFork[0] = false;
                        break;
                    }
                    case "getValue": 
                    case "updateState": {
                        return new UnwrappingTransformer(mv, new Predicate(){

                            @Override
                            public boolean test(int opcode, String owner, String name, String descriptor) {
                                return StateFlowTransformer.isAtomicGet(opcode, owner, name);
                            }
                        });
                    }
                    case "collect": {
                        return new CompareUnwrappedTransformer(mv);
                    }
                }
                return mv;
            }
        }, 0, false);
        boolean bl = shouldTransform = isIjFork[0] && isLatestStableIjFork[0];
        if (!shouldTransform) {
            return classfileBuffer;
        }
        CaptureAgent.storeClassForDebug(className, bytes);
        return bytes;
    }

    private static boolean isAtomicGet(int opcode, String owner, String name) {
        return opcode == 182 && "java/util/concurrent/atomic/AtomicReferenceFieldUpdater".equals(owner) && "get".equals(name);
    }

    private static void wrapInternal(MethodVisitor mv) {
        mv.visitMethodInsn(184, "kotlinx/coroutines/flow/internal/FlowValueWrapperInternalKt", "wrapInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
    }

    private static void unwrapInternal(MethodVisitor mv) {
        mv.visitMethodInsn(184, "kotlinx/coroutines/flow/internal/FlowValueWrapperInternalKt", "unwrapInternal", "(Ljava/lang/Object;)Ljava/lang/Object;", false);
    }

    private static interface Predicate {
        public boolean test(int var1, String var2, String var3, String var4);
    }

    private static class CompareUnwrappedTransformer
    extends MethodVisitor {
        public CompareUnwrappedTransformer(MethodVisitor mv) {
            super(589824, mv);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            if (opcode == 184 && "kotlin/jvm/internal/Intrinsics".equals(owner) && "areEqual".equals(name)) {
                StateFlowTransformer.unwrapInternal(this.mv);
                this.mv.visitInsn(95);
                StateFlowTransformer.unwrapInternal(this.mv);
                this.mv.visitInsn(95);
            }
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }

    private static class UnwrappingTransformer
    extends MethodVisitor {
        private final Predicate predicate;

        public UnwrappingTransformer(MethodVisitor mv, Predicate predicate) {
            super(589824, mv);
            this.predicate = predicate;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            if (this.predicate.test(opcode, owner, name, descriptor)) {
                StateFlowTransformer.unwrapInternal(this.mv);
            }
        }
    }

    private static class WrappingTransformer
    extends MethodVisitor {
        private final int index;

        public WrappingTransformer(MethodVisitor mv, int index) {
            super(589824, mv);
            this.index = index;
        }

        @Override
        public void visitVarInsn(int opcode, int varIndex) {
            super.visitVarInsn(opcode, varIndex);
            if (opcode == 25 && varIndex == this.index) {
                StateFlowTransformer.wrapInternal(this.mv);
            }
        }
    }
}

